<?php
function preferences_settings_title(){
	return _("Preferences");
}

function preferences_settings_order(){
	return 0;
}

function preferences_settings_html(){ ?>
	<fieldset>
		<legend><?=_("General")?></legend>
		<table class="options">
			<tr>
				<th><label for="preferences_language"><?=_("Language")?></label></th>
				<td>
				<select id="preferences_language">
<?php 	foreach($GLOBALS["language"]->getLanguages() as $lang=>$title){ 
?>									<option value="<?=$lang?>"><?=$title?></option>
<?php   } ?>
				
				</select>
				</td>
			</tr>
			
			<tr>
				<th><label for="preferences_theme"><?=_("Color theme")?></label></th>
				<td>
				<select id="preferences_theme">
<?php
	foreach(preferences_get_themes() as $theme){?>
					<option value="<?=$theme?>"><?=$theme?></option>
<?php	} ?>
				</select>
				</td>
			</tr>

			<tr>
				<th><label for="preferences_autologout"><?=_("Automatic logout")?></label></th>
				<td>
				<select id="preferences_autologout">
					<option value="0"><?=_("Never")?></option>
					<option value="900000"><?=sprintf(_("After %s minutes"),15)?></option>
					<option value="1800000"><?=sprintf(_("After %s minutes"),30)?></option>
					<option value="2700000"><?=sprintf(_("After %s minutes"),45)?></option>
					<option value="3600000"><?=sprintf(_("After %s minutes"),60)?></option>
					<option value="5400000"><?=sprintf(_("After %s minutes"),90)?></option>
					<option value="7200000"><?=sprintf(_("After %s minutes"),120)?></option>
				</select>
				</td>
			</tr>
		</table>
	</fieldset>

	<fieldset>
		<legend><?=_("Folder Options")?></legend>
		<table class="options">
			<tr>
				<th><label for="preferences_startupfolder"><?=_("Startup folder")?></label></th>
				<td>
					<select id="preferences_startupfolder">
						<option value="inbox"><?=_("Inbox")?></option>
						<option value="last"><?=_("Last opened folder")?></option>
					</select>
				</td>
			</tr>

			<tr>
				<th><label for="preferences_rowcount"><?=_("Number of items to display per page")?></label></th>
				<td>
					<select id="preferences_rowcount">
						<option value="10">10</option>
						<option value="15">15</option>
						<option value="20">20</option>
						<option value="25">25</option>
						<option value="30">30</option>
						<option value="35">35</option>
						<option value="40">40</option>
						<option value="45">45</option>
						<option value="50">50</option>
						<option value="75">75</option>
						<option value="100">100</option>
					</select>
				</td>
			</tr>
			
			<tr>
				<th><label for="preferences_previewpane"><?=_("Reading pane visible")?></label></th>
				<td>
					<select id="preferences_previewpane">
						<option value="right"><?=_("Right")?></option>
						<option value="bottom"><?=_("Bottom")?></option>
						<option value="off"><?=_("Off")?></option>
					</select>
				</td>
			</tr>
		</table>
	</fieldset>
	<fieldset>
		<legend><?=_("Incoming Mail")?></legend>
		<table class="options">
			<tr>
				<th><label for="preferences_mailcheck"><?=_("New mail check timeout")?></label></th>
				<td>
				<select id="preferences_mailcheck">
					<option value="15000">15 <?=_("seconds")?></option>
					<option value="30000">30 <?=_("seconds")?></option>
					<option value="60000">1 <?=_("minute")?></option>
					<option value="150000">2,5 <?=_("minutes")?></option>
					<option value="300000">5 <?=_("minutes")?></option>
					<option value="default"><?=_("Server default")?></option>
				</select>
				</td>
			</tr>

			<tr>
				<th colspan="2"><label><?=_("How to respond to requests for read receipts")?></label></th>
			</tr>
			<tr>
				<th colspan="2"><input id="preferences_readreceipt_always" type="radio" name="preferences_readreceipt" class="checkbox"><label for="preferences_readreceipt_always"><?=_("Always send a response")?></label></th>
			</tr>
			<tr>
				<th colspan="2"><input id="preferences_readreceipt_never" type="radio" name="preferences_readreceipt" class="checkbox"><label for="preferences_readreceipt_never"><?=_("Never send a response")?></label></th>
			</tr>
			<tr>
				<th colspan="2"><input id="preferences_readreceipt_ask" type="radio" name="preferences_readreceipt" class="checkbox"><label for="preferences_readreceipt_ask"><?=_("Ask me before sending a response")?></label></th>
			</tr>
		</table>
	</fieldset>
	
<?php } 

function preferences_get_themes(){
	$themes = array("default");
	$dir = "client/layout/themes";
	if (is_dir($dir)){
		$dh = opendir($dir);
		while(($entry = readdir($dh))!==false){
			if (is_dir($dir."/".$entry) && is_file($dir."/".$entry."/theme.css")){
				$themes[] = $entry;
			}
		}
	}
	return $themes;
}


?>
