<?php

function getDialogTitle() {
	return _("Add/Edit rule");
}

function getIncludes(){
	return array(
			"client/layout/js/rule.js",
			"client/layout/css/rule.css",
		);
}

function getJavaScript_onload(){ 
	$internalid = get("internalid", false);
	if ($internalid !== false){
?>
	var rule = window.opener.module.getRule(<?=intval($internalid)?>);

	if(rule)
		showRule(rule);
<?php 
	} // if $internalid

} // getJavaScript_onload						

function getBody(){ ?>
		<fieldset>
			<legend><?=_("Rule")?></legend>
			<table class="options">
				<tr><th><label for="name"><?=_("Rule name")?></label></th><td><input id="name" type="text" size="40" /></td><td class="buttonspace"></td></tr>
			</table>
		</fieldset>
		<fieldset>
			<legend><?=_("With the following properties")?></legend>
			<table class="options">
				<tr><th><label for="cond_from"><?=_("From field contains")?></label></th><td><input id="cond_from" type="text" size="40" /></td><td class="buttonspace"><input type="button" class="addressbookbutton" onclick="getFromAddressBook('cond_from', 'email_single')"></td></tr>
				<tr><th><label for="cond_subject"><?=_("Subject contains")?></label></th><td><input id="cond_subject" type="text" size="40" /></td><td class="buttonspace"></td></tr>
				<tr><th><label for="cond_priority"><?=_("Priority")?></th><td>
                		<select id="cond_priority" class="combobox">
                			<option value="-1" selected></option>
                			<option value="0"><?=_("Low")?></option>
                			<option value="1"><?=_("Normal")?></option>
                			<option value="2"><?=_("High")?></option>
                		</select>
					</td><td class="buttonspace"></td></tr>
			</table>
		</fieldset>
		<fieldset>
			<legend><?=_("Sent to")?></legend>
			<table class="options">
				<tr><th><label for="cond_sent_to"><?=_("Contact or distributionlist")?></label></th><td><input id="cond_sent_to" type="text" size="40" /></td><td class="buttonspace"><input type="button" class="addressbookbutton" onclick="getFromAddressBook('cond_sent_to')"></td></tr>
				<tr><th><label for="cond_sent_to_me"><?=_("Sent only to me")?></label></th><td><input id="cond_sent_to_me" type="checkbox"/></td><td class="buttonspace"></td></tr>
			</table>
		</fieldset>
		<fieldset>
			<legend><?=_("Perform the following action")?></legend>
			<table>
			<tr><th><input type="radio" name="action" id="action_move"/><label for="action_move"><?=_("Move to ")?> <a href="#" onclick="selectFolder('action_move_folder')"><span id="action_move_folder"><?=_("folder")?></span></a></label></th></tr>
			<tr><th><input type="radio" name="action" id="action_copy"/><label for="action_copy"><?=_("Copy to ")?> <a href="#" onclick="selectFolder('action_copy_folder')"><span id="action_copy_folder"><?=_("folder")?></span></a></label></th></tr>
			<tr><th><input type="radio" name="action" id="action_delete"/><label for="action_delete"><?=_("Delete the message")?></label></th></tr>
			<tr><th><input type="radio" name="action" id="action_forward"/><label for="action_forward"><?=_("Forward to")?></th><td><input id="action_forward_address" type="text" size="40"/></td><td class="buttonspace"><input type="button" class="addressbookbutton" onclick="getFromAddressBook('action_forward_address')"></td></tr>
			</table>
		</fieldset>
		<input type="hidden" id="sequence"/>
		<?=createConfirmButtons("if(submitRule()) window.close; else window.focus();")?>
<?php } // getBody
?>
