/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef STR1252_H
#define STR1252_H

#include <stdlib.h>

void memxfrm_str1252(char *str, int len);
void strxfrm_str1252(char *str);

void strupr_str1252(char *str);
void strlwr_str1252(char *str);

int stricmp_str1252(char *str1, char *str2);
int strnicmp_str1252(char *str1, char *str2, int n);
int strcasecmp_str1252(char *str1, char *str2);
int strncasecmp_str1252(char *str1, char *str2, int n);

int memcasecmp_str1252(char *str1, unsigned int len1, char *str2, unsigned int len2);
int memcmp_str1252(char *str1, unsigned int len1, char *str2, unsigned int len2);
int memsubstr_str1252(const void *haystack, size_t haystacksize, const void *needle, size_t needlesize);

int strcmp_str1252(char *str1, char *str2);

char* stristr_str1252(char *haystack, char *needle);
char* strcasestr_str1252(char *haystack, char *needle);
char* strstr_str1252(char *haystack, char *needle);

#endif
