/*
 * Copyright (C) 2005 - 2008  Zarafa B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of the Program
 * under the AGPL does not imply a trademark license. Therefore any rights,
 * title and interest in our trademarks remain entirely with us.
 * However, if you propagate an unmodified version of the Program you are 
 * required to use the term "Zarafa" to indicate that you distribute the 
 * Program. Furthermore you may use our trademarks where it is necessary to 
 * indicate the intended purpose of a product or service provided you use it in 
 * accordance with honest practices in industrial or commercial matters.
 * If you want to propagate modified versions of the Program under the name
 * "Zarafa" or "Zarafa Server", you may only do so if you have a written
 * permission by Zarafa B.V. (to acquire a permission please contact Zarafa at
 * trademark@zarafa.com).
 * The user interface of the software displays a attribution notice containing
 * the term "Zarafa" and/or the Logo of Zarafa. You have to preserve these
 * attribution notices when you propagate unmodified or modified versions of
 * the Program.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef RECURRENCESTATE_H
#define RECURRENCESTATE_H

#include <list>
#include <string>

class RecurrenceState {
public:
    RecurrenceState();
    RecurrenceState(char *lpData, unsigned int ulLen);
    ~RecurrenceState();

    HRESULT ParseBlob(char *lpData, unsigned int ulLen);
    HRESULT GetBlob(char **lpData, unsigned int *lpulLen);

    class Exception {
    public:
        unsigned int ulStartDateTime;
        unsigned int ulEndDateTime;
        unsigned int ulOriginalStartDate;
        unsigned int ulOverrideFlags;
        std::string strSubject;
        unsigned int ulMeetingType;
        unsigned int ulReminderDelta;
        unsigned int ulReminderSet;
        std::string strLocation;
        unsigned int ulBusyStatus;
        unsigned int ulAttachment;
        unsigned int ulSubType;
        unsigned int ulAppointmentColor;
    };
    
    class ExtendedException {
    public:
        unsigned int ulChangeHighlightValue;
        std::string strReserved;
        std::string strReservedBlock1;
        unsigned int ulStartDateTime;
        unsigned int ulEndDateTime;
        unsigned int ulOriginalStartDate;
        std::string strWideCharSubject;
        std::string strWideCharLocation;
        std::string strReservedBlock2;
    };


    unsigned int ulReaderVersion;
    unsigned int ulWriterVersion;
    unsigned int ulRecurFrequency;
    unsigned int ulPatternType;
    unsigned int ulCalendarType;
    unsigned int ulFirstDateTime;
    unsigned int ulPeriod;
    unsigned int ulSlidingFlag;
    unsigned int ulWeekDays;
    unsigned int ulDay;
    unsigned int ulWeekNumber;
    unsigned int ulEndType;
    unsigned int ulOccurrenceCount;
    unsigned int ulFirstDOW;
    unsigned int ulDeletedInstanceCount;
    std::list<unsigned int> lstDeletedInstanceDates;
    unsigned int ulModifiedInstanceCount;
    std::list<unsigned int> lstModifiedInstanceDates;
    unsigned int ulStartDate;
    unsigned int ulEndDate;

    unsigned int ulReaderVersion2;
    unsigned int ulWriterVersion2;
    unsigned int ulStartTimeOffset;
    unsigned int ulEndTimeOffset;
    unsigned int ulExceptionCount;

    std::list<Exception> lstExceptions;
    
    std::string strReservedBlock1;
    std::list<ExtendedException> lstExtendedExceptions;
    
    std::string strReservedBlock2;
};

#define ARO_SUBJECT			0x0001
#define ARO_MEETINGTYPE 	0x0002
#define ARO_REMINDERDELTA 	0x0004
#define ARO_REMINDERSET		0x0008
#define ARO_LOCATION		0x0010
#define ARO_BUSYSTATUS		0x0020
#define ARO_ATTACHMENT		0x0040
#define ARO_SUBTYPE			0x0080
#define ARO_APPTCOLOR		0x0100
#define ARO_EXCEPTIONAL_BODY 0x0200


#endif
