/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;

public final class ApplicationLocales {
    protected ArrayList localeLabels = new ArrayList();
    protected ArrayList localeValues = new ArrayList();
    protected ArrayList supportedLocales = new ArrayList();

    public ApplicationLocales(ActionServlet servlet) {
        Locale[] list = Locale.getAvailableLocales();
        MessageResources resources = (MessageResources)servlet.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        if (resources == null) {
            return;
        }
        String config = resources.getConfig();
        if (config == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(config, list[i]);
                if (bundle == null || !list[i].equals(bundle.getLocale())) continue;
                this.localeLabels.add(list[i].getDisplayName());
                this.localeValues.add(list[i].toString());
                this.supportedLocales.add(list[i]);
                continue;
            }
            catch (Exception ex) {
                servlet.log("Missing locale " + list[i]);
            }
        }
    }

    public List getLocaleLabels() {
        return this.localeLabels;
    }

    public List getLocaleValues() {
        return this.localeValues;
    }

    public List getSupportedLocales() {
        return this.supportedLocales;
    }
}

