/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.naming.NamingEntry;

public class NamingContextBindingsEnumeration
implements NamingEnumeration {
    protected Enumeration enumeration;
    private Context ctx;

    public NamingContextBindingsEnumeration(Vector entries, Context ctx) {
        this.enumeration = entries.elements();
        this.ctx = ctx;
    }

    public NamingContextBindingsEnumeration(Enumeration enumeration, Context ctx) {
        this.enumeration = enumeration;
        this.ctx = ctx;
    }

    public Object next() throws NamingException {
        return this.nextElementInternal();
    }

    public boolean hasMore() throws NamingException {
        return this.enumeration.hasMoreElements();
    }

    public void close() throws NamingException {
    }

    public boolean hasMoreElements() {
        return this.enumeration.hasMoreElements();
    }

    public Object nextElement() {
        try {
            return this.nextElementInternal();
        }
        catch (NamingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private Object nextElementInternal() throws NamingException {
        NamingEntry entry = (NamingEntry)this.enumeration.nextElement();
        if (entry.type == 2 || entry.type == 1) {
            try {
                this.ctx.lookup(new CompositeName(entry.name));
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NamingException(e.getMessage());
            }
        }
        return new Binding(entry.name, entry.value.getClass().getName(), entry.value, true);
    }
}

