/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        String realmName;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            if (ssoId != null) {
                this.associate(ssoId, this.getSession(request, true));
            }
            return true;
        }
        if (ssoId != null) {
            if (this.debug >= 1) {
                this.log("SSO Id " + ssoId + " set; attempting reauthentication");
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String authorization = request.getAuthorization();
        if (authorization != null) {
            String username = this.parseUsername(authorization);
            String password = this.parsePassword(authorization);
            principal = this.context.getRealm().authenticate(username, password);
            if (principal != null) {
                this.register(request, response, principal, "BASIC", username, password);
                return true;
            }
        }
        if ((realmName = config.getRealmName()) == null) {
            realmName = hreq.getServerName() + ":" + hreq.getServerPort();
        }
        hres.setHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        hres.setStatus(401);
        return false;
    }

    protected String parseUsername(String authorization) {
        if (!authorization.toLowerCase().startsWith("basic ")) {
            return null;
        }
        String unencoded = new String(Base64.decode((authorization = authorization.substring(6).trim()).getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String username = unencoded.substring(0, colon);
        return username;
    }

    protected String parsePassword(String authorization) {
        if (!authorization.startsWith("Basic ")) {
            return null;
        }
        String unencoded = new String(Base64.decode((authorization = authorization.substring(6).trim()).getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon < 0) {
            return null;
        }
        String password = unencoded.substring(colon + 1);
        return password;
    }
}

