/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.calendar;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.prefs.calendar.CalendarOptionsPanelController;
import tr.prefs.calendar.CalendarPrefs;
import tr.prefs.calendar.TimeZones;

final class CalendarPrefsPanel
extends JPanel {
    private final CalendarOptionsPanelController controller;
    private static Vector<String> tzlist;
    private JButton folderButton;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JCheckBox requiredCheckBox;
    private JComboBox timezoneCombo;
    private JLabel timezoneLabel;

    CalendarPrefsPanel(CalendarOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.requiredCheckBox = new JCheckBox();
        this.folderButton = new JButton();
        this.folderTextField = new JTextField();
        this.folderTextField.getDocument().addDocumentListener(new FolderDocumentListener());
        this.folderLabel = new JLabel();
        this.timezoneLabel = new JLabel();
        this.timezoneCombo = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder(""));
        Mnemonics.setLocalizedText((AbstractButton)this.requiredCheckBox, (String)NbBundle.getMessage(CalendarPrefsPanel.class, (String)"CTL_Required"));
        this.requiredCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.requiredCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.RequiredCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)NbBundle.getMessage(CalendarPrefsPanel.class, (String)"CTL_Browse"));
        this.folderButton.setMaximumSize(new Dimension(90, 26));
        this.folderButton.setMinimumSize(new Dimension(90, 26));
        this.folderButton.setPreferredSize(new Dimension(90, 26));
        this.folderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.folderButtonbrowse(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(CalendarPrefsPanel.class, (String)"CTL_Folder"));
        this.folderLabel.setMaximumSize(new Dimension(80, 23));
        this.folderLabel.setMinimumSize(new Dimension(80, 23));
        this.folderLabel.setPreferredSize(new Dimension(80, 23));
        Mnemonics.setLocalizedText((JLabel)this.timezoneLabel, (String)NbBundle.getMessage(CalendarPrefsPanel.class, (String)"CTL_TimeZone"));
        this.timezoneLabel.setMaximumSize(new Dimension(80, 23));
        this.timezoneLabel.setMinimumSize(new Dimension(80, 23));
        this.timezoneLabel.setPreferredSize(new Dimension(80, 23));
        this.timezoneCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CalendarPrefsPanel.this.timezoneChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(22, 22, 22).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.timezoneLabel, -1, -1, Short.MAX_VALUE).add((Component)this.folderLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.timezoneCombo, 0, 187, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.folderTextField, -1, 184, Short.MAX_VALUE).add(3, 3, 3))).addPreferredGap(0).add((Component)this.folderButton, -2, -1, -2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.requiredCheckBox, -1, 271, Short.MAX_VALUE).add(141, 141, 141)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.requiredCheckBox).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.folderButton, -2, -1, -2).add((Component)this.folderTextField, -2, -1, -2).add((Component)this.folderLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timezoneCombo, -2, -1, -2).add((Component)this.timezoneLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void timezoneChanged(ActionEvent evt) {
        this.controller.changed();
    }

    private void RequiredCheckBoxActionPerformed(ActionEvent evt) {
        this.enableDisableFields();
        this.controller.changed();
    }

    private void enableDisableFields() {
        this.folderLabel.setEnabled(this.requiredCheckBox.isSelected());
        this.folderTextField.setEnabled(this.requiredCheckBox.isSelected());
        this.folderButton.setEnabled(this.requiredCheckBox.isSelected());
        this.timezoneLabel.setEnabled(this.requiredCheckBox.isSelected());
        this.timezoneCombo.setEnabled(this.requiredCheckBox.isSelected());
    }

    private void folderButtonbrowse(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setSelectedFile(new File(this.folderTextField.getText()));
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.folderTextField.setText(fc.getSelectedFile().getCanonicalPath());
            }
            catch (Exception ex) {
                this.folderTextField.setText("");
            }
        }
    }

    void load() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doLoad();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CalendarPrefsPanel.this.doLoad();
                }
            });
        }
    }

    private void doLoad() {
        this.requiredCheckBox.setSelected(CalendarPrefs.isICalendarRequired());
        this.folderTextField.setText(CalendarPrefs.getICalendarPath());
        this.initTimeZoneItems();
        this.timezoneCombo.setModel(new DefaultComboBoxModel<String>(tzlist));
        this.timezoneCombo.setMaximumRowCount(30);
        this.timezoneCombo.setSelectedItem(CalendarPrefs.getTimeZoneID());
        this.enableDisableFields();
    }

    private void initTimeZoneItems() {
        tzlist = new Vector();
        tzlist.add("");
        for (String id : TimeZones.IDS) {
            tzlist.add(id);
        }
        Collections.sort(tzlist);
    }

    void store() {
        CalendarPrefs.setICalendarRequired(this.requiredCheckBox.isSelected());
        if (this.validPath()) {
            CalendarPrefs.setICalendarPath(this.tidyPath(this.folderTextField.getText()));
        } else {
            CalendarPrefs.setICalendarPath("");
        }
        String tzid = (String)this.timezoneCombo.getSelectedItem();
        if (tzid != null) {
            CalendarPrefs.setTimeZoneID(tzid);
        }
    }

    boolean valid() {
        return this.requiredCheckBox.isSelected() ? this.validPath() : true;
    }

    private boolean validPath() {
        String path = this.tidyPath(this.folderTextField.getText());
        return path.length() == 0 || new File(path).isDirectory();
    }

    private String tidyPath(String path) {
        path = path.trim();
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1).trim();
        }
        return path;
    }

    private class FolderDocumentListener
    implements DocumentListener {
        private FolderDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            CalendarPrefsPanel.this.controller.changed();
        }

        public void removeUpdate(DocumentEvent e) {
            CalendarPrefsPanel.this.controller.changed();
        }

        public void changedUpdate(DocumentEvent e) {
            CalendarPrefsPanel.this.controller.changed();
        }
    }
}

