/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Time;
import net.fortuna.ical4j.model.TimeZone;

public class DateTime
extends Date {
    private static final long serialVersionUID = -6407231357919440387L;
    private static final String DEFAULT_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final DateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final DateFormat DEFAULT_FORMAT;
    private static final DateFormat LENIENT_DEFAULT_FORMAT;
    private Time time;
    private TimeZone timezone;

    public DateTime() {
        super(0);
        this.time = new Time(System.currentTimeMillis(), this.getFormat().getTimeZone());
    }

    public DateTime(boolean utc) {
        this();
        this.setUtc(utc);
    }

    public DateTime(long time) {
        super(time, 0);
        this.time = new Time(time, this.getFormat().getTimeZone());
    }

    public DateTime(java.util.Date date) {
        super(date.getTime(), 0);
        this.time = new Time(date.getTime(), this.getFormat().getTimeZone());
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                this.setUtc(true);
            } else {
                this.setTimeZone(dateTime.getTimeZone());
            }
        }
    }

    public DateTime(String value) throws ParseException {
        this(value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime(String value, TimeZone timezone) throws ParseException {
        this();
        try {
            DateFormat dateFormat = UTC_FORMAT;
            synchronized (dateFormat) {
                this.setTime(UTC_FORMAT.parse(value).getTime());
            }
            this.setUtc(true);
        }
        catch (ParseException pe) {
            DateFormat dateFormat = DEFAULT_FORMAT;
            synchronized (dateFormat) {
                if (timezone != null) {
                    DEFAULT_FORMAT.setTimeZone(timezone);
                    this.setTime(DEFAULT_FORMAT.parse(value).getTime());
                } else {
                    LENIENT_DEFAULT_FORMAT.setTimeZone(this.getFormat().getTimeZone());
                    this.setTime(LENIENT_DEFAULT_FORMAT.parse(value).getTime());
                }
            }
            this.setTimeZone(timezone);
        }
    }

    public final void setTime(long time) {
        super.setTime(time);
        this.time.setTime(time);
    }

    public final boolean isUtc() {
        return this.time.isUtc();
    }

    public final void setUtc(boolean utc) {
        this.setTimeZone(null);
        if (utc) {
            this.getFormat().setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
            this.time = new Time(this.time, this.getFormat().getTimeZone());
        }
    }

    public final void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            this.getFormat().setTimeZone(timezone);
        } else {
            this.getFormat().setTimeZone(TimeZone.getDefault());
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone());
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        b.append('T');
        b.append(this.time.toString());
        return b.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof DateTime) {
            return this.time.equals(((DateTime)arg0).time) && super.equals(arg0);
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return this.time.hashCode() + super.hashCode();
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        UTC_FORMAT.setLenient(false);
        DEFAULT_FORMAT = new SimpleDateFormat(DEFAULT_PATTERN);
        DEFAULT_FORMAT.setLenient(false);
        LENIENT_DEFAULT_FORMAT = new SimpleDateFormat(DEFAULT_PATTERN);
    }
}

