/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class TabbedAdapter
extends TabbedContainer
implements Tabbed,
Tabbed.Accessor,
SlideController {
    public static final int DOCUMENT = 1;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final boolean DEBUG = Debug.isLoggable(TabbedAdapter.class);
    private PropertyChangeListener tooltipListener;
    private PropertyChangeListener weakTooltipListener;

    public TabbedAdapter(int n) {
        super(null, n, (WinsysInfoForTabbed)new WinsysInfo());
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = TabbedAdapter.this.getSelectionModel().getSelectedIndex();
                if (n != -1) {
                    TabbedAdapter.this.fireStateChanged();
                }
            }
        });
    }

    public void addTopComponent(String string, Icon icon, TopComponent topComponent, String string2) {
        this.insertComponent(string, icon, (Component)topComponent, string2, this.getTabCount());
    }

    public TopComponent getTopComponentAt(int n) {
        if (n == -1) {
            return null;
        }
        return (TopComponent)this.getModel().getTab(n).getComponent();
    }

    public TopComponent getSelectedTopComponent() {
        int n = this.getSelectionModel().getSelectedIndex();
        return n == -1 ? null : this.getTopComponentAt(n);
    }

    public void requestAttention(TopComponent topComponent) {
        int n = this.indexOf((Component)topComponent);
        if (n >= 0) {
            this.requestAttention(n);
        } else {
            Logger.getAnonymousLogger().fine("RequestAttention on component unknown to container: " + topComponent);
        }
    }

    public void cancelRequestAttention(TopComponent topComponent) {
        int n = this.indexOf((Component)topComponent);
        if (n < 0) {
            throw new IllegalArgumentException("TopComponent " + topComponent + " is not a child of this container");
        }
        this.cancelRequestAttention(n);
    }

    public void insertComponent(String string, Icon icon, Component component, String string2, int n) {
        TabData tabData = new TabData((Object)component, icon, string, string2);
        if (DEBUG) {
            TabbedAdapter.debugLog("InsertTab: " + string + " hash:" + System.identityHashCode(component));
        }
        this.getModel().addTab(n, tabData);
        component.addPropertyChangeListener("ToolTipText", this.getTooltipListener(component));
    }

    public void setSelectedComponent(Component component) {
        int n = this.indexOf(component);
        if (n == -1 && null != component) {
            throw new IllegalArgumentException("Component not a child of this control: " + component);
        }
        this.getSelectionModel().setSelectedIndex(n);
    }

    public TopComponent[] getTopComponents() {
        ComponentConverter componentConverter = this.getComponentConverter();
        TabData[] tabDataArray = this.getModel().getTabs().toArray(new TabData[0]);
        TopComponent[] topComponentArray = new TopComponent[this.getModel().size()];
        for (int i = 0; i < tabDataArray.length; ++i) {
            topComponentArray[i] = (TopComponent)componentConverter.getComponent(tabDataArray[i]);
        }
        return topComponentArray;
    }

    public void removeComponent(Component component) {
        int n = this.indexOf(component);
        this.getModel().removeTab(n);
        component.removePropertyChangeListener("ToolTipText", this.getTooltipListener(component));
        if (this.getModel().size() == 0) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addComponents(Component[] componentArray, String[] stringArray, Icon[] iconArray, String[] stringArray2) {
        ArrayList arrayList = new ArrayList(componentArray.length);
        TabData[] tabDataArray = new TabData[componentArray.length];
        for (int i = 0; i < componentArray.length; ++i) {
            TabData tabData;
            tabDataArray[i] = tabData = new TabData((Object)componentArray[i], iconArray[i], stringArray[i], stringArray2[i]);
            componentArray[i].addPropertyChangeListener("ToolTipText", this.getTooltipListener(componentArray[i]));
        }
        this.getModel().addTabs(0, tabDataArray);
    }

    public void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        int n;
        if (topComponent == null && topComponentArray.length > 0) {
            topComponent = topComponentArray[0];
            Logger.getLogger(TabbedAdapter.class.getName()).warning("Selected component is null although open components are " + Arrays.asList(topComponentArray));
        }
        int n2 = this.getModel().size();
        this.detachTooltipListeners(this.getModel().getTabs());
        TabData[] tabDataArray = new TabData[topComponentArray.length];
        int n3 = -1;
        for (n = 0; n < topComponentArray.length; ++n) {
            TopComponent topComponent2 = topComponentArray[n];
            Image image = topComponent2.getIcon();
            String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent2);
            tabDataArray[n] = new TabData((Object)topComponent2, (Icon)(image == null ? null : new ImageIcon(image)), string == null ? "" : string, topComponent2.getToolTipText());
            if (topComponent == topComponentArray[n]) {
                n3 = n;
            }
            topComponent2.addPropertyChangeListener("ToolTipText", this.getTooltipListener((Component)topComponent2));
        }
        assert (topComponent != null && n3 != -1) : "Tried to set a selected component that was  not in the array of open components. ToSelect: " + topComponent + " ToSelectName=" + topComponent.getDisplayName() + " ToSelectClass=" + topComponent.getClass() + " open components: " + Arrays.asList(topComponentArray);
        this.getModel().setTabs(tabDataArray);
        if (n3 != -1) {
            this.getSelectionModel().setSelectedIndex(n3);
        } else if (topComponent != null) {
            Logger.getAnonymousLogger().warning("Tried toset a selected component that was not in the array of open components.  ToSelect: " + topComponent + " components: " + Arrays.asList(topComponentArray));
        }
        n = this.getModel().size();
        if (n2 != 0 && n == 0) {
            this.revalidate();
            this.repaint();
        }
    }

    private void detachTooltipListeners(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JComponent jComponent = (JComponent)((TabData)iterator.next()).getComponent();
            jComponent.removePropertyChangeListener("ToolTipText", this.getTooltipListener(jComponent));
        }
    }

    public Object getConstraintForLocation(Point point, boolean bl) {
        String string;
        int n = this.tabForCoordinate(point);
        if (n != -1) {
            int n2 = this.dropIndexOfPoint(point);
            return n2 < 0 ? null : Integer.valueOf(n2);
        }
        if (bl && (string = this.getSideForLocation(point)) != null) {
            return string;
        }
        int n3 = this.dropIndexOfPoint(point);
        return n3 < 0 ? null : Integer.valueOf(n3);
    }

    public Shape getIndicationForLocation(Point point, TopComponent topComponent, Point point2, boolean bl) {
        Object object;
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(0, 0);
        int n = this.tabForCoordinate(point);
        if (n != -1 && (object = this.getDropIndication(topComponent, point)) != null) {
            return object;
        }
        object = bl ? this.getSideForLocation(point) : null;
        double d = 0.25;
        if (object == "top") {
            return new Rectangle(0, 0, rectangle.width, (int)((double)rectangle.height * d));
        }
        if (object == "left") {
            return new Rectangle(0, 0, (int)((double)rectangle.width * d), rectangle.height);
        }
        if (object == "right") {
            return new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d), rectangle.height);
        }
        if (object == "bottom") {
            return new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width, (int)((double)rectangle.height * d));
        }
        Shape shape = this.getDropIndication(topComponent, point);
        if (shape != null) {
            return shape;
        }
        if (point2 != null && this.indexOf((Component)topComponent) != -1) {
            return this.getStartingIndication(point2, point);
        }
        return rectangle;
    }

    private String getSideForLocation(Point point) {
        Rectangle rectangle;
        int n;
        Rectangle rectangle2 = this.getBounds();
        rectangle2.setLocation(0, 0);
        int n2 = (int)(0.25 * (double)rectangle2.height);
        int n3 = n = Math.max(this.getWidth() / 8, 40);
        if (DEBUG) {
            TabbedAdapter.debugLog("");
            TabbedAdapter.debugLog("TOP_HEIGHT    =10");
            TabbedAdapter.debugLog("BOTTOM_HEIGHT =" + n2);
            TabbedAdapter.debugLog("LEFT_WIDTH    =" + n);
            TabbedAdapter.debugLog("RIGHT_WIDTH   =" + n3);
        }
        if ((rectangle = new Rectangle(0, 0, rectangle2.width, n2)).contains(point)) {
            return "top";
        }
        EqualPolygon equalPolygon = new EqualPolygon(new int[]{0, n, n, 0}, new int[]{10, 10, rectangle2.height - n2, rectangle2.height}, 4);
        if (equalPolygon.contains(point)) {
            return "left";
        }
        EqualPolygon equalPolygon2 = new EqualPolygon(new int[]{rectangle2.width - n3, rectangle2.width, rectangle2.width, rectangle2.width - n3}, new int[]{10, 10, rectangle2.height, rectangle2.height - n2}, 4);
        if (equalPolygon2.contains(point)) {
            return "right";
        }
        EqualPolygon equalPolygon3 = new EqualPolygon(new int[]{n, rectangle2.width - n3, rectangle2.width, 0}, new int[]{rectangle2.height - n2, rectangle2.height - n2, rectangle2.height, rectangle2.height}, 4);
        if (equalPolygon3.contains(point)) {
            return "bottom";
        }
        return null;
    }

    private Shape getStartingIndication(Point point, Point point2) {
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(point2.x - point.x, point2.y - point.y);
        return rectangle;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private void fireStateChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getAnonymousLogger().warning("All state changes to the tab component must happen on the event thread!");
            Exception exception = new Exception();
            exception.fillInStackTrace();
            Logger.getAnonymousLogger().warning(exception.getStackTrace()[1].toString());
        }
        this.cs.fireChange();
    }

    private static void debugLog(String string) {
        Debug.log(TabbedAdapter.class, string);
    }

    public Component getComponent() {
        return this;
    }

    public Action[] getPopupActions(Action[] actionArray, int n) {
        boolean bl = WindowManagerImpl.getInstance().isDocked(this.getTopComponentAt(n));
        if (1 == this.getType() || !bl) {
            return actionArray;
        }
        int n2 = actionArray.length;
        Action[] actionArray2 = new Action[n2 + 1];
        System.arraycopy(actionArray, 0, actionArray2, 0, n2);
        if (n2 > 0) {
            actionArray2[n2] = actionArray2[n2 - 1];
            actionArray2[n2 - 1] = new ActionUtils.AutoHideWindowAction(this, n, false);
        }
        return actionArray2;
    }

    public static boolean isInMaximizedMode(Component component) {
        ModeImpl modeImpl = WindowManagerImpl.getInstance().getCurrentMaximizedMode();
        if (modeImpl == null) {
            return false;
        }
        return modeImpl.containsTopComponent((TopComponent)component);
    }

    public void userToggledAutoHide(int n, boolean bl) {
        this.postActionEvent(new TabActionEvent((Object)this, "enableAutoHide", n));
    }

    public void userToggledTransparency(int n) {
        this.postActionEvent(new TabActionEvent((Object)this, "toggleTransparency", n));
    }

    public Tabbed getTabbed() {
        return this;
    }

    public Rectangle getTabBounds(int n) {
        return this.getTabRect(n, new Rectangle());
    }

    private PropertyChangeListener getTooltipListener(Component component) {
        if (this.tooltipListener == null) {
            this.tooltipListener = new ToolTipListener();
            this.weakTooltipListener = WeakListeners.propertyChange((PropertyChangeListener)this.tooltipListener, (Object)component);
        }
        return this.weakTooltipListener;
    }

    private class ToolTipListener
    implements PropertyChangeListener {
        private ToolTipListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ToolTipText".equals(propertyChangeEvent.getPropertyName())) {
                List list = TabbedAdapter.this.getModel().getTabs();
                int n = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JComponent jComponent = (JComponent)((TabData)iterator.next()).getComponent();
                    if (jComponent == propertyChangeEvent.getSource()) {
                        TabbedAdapter.this.setToolTipTextAt(n, (String)propertyChangeEvent.getNewValue());
                        break;
                    }
                    ++n;
                }
            }
        }
    }

    static class WinsysInfo
    implements WinsysInfoForTabbed {
        WinsysInfo() {
        }

        public Object getOrientation(Component component) {
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
            if (!windowManagerImpl.isDocked((TopComponent)component)) {
                return TabDisplayer.ORIENTATION_INVISIBLE;
            }
            String string = windowManagerImpl.guessSlideSide((TopComponent)component);
            Object object = null;
            object = string.equals("left") ? TabDisplayer.ORIENTATION_WEST : (string.equals("right") ? TabDisplayer.ORIENTATION_EAST : (string.equals("bottom") ? TabDisplayer.ORIENTATION_SOUTH : TabDisplayer.ORIENTATION_CENTER));
            return object;
        }

        public boolean inMaximizedMode(Component component) {
            return TabbedAdapter.isInMaximizedMode(component);
        }
    }
}

