/*
 * Decompiled with CFR 0.152.
 */
package tr.view.reference;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.Frame;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;
import tr.model.information.Information;
import tr.view.reference.ReferenceDeleteCookie;

public class ReferenceDeleteAction
extends CookieAction {
    public ReferenceDeleteAction() {
        this.setIcon(Icons.ReferenceDelete);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ReferenceDeleteAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Class[] cookieClasses() {
        return new Class[]{Information.class};
    }

    public int mode() {
        return 4;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        String title = "Confirm Deletion";
        String message = nodes.length == 1 ? "Are you sure you want to delete reference: \n" + nodes[0].getName() + "?\n" : "Are you sure you want to delete " + nodes.length + " references?";
        Frame p = WindowManager.getDefault().getMainWindow();
        int opt = JOptionPane.showConfirmDialog(p, message, title, 0);
        if (opt != 0) {
            return;
        }
        for (Node node : nodes) {
            ReferenceDeleteCookie cookie = (ReferenceDeleteCookie)node.getCookie(ReferenceDeleteCookie.class);
            if (cookie == null) continue;
            cookie.deleteReference();
        }
    }
}

