/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;

public final class LocalFileSystemEx
extends LocalFileSystem {
    private static HashMap<String, FileObject> allLocks = new HashMap(7);
    private static HashSet<String> pLocks = new HashSet(7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLocks() {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.addAll(allLocks.keySet());
            linkedList.addAll(pLocks);
            return linkedList.toArray(new String[linkedList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocks() {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            LocalFileSystemEx.removeInvalid(pLocks);
            return !allLocks.isEmpty() || !pLocks.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String string) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            pLocks.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void potentialLock(String string, String string2) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (pLocks.remove(string)) {
                pLocks.add(string2);
            }
        }
    }

    private static void removeInvalid(Set set) {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FileObject fileObject = fileSystem.findResource(string);
            if (null != fileObject && fileObject.isLocked()) continue;
            iterator.remove();
        }
    }

    public LocalFileSystemEx() {
        this(false);
    }

    LocalFileSystemEx(boolean bl) {
        if (bl) {
            this.attr = new DelegatingAttributes(this.attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(String string) throws IOException {
        super.lock(string);
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            FileObject fileObject = this.findResource(string);
            allLocks.put(string, fileObject);
            pLocks.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(String string) {
        HashMap<String, FileObject> hashMap = allLocks;
        synchronized (hashMap) {
            if (allLocks.containsKey(string)) {
                allLocks.remove(string);
            } else {
                FileObject fileObject = this.findResource(string);
                if (fileObject != null) {
                    for (Map.Entry<String, FileObject> entry : allLocks.entrySet()) {
                        if (!fileObject.equals(entry.getValue())) continue;
                        allLocks.remove(entry.getKey());
                        break;
                    }
                } else {
                    Logger.getLogger(LocalFileSystemEx.class.getName()).log(Level.WARNING, null, new Throwable("Can't unlock file " + string + ", it's lock was not found or it wasn't locked."));
                }
            }
        }
        super.unlock(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingAttributes
    implements AbstractFileSystem.Attr {
        private AbstractFileSystem.Attr a;

        public DelegatingAttributes(AbstractFileSystem.Attr attr) {
            this.a = attr;
        }

        public Object readAttribute(String string, String string2) {
            if ("removeWritables".equals(string2)) {
                return new WritableRemover(string);
            }
            return this.a.readAttribute(string, string2);
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            this.a.writeAttribute(string, string2, object);
        }

        public Enumeration<String> attributes(String string) {
            return this.a.attributes(string);
        }

        public void renameAttributes(String string, String string2) {
            this.a.renameAttributes(string, string2);
        }

        public void deleteAttributes(String string) {
            this.a.deleteAttributes(string);
        }
    }

    private class WritableRemover
    implements Callable {
        private String name;

        public WritableRemover(String string) {
            this.name = string;
        }

        public Object call() throws Exception {
            FileObject fileObject = LocalFileSystemEx.this.findResource(this.name);
            if (null != fileObject) {
                fileObject.delete();
            }
            return null;
        }
    }
}

