/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Splash {
    private static Splash splash;
    private static boolean noBar;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private Frame frame;
    private SplashComponent comp = new SplashComponent(false);

    public static Splash getInstance() {
        if (splash == null) {
            splash = new Splash();
        }
        return splash;
    }

    public static void showAboutDialog(Frame frame, JComponent jComponent) {
        Splash.createAboutDialog(frame, jComponent).setVisible(true);
    }

    private static JDialog createAboutDialog(Frame frame, JComponent jComponent) {
        SplashDialog splashDialog = new SplashDialog(frame, jComponent);
        return splashDialog;
    }

    static Image createIDEImage() {
        return Utilities.loadImage((String)ICON_16, (boolean)true);
    }

    static List<Image> createIDEImages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(Utilities.loadImage((String)ICON_16, (boolean)true));
        arrayList.add(Utilities.loadImage((String)ICON_32, (boolean)true));
        arrayList.add(Utilities.loadImage((String)ICON_48, (boolean)true));
        return arrayList;
    }

    private void initFrameIcons(Frame frame) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.awt.Window");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Method method = null;
        try {
            method = clazz.getMethod("setIconImages", List.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            List<Image> list = Splash.createIDEImages();
            try {
                method.invoke((Object)frame, list);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(Splash.class.getName()).log(Level.INFO, "Cannot invoke setIconImages", illegalAccessException);
                frame.setIconImage(Splash.createIDEImage());
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(Splash.class.getName()).log(Level.INFO, "Cannot invoke setIconImages", invocationTargetException);
                frame.setIconImage(Splash.createIDEImage());
            }
        } else {
            frame.setIconImage(Splash.createIDEImage());
        }
    }

    private Splash() {
    }

    public void setRunning(boolean bl) {
        if (CLIOptions.isNoSplash()) {
            return;
        }
        if (bl) {
            if (this.frame == null) {
                this.frame = new Frame(NbBundle.getMessage(Splash.class, (String)"LBL_splash_window_title"));
                this.initFrameIcons(this.frame);
                this.frame.setUndecorated(true);
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this.comp, "Center");
                this.frame.setResizable(false);
                int n = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_WIDTH"));
                int n2 = Integer.parseInt(NbBundle.getMessage(Splash.class, (String)"SPLASH_HEIGHT"));
                this.frame.setPreferredSize(new Dimension(n, n2));
                SwingUtilities.invokeLater(new SplashRunner(this.frame, true));
            }
        } else {
            SwingUtilities.invokeLater(new SplashRunner(this.frame, false));
        }
    }

    public void dispose() {
        this.setRunning(false);
        splash = null;
    }

    public void increment(int n) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp != null) {
            this.comp.increment(n);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void print(String string) {
        if (CLIOptions.isNoSplash() || this.comp == null) {
            return;
        }
        this.comp.setText(string);
    }

    public void addToMaxSteps(int n) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp != null) {
            this.comp.addToMaxSteps(n);
        }
    }

    static final void center(Window window) {
        window.pack();
        window.setBounds(Utilities.findCenterBounds((Dimension)window.getSize()));
    }

    public static Image loadContent(boolean bl) {
        Image image;
        if (bl && (image = Utilities.loadImage((String)"org/netbeans/core/startup/about.png", (boolean)true)) != null) {
            return image;
        }
        return Utilities.loadImage((String)"org/netbeans/core/startup/splash.gif", (boolean)true);
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar");
        ResourceBundle resourceBundle = NbBundle.getBundle(Splash.class);
        noBar |= !Boolean.parseBoolean(resourceBundle.getString("SplashShowProgressBar"));
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        Rectangle view;
        Color color_text;
        Color color_bar;
        Color color_edge;
        Color color_corner;
        private int size = 12;
        private Rectangle dirty = new Rectangle();
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 140;
        private int barStart = 0;
        private int barLength = 0;
        private Image image;
        private String text;
        private FontMetrics fm;

        public SplashComponent(boolean bl) {
            Object object;
            ResourceBundle resourceBundle = NbBundle.getBundle(Splash.class);
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashRunningTextBounds"), " ,");
            this.view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashProgressBarBounds"), " ,");
            try {
                this.bar = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                object = Integer.decode(resourceBundle.getString("SplashRunningTextColor"));
                this.color_text = new Color((Integer)object);
                object = Integer.decode(resourceBundle.getString("SplashProgressBarColor"));
                this.color_bar = new Color((Integer)object);
                object = Integer.decode(resourceBundle.getString("SplashProgressBarEdgeColor"));
                this.color_edge = new Color((Integer)object);
                object = Integer.decode(resourceBundle.getString("SplashProgressBarCornerColor"));
                this.color_corner = new Color((Integer)object);
            }
            catch (NumberFormatException numberFormatException) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, numberFormatException);
                this.color_text = Color.BLACK;
                this.color_bar = Color.ORANGE;
                this.color_edge = Color.BLUE;
                this.color_corner = Color.GREEN;
                this.bar = new Rectangle(0, 0, 80, 10);
            }
            try {
                object = resourceBundle.getString("SplashRunningTextFontSize");
                this.size = Integer.parseInt((String)object);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.image = Splash.loadContent(bl);
            object = new Font("Dialog", 0, this.size);
            this.setFont((Font)object);
            this.fm = this.getFontMetrics((Font)object);
        }

        public void setText(final String string) {
            if (string != null && string.equals(this.text)) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (string == null) {
                        SplashComponent.this.repaint(SplashComponent.this.dirty);
                        return;
                    }
                    if (SplashComponent.this.fm == null) {
                        return;
                    }
                    SplashComponent.this.adjustText(string);
                    SwingUtilities.layoutCompoundLabel(SplashComponent.this.fm, string, null, 3, 2, 3, 2, SplashComponent.this.view, new Rectangle(), SplashComponent.this.rect, 0);
                    SplashComponent.this.dirty = SplashComponent.this.dirty.union(SplashComponent.this.rect);
                    SplashComponent.this.repaint(SplashComponent.this.dirty);
                    SplashComponent.this.dirty = new Rectangle(SplashComponent.this.rect);
                }
            });
        }

        private void adjustText(String string) {
            String string2 = null;
            if (string == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int n = this.fm.stringWidth(string);
            if (n > this.view.width) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string3 = string2 == null ? string4 : string2 + " " + string4;
                    if (this.fm.stringWidth(string3 + "...") > this.view.width) {
                        this.text = string2 + "...";
                        break;
                    }
                    string2 = string3;
                }
                if (string2 == null) {
                    this.text = "";
                    string3 = "";
                    string2 = "";
                    for (int i = 0; i < string.length(); ++i) {
                        if (this.fm.stringWidth((string3 = string3 + string.charAt(i)) + "...") > this.view.width) {
                            this.text = string2 + "...";
                            break;
                        }
                        string2 = string3;
                    }
                }
            } else {
                this.text = string;
            }
        }

        public void increment(int n) {
            int n2;
            this.progress += n;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((n2 = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = n2;
                this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                this.repaint(this.bar_inc);
            }
        }

        private void addToMaxSteps(int n) {
            int n2 = this.maxSteps + n;
            int n3 = this.progress / this.maxSteps * n2;
            this.maxSteps = n2;
            this.progress = n3;
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.color_text);
            graphics.drawImage(this.image, 0, 0, null);
            if (this.text != null) {
                if (this.fm == null) {
                    return;
                }
                SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            }
            if (!noBar && this.maxSteps > 0) {
                graphics.setColor(this.color_bar);
                graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                graphics.setColor(this.color_corner);
                graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                graphics.setColor(this.color_edge);
                graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        }

        public boolean isOpaque() {
            return true;
        }

        public String toString() {
            return "SplashComponent - progress: " + this.progress + "/" + this.maxSteps + " text: " + this.text;
        }
    }

    private static class SplashDialog
    extends JDialog
    implements ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new SplashComponent(true);

        public SplashDialog(Frame frame, JComponent jComponent) {
            super(frame, true);
            JPanel jPanel = new JPanel();
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"));
            jPanel.add(this.splashComponent);
            jTabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Title"), jPanel);
            jTabbedPane.addTab(NbBundle.getMessage(Splash.class, (String)"CTL_About_Detail"), jComponent);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Splash.class, (String)"ACSN_AboutTabs"));
            jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, (String)"ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window window, boolean bl) {
            this.splashWindow = window;
            this.visible = bl;
        }

        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }
}

