/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.windows.WindowManager;
import tr.extract.Param;
import tr.extract.ParamsPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamsDialog
extends JDialog {
    private static final Dimension COMBOBOX_SIZE = new Dimension(300, 24);
    private static final Dimension CHECKBOX_SIZE = new Dimension(100, 21);
    private final String id;
    private final List<Param> params;
    private int option;
    private boolean remember;
    private List<JComponent> components;
    private JButton okButton;
    private JButton cancelButton;

    public ParamsDialog(String name, String id, List<Param> params) {
        super(WindowManager.getDefault().getMainWindow(), name, true);
        this.setDefaultCloseOperation(2);
        this.id = id;
        this.params = params;
        this.construct(name, id, params);
    }

    private void construct(String name, String id, List<Param> params) {
        Dimension screenSize;
        this.loadSelectionValues(id, params);
        int rows = params.size();
        int cols = 1;
        int hgap = 0;
        int vgap = 0;
        JPanel panelLabels = new JPanel(new GridLayout(rows, cols, hgap, vgap));
        JPanel panelFields = new JPanel(new GridLayout(rows, cols, hgap, vgap));
        this.components = new Vector<JComponent>();
        for (Param param : params) {
            List<Param.Item> items;
            if (param.type == Param.Type.CHECKBOX) {
                JCheckBox checkbox = new JCheckBox();
                checkbox.setPreferredSize(CHECKBOX_SIZE);
                checkbox.setSelected(Boolean.parseBoolean(param.getValue()));
                this.components.add(checkbox);
                panelLabels.add(new JLabel(param.display + "      "));
                panelFields.add(checkbox);
                continue;
            }
            if (param.type != Param.Type.COMBOBOX || (items = param.getItems()) == null || items.size() <= 0) continue;
            JComboBox<Object> combo = new JComboBox<Object>(items.toArray());
            combo.setPreferredSize(COMBOBOX_SIZE);
            if (param.getValue() != null && !param.getValue().trim().equals("")) {
                for (int i = 0; i < items.size(); ++i) {
                    Param.Item item = items.get(i);
                    if (!item.value.equals(param.getValue())) continue;
                    combo.setSelectedIndex(i);
                    break;
                }
            }
            combo.setMaximumRowCount(30);
            this.components.add(combo);
            panelLabels.add(new JLabel(param.display + "      "));
            panelFields.add(combo);
        }
        JPanel center = new JPanel(new BorderLayout());
        center.setBorder(BorderFactory.createEmptyBorder());
        center.add("West", panelLabels);
        center.add("Center", panelFields);
        JCheckBox rememberCheckBox = new JCheckBox("Remember options");
        rememberCheckBox.setSelected(false);
        rememberCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParamsDialog.this.remember = ((JCheckBox)evt.getSource()).isSelected();
            }
        });
        JPanel north = new JPanel();
        north.setPreferredSize(new Dimension(0, 16));
        JPanel east = new JPanel();
        east.setPreferredSize(new Dimension(80, 0));
        JPanel west = new JPanel();
        west.setPreferredSize(new Dimension(80, 0));
        JPanel south = new JPanel();
        south.setPreferredSize(new Dimension(0, 16));
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(BorderFactory.createEmptyBorder());
        main.add((Component)north, "North");
        main.add((Component)center, "Center");
        main.add((Component)east, "East");
        main.add((Component)west, "West");
        main.add((Component)south, "South");
        JPanel filler = new JPanel(new BorderLayout());
        filler.add((Component)main, "North");
        filler.add((Component)new JPanel(), "Center");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.putClientProperty("JButton.buttonType", "text");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParamsDialog.this.cancel();
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.putClientProperty("JButton.buttonType", "text");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParamsDialog.this.ok();
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2, 2, 2));
        buttons.setPreferredSize(new Dimension(0, 36));
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 36));
        buttons.add(rememberCheckBox);
        buttons.add(new JLabel("   "));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        this.add((Component)new JScrollPane(filler), "Center");
        this.add((Component)buttons, "South");
        this.pack();
        try {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (AWTError awe) {
            screenSize = new Dimension(640, 480);
        }
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        int x = screenSize.width / 2 - frameSize.width / 2;
        int y = screenSize.height / 2 - frameSize.height / 2;
        this.setLocation(x, y);
    }

    private void ok() {
        this.option = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.option = 2;
        this.setVisible(false);
        this.dispose();
    }

    private void loadSelectionValues(String id, List<Param> params) {
        for (Param param : params) {
            String value = ParamsPrefs.getParam(id, param.id);
            if (value == null) continue;
            param.setValue(value);
        }
    }

    public void transferSelectionValues() {
        for (int i = 0; i < this.components.size(); ++i) {
            JComponent c = this.components.get(i);
            if (c instanceof JComboBox) {
                JComboBox combo = (JComboBox)c;
                Param.Item item = (Param.Item)combo.getSelectedItem();
                this.params.get(i).setValue(item.value);
                continue;
            }
            if (!(c instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)c;
            this.params.get(i).setValue(Boolean.toString(checkbox.isSelected()));
        }
    }

    private void storeSelectionValues() {
        if (this.remember) {
            for (Param param : this.params) {
                ParamsPrefs.setParam(this.id, param.id, param.value);
            }
        }
    }

    public boolean remember() {
        return this.remember;
    }

    public int showDialog() {
        this.option = 2;
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
        if (this.option == 0) {
            this.transferSelectionValues();
            this.storeSelectionValues();
        }
        return this.option;
    }
}

