/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.WrappedTextView;

class ExtPlainView
extends PlainView {
    private final Segment SEGMENT = new Segment();
    private static final boolean antialias = Boolean.getBoolean("swing.aatext") || "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static Map hintsMap = null;

    static final Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    ExtPlainView(Element element) {
        super(element);
    }

    public void paint(Graphics graphics, Shape shape) {
        ((Graphics2D)graphics).addRenderingHints(ExtPlainView.getHints());
        super.paint(graphics, shape);
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            Segment segment = SwingUtilities.isEventDispatchThread() ? this.SEGMENT : new Segment();
            document.getText(n3, n4 - n3, segment);
            graphics.setColor(ExtPlainView.getColorForLocation(n3, document, true));
            int n5 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
            if (graphics.getColor() == WrappedTextView.selectedLinkFg || graphics.getColor() == WrappedTextView.selectedImportantLinkFg) {
                this.underline(graphics, segment, n, n3, n2);
            }
            return n5;
        }
        return super.drawUnselectedText(graphics, n, n2, n3, n4);
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Document document = this.getDocument();
        if (document instanceof OutputDocument) {
            Segment segment = SwingUtilities.isEventDispatchThread() ? this.SEGMENT : new Segment();
            document.getText(n3, n4 - n3, segment);
            graphics.setColor(ExtPlainView.getColorForLocation(n3, document, false));
            int n5 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
            if (graphics.getColor() == WrappedTextView.selectedLinkFg || graphics.getColor() == WrappedTextView.selectedImportantLinkFg) {
                this.underline(graphics, segment, n, n3, n2);
            }
            return n5;
        }
        return super.drawUnselectedText(graphics, n, n2, n3, n4);
    }

    private void underline(Graphics graphics, Segment segment, int n, int n2, int n3) {
        int n4;
        int n5 = graphics.getFontMetrics().charWidth(' ');
        char[] cArray = segment.array;
        int n6 = segment.offset;
        int n7 = segment.count;
        int n8 = segment.offset + segment.count;
        int n9 = 0;
        int n10 = 0;
        for (n4 = segment.offset; n4 < n8; ++n4) {
            if (cArray[n4] == '\t') {
                n = (int)this.nextTabStop(n, n2 + n4 - n6);
                ++n9;
                continue;
            }
            if (!Character.isWhitespace(cArray[n4])) break;
            n += n5;
            ++n10;
        }
        if ((n4 = n + n5 * (n7 - (n10 + n9 + 1))) > n) {
            graphics.drawLine(n, n3 + 1, n4, n3 + 1);
        }
    }

    private static Color getColorForLocation(int n, Document document, boolean bl) {
        OutputDocument outputDocument = (OutputDocument)document;
        int n2 = outputDocument.getElementIndex(n);
        boolean bl2 = outputDocument.getLines().isHyperlink(n2);
        boolean bl3 = bl2 ? outputDocument.getLines().isImportantHyperlink(n2) : false;
        boolean bl4 = outputDocument.getLines().isErr(n2);
        return bl2 ? (bl3 ? (bl ? WrappedTextView.selectedImportantLinkFg : WrappedTextView.unselectedImportantLinkFg) : (bl ? WrappedTextView.selectedLinkFg : WrappedTextView.unselectedLinkFg)) : (bl ? (bl4 ? WrappedTextView.selectedErr : WrappedTextView.selectedFg) : (bl4 ? WrappedTextView.unselectedErr : WrappedTextView.unselectedFg));
    }
}

