/*
 * Decompiled with CFR 0.152.
 */
package tr.autoversion;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;
import tr.appl.prefs.ApplicationPrefs;
import tr.util.DateUtils;

final class VersionCheckThread
extends Thread {
    private static final Logger LOG = Logger.getLogger("tr.autoversion");

    public void run() {
        LOG.info("Starting");
        this.process();
        LOG.info("Finished");
    }

    private void process() {
        switch (ApplicationPrefs.getVersionCheckPeriod()) {
            case 5: {
                LOG.fine("User preference Check Period is set to NEVER");
                return;
            }
            case 0: {
                LOG.fine("User preference Check Period is set to STARTUP");
                this.checkVersion();
                return;
            }
        }
        if (this.checkPeriodExpired()) {
            LOG.fine("Period has expired");
            this.checkVersion();
        } else {
            LOG.fine("Period has not expired");
        }
    }

    private boolean checkPeriodExpired() {
        LOG.fine("Checking if period has expired ... ");
        Calendar checkDate = Calendar.getInstance();
        checkDate.setTimeInMillis(ApplicationPrefs.getCheckVersionLastTime());
        switch (ApplicationPrefs.getVersionCheckPeriod()) {
            case 1: {
                LOG.fine("User preference Check Period is set to DAY");
                checkDate.add(6, 1);
                break;
            }
            case 2: {
                LOG.fine("User preference Check Period is set to WEEK");
                checkDate.add(6, 7);
                break;
            }
            case 3: {
                LOG.fine("User preference Check Period is set to TWO WEEKS");
                checkDate.add(6, 14);
                break;
            }
            case 4: {
                LOG.fine("User preference Check Period is set to MONTH");
                checkDate.add(2, 1);
                break;
            }
            default: {
                LOG.severe("User preference Check Period is not recognized.");
                return false;
            }
        }
        Calendar now = Calendar.getInstance();
        return now.after(checkDate);
    }

    private void checkVersion() {
        LOG.fine("Getting latest version number from web site");
        String latestVersion = this.getLatestVersion();
        if (latestVersion == null) {
            LOG.severe("Latest version was not obtained from web site");
            return;
        }
        try {
            int[] latestVersionArr = this.getVersionArr(latestVersion);
            int[] currentVersionArr = this.getVersionArr("2.0.1");
            if (this.isNewer(latestVersionArr, currentVersionArr)) {
                this.notifyUser(latestVersion);
            }
        }
        catch (NumberFormatException ex) {
            LOG.severe("Version is not of correct format.");
            return;
        }
        LOG.fine("Setting last time checked");
        Date startOfToday = DateUtils.getStart((Date)Calendar.getInstance().getTime());
        ApplicationPrefs.setCheckVersionLastTime((long)startOfToday.getTime());
    }

    String getLatestVersion() {
        try {
            URL url = new URL("http://www.thinkingrock.com.au/version.php");
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(15000);
            InputStream in = connection.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            return br.readLine();
        }
        catch (Exception ex) {
            return null;
        }
    }

    int[] getVersionArr(String version) {
        StringTokenizer st = new StringTokenizer(version, ".");
        if (st.countTokens() < 3) {
            throw new NumberFormatException();
        }
        return new int[]{Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())};
    }

    boolean isNewer(int[] latestVersionArr, int[] currentVersionArr) {
        for (int i = 0; i < 3; ++i) {
            if (latestVersionArr[i] > currentVersionArr[i]) {
                return true;
            }
            if (latestVersionArr[i] >= currentVersionArr[i]) continue;
            return false;
        }
        return false;
    }

    private void notifyUser(String version) {
        String t = this.getHeading();
        String m = "\n\n" + this.getMessage(version, "http://www.thinkingrock.com.au") + "    \n\n ";
        JCheckBox icb = new JCheckBox(this.getTurnOff());
        Object[] options = new Object[]{m, icb};
        JOptionPane.showOptionDialog(null, options, t, -1, 1, null, null, null);
        if (icb.isSelected()) {
            LOG.fine("Setting user preference Check Period to NEVER");
            ApplicationPrefs.setVersionCheckPeriod((int)5);
        }
    }

    private String getHeading() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_Heading");
    }

    private String getMessage(String version, String url) {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_Message", (Object)version, (Object)url);
    }

    private String getTurnOff() {
        return NbBundle.getMessage(this.getClass(), (String)"CTL_TurnOff");
    }
}

