/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.data.FileFilterImpl;
import tr.data.SaveAction;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.model.Data;
import tr.model.DataLookup;
import tr.util.Utils;
import tr.util.UtilsFile;

public final class SaveAsAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger("tr.data");

    public SaveAsAction() {
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                SaveAsAction.this.enableDisable();
            }
        });
    }

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/DataSaveAs.png";
    }

    private void enableDisable() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                SaveAsAction.this.setEnabled(data != null);
            }
        });
    }

    public void performAction() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        this.saveData(ds);
        JFileChooser chooser = new JFileChooser();
        String[] extns = XStreamDataStore.FILE_EXTENSIONS;
        FileFilterImpl filter = new FileFilterImpl("ThinkingRock XStream files", extns, true);
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(ds.getPath()));
        Frame p = WindowManager.getDefault().getMainWindow();
        int returnVal = chooser.showDialog(p, "Save As");
        if (returnVal == 0) {
            String t;
            String m;
            int r;
            File file;
            String path = chooser.getSelectedFile().getPath();
            String extn = UtilsFile.getExtension((String)path);
            if (!Utils.in((String)extn, (String[])extns)) {
                path = UtilsFile.setExtension((String)path, (String)"trx");
            }
            if ((file = new File(path)).exists() && (r = JOptionPane.showConfirmDialog(p, m = "Are you sure you to want to replace this file?    ", t = "Save As", 0)) != 0) {
                return;
            }
            LOG.info("Save As: " + path);
            ds.setPath(path);
            ds.setChanged(true);
            this.saveData(ds);
            WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + path);
        }
    }

    private void saveData(DataStore ds) {
        try {
            ds.store();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAction.class, (String)"CTL_SaveAsAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

