/*
 * Decompiled with CFR 0.152.
 */
package tr.swing.editorpane;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import org.openide.util.NbBundle;
import tr.prefs.dates.DatesPrefs;
import tr.swing.editorpane.JEditorPaneExt;
import tr.swing.editorpane.URLDialog;

public class HyperEditorPane
extends JPanel {
    private static final Logger LOG = Logger.getLogger("tr.swing.editorpane");
    private JEditorPaneExt hyperPane;
    private JButton editButton;
    private JButton fileButton;
    private JButton urlButton;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JButton dateButton;
    private JButton timeButton;
    private static final int INSERT_MASK = 640;
    private static final int INSERT_DATE_KEY = 68;
    private static final int INSERT_TIME_KEY = 84;
    private static final Color COLOR_NOTES = new Color(255, 255, 204);
    private static final Dimension BUTTON_SIZE = new Dimension(20, 20);

    public HyperEditorPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.hyperPane = new JEditorPaneExt();
        this.hyperPane.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HyperEditorPane.this.hyperPaneMouseClicked(evt);
            }
        });
        this.hyperPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    HyperEditorPane.this.editButtonActionPerformed(null);
                } else if ((e.getModifiersEx() & 0x280) == 640) {
                    if (e.getKeyCode() == 68) {
                        HyperEditorPane.this.dateButtonActionPerformed(null);
                    } else if (e.getKeyCode() == 84) {
                        HyperEditorPane.this.timeButtonActionPerformed(null);
                    }
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(50, 45));
        this.toolBar.setFloatable(false);
        this.toolBar.setMaximumSize(new Dimension(0, 0));
        this.toolBar.setMinimumSize(new Dimension(0, 23));
        this.editButton = new JButton();
        this.editButton.setPreferredSize(BUTTON_SIZE);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconEdit16.gif")));
        this.editButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"EditButtonToolTip"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.editButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.editButton);
        this.urlButton = new JButton();
        this.urlButton.setPreferredSize(BUTTON_SIZE);
        this.urlButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconURL16.gif")));
        this.urlButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"URLButtonToolTip"));
        this.urlButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.urlButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.urlButton);
        this.fileButton = new JButton();
        this.fileButton.setPreferredSize(BUTTON_SIZE);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconFile16.gif")));
        this.fileButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"FileButtonToolTip"));
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.fileButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.fileButton);
        this.dateButton = new JButton();
        this.dateButton.setPreferredSize(BUTTON_SIZE);
        this.dateButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconDate16.png")));
        this.dateButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TodayButtonToolTip"));
        this.dateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.dateButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.dateButton);
        this.timeButton = new JButton();
        this.timeButton.setPreferredSize(BUTTON_SIZE);
        this.timeButton.setIcon(new ImageIcon(this.getClass().getResource("/tr/swing/editorpane/IconTime16.png")));
        this.timeButton.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"NowButtonToolTip"));
        this.timeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperEditorPane.this.timeButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.timeButton);
        this.add((Component)this.toolBar, "First");
        this.scrollPane.setViewportView(this.hyperPane);
        this.add((Component)this.scrollPane, "Center");
        this.hyperPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                HyperEditorPane.this.urlButton.setFocusable(true);
                HyperEditorPane.this.fileButton.setFocusable(true);
                HyperEditorPane.this.dateButton.setFocusable(true);
                HyperEditorPane.this.timeButton.setFocusable(true);
            }

            public void focusLost(FocusEvent e) {
                if (e.getOppositeComponent() != HyperEditorPane.this.editButton && e.getOppositeComponent() != HyperEditorPane.this.urlButton && e.getOppositeComponent() != HyperEditorPane.this.fileButton && e.getOppositeComponent() != HyperEditorPane.this.dateButton && e.getOppositeComponent() != HyperEditorPane.this.timeButton) {
                    HyperEditorPane.this.setEditable(false);
                    HyperEditorPane.this.editButton.setFocusable(true);
                    HyperEditorPane.this.urlButton.setFocusable(false);
                    HyperEditorPane.this.fileButton.setFocusable(false);
                    HyperEditorPane.this.dateButton.setFocusable(false);
                    HyperEditorPane.this.timeButton.setFocusable(false);
                }
            }
        });
        this.setEditable(true);
    }

    private void hyperPaneMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && !this.hyperPane.isEditable()) {
            evt.consume();
            this.editButton.requestFocusInWindow();
            this.editButtonActionPerformed(null);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.setEditable(!this.hyperPane.isEditable());
        if (this.hyperPane.isEditable()) {
            this.hyperPane.requestFocusInWindow();
            try {
                this.hyperPane.setCaretPosition(this.hyperPane.getText().length());
            }
            catch (Exception exception) {}
        } else {
            this.editButton.requestFocusInWindow();
        }
    }

    private void urlButtonActionPerformed(ActionEvent evt) {
        Object url;
        URLDialog dialog = new URLDialog(null, this.urlButton, "Insert Web URL");
        int choice = dialog.showDialog();
        if (choice == 2) {
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        String urlText = dialog.getURL().trim();
        String urlDesc = dialog.getLinkText().trim();
        if (!urlText.contains("://")) {
            urlText = "http://" + urlText;
        }
        try {
            url = new URL(urlText);
        }
        catch (MalformedURLException ex) {
            LOG.severe(ex.getMessage());
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        url = urlDesc.length() == 0 ? "[" + urlText + "]" : "[" + urlText + "|" + urlDesc + "]";
        this.insert((String)url);
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Insert File URL");
        int option = chooser.showOpenDialog(null);
        if (option != 0) {
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        String path = chooser.getSelectedFile().getPath();
        File file = new File(path);
        if (!file.exists()) {
            LOG.severe("File does not exist.");
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        String url = null;
        try {
            url = file.toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            LOG.severe(ex.getMessage());
            if (this.hyperPane.isEditable()) {
                this.hyperPane.requestFocusInWindow();
            }
            return;
        }
        this.insert("[" + url + "]");
    }

    private void dateButtonActionPerformed(ActionEvent evt) {
        String date = DatesPrefs.formatLong((Date)new Date());
        this.insert(date);
    }

    private void timeButtonActionPerformed(ActionEvent evt) {
        String time = DateFormat.getTimeInstance().format(new Date());
        this.insert(time);
    }

    private void insert(String str) {
        boolean editing = this.hyperPane.isEditable();
        if (!editing) {
            this.setEditable(true);
        }
        try {
            this.hyperPane.textDocument.insertString(this.hyperPane.getCaretPosition(), str, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (editing) {
            this.hyperPane.requestFocusInWindow();
        } else {
            this.setEditable(false);
        }
    }

    private String getSeparator(String string, int index) {
        if (index < 1) {
            return "";
        }
        Pattern p = Pattern.compile("\\s");
        Matcher m = p.matcher(string.substring(index - 1, index));
        return m.matches() ? "" : " ";
    }

    public void setEnabled(boolean enabled) {
        this.hyperPane.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.fileButton.setEnabled(enabled);
        this.urlButton.setEnabled(enabled);
        this.dateButton.setEnabled(enabled);
        this.timeButton.setEnabled(enabled);
        if (enabled) {
            this.setEditable(this.isEditable());
        } else {
            this.hyperPane.setBackground(UIManager.getDefaults().getColor("TextArea.inactiveBackground"));
        }
    }

    public void setEditable(boolean editable) {
        this.hyperPane.setEditable(editable);
        if (editable) {
            this.hyperPane.setBackground(Color.white);
            this.editButton.setBackground(Color.darkGray);
        } else {
            this.hyperPane.setBackground(COLOR_NOTES);
            this.editButton.setBackground(Color.lightGray);
        }
    }

    public boolean isEditable() {
        return this.hyperPane.isEditable();
    }

    public String getText() {
        return this.hyperPane.getText();
    }

    public void setText(String text) {
        this.hyperPane.setText(text);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.hyperPane.textDocument.addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.hyperPane.textDocument.removeDocumentListener(listener);
    }

    public void addHyperlinkListener(HyperlinkListener listener) {
        this.hyperPane.addHyperlinkListener(listener);
    }

    public void removeHyperlinkListener(HyperlinkListener listener) {
        this.hyperPane.removeHyperlinkListener(listener);
    }

    public JEditorPane getJEditorPane() {
        return this.hyperPane;
    }

    public JButton getEditButton() {
        return this.editButton;
    }

    public JButton getURLButton() {
        return this.urlButton;
    }

    public JButton getFileButton() {
        return this.fileButton;
    }

    public JButton getDateButton() {
        return this.dateButton;
    }

    public JButton getTimeButton() {
        return this.timeButton;
    }

    public void addFocusListener(FocusListener l) {
        this.hyperPane.addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.hyperPane.removeFocusListener(l);
    }
}

