/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import tr.model.action.Interval;
import tr.model.action.Period;
import tr.model.action.PeriodType;
import tr.prefs.recurrence.RecurrencePrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodDay
extends Period {
    public static final byte ID = 2;
    public static final String BUNDLE_KEY = "period.day";

    @Override
    public Period clone() {
        return new PeriodDay();
    }

    @Override
    public final String getBundleKey() {
        return BUNDLE_KEY;
    }

    @Override
    public final byte getID() {
        return 2;
    }

    private Date calculateStartDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date calculateEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    private Date addDays(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, n);
        return calendar.getTime();
    }

    @Override
    public List<Date> getSelectedDates(Date startDate, Date templateDate) {
        assert (startDate != null);
        assert (templateDate != null);
        Calendar templateCal = Calendar.getInstance();
        templateCal.setTime(templateDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(11, templateCal.get(11));
        cal.set(12, templateCal.get(12));
        cal.set(13, templateCal.get(13));
        cal.set(14, templateCal.get(14));
        Vector<Date> dates = new Vector<Date>(1);
        dates.add(cal.getTime());
        return dates;
    }

    @Override
    public void initialise(Date startDate) {
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof PeriodDay;
    }

    @Override
    public int hashCode() {
        return 2;
    }

    @Override
    public int getDefaultAdvanceNbr() {
        return RecurrencePrefs.getNbrFutureDay();
    }

    @Override
    public PeriodType getType() {
        return PeriodType.DAY;
    }

    @Override
    public Interval getPeriod(Date date) {
        return new Interval(this.calculateStartDate(date), this.calculateEndDate(date));
    }

    @Override
    public Interval addPeriods(Interval interval, int n) {
        return this.getPeriod(this.addDays(interval.start, n));
    }
}

