/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.appl.Constants;
import tr.model.action.Intervals;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.PeriodMonthlyPanel;
import tr.view.action.PeriodWeeklyPanel;
import tr.view.action.PeriodYearlyPanel;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class RecurrenceRegularPanelModify
extends JPanel {
    private Recurrence modRecurrence;
    private Date recurrenceStartDate;
    private Date actionScheduledDate;
    private Dialog dialog;
    private long counter;
    private JLabel advanceLabel1;
    private JLabel advanceLabel2;
    private JSpinner advanceSpinner;
    private DateField endDateField;
    private JRadioButton endDateRadioButton;
    private JLabel endLabel;
    private JLabel endNbrLabel;
    private JRadioButton endNbrRadioButton;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadioButton;
    private JLabel errorLabel1;
    private JLabel errorLabel2;
    private JLabel fillerLabel;
    private JSpinner frequencySpinner;
    private PeriodTypeComboBox periodComboBox;
    private JLabel periodLabel;
    private JPanel periodPanel;
    private JRadioButton startActionDateRadioButton;
    private ButtonGroup startDatebuttonGroup;
    private DateField startEnterDateField;
    private JRadioButton startEnterRadioButton;
    private JLabel startLabel;
    private JRadioButton startStartDateRadioButton;
    private ButtonGroup terminationButtonGroup;
    private PeriodWeeklyPanel periodWeeklyPanel;
    private PeriodMonthlyPanel periodMonthlyPanel;
    private PeriodYearlyPanel periodYearlyPanel;
    private Map<PeriodType, Integer> mapAdvanceNbrs;
    private Map<PeriodType, Period> mapPeriods;
    private JLabel onLabel;

    public RecurrenceRegularPanelModify() {
        this.initComponents();
    }

    public void setModel(Recurrence modRecurrence, Date actionScheduledDate, Date recurrenceStartDate, boolean basisChanged) {
        this.modRecurrence = modRecurrence;
        this.recurrenceStartDate = recurrenceStartDate;
        this.actionScheduledDate = actionScheduledDate;
        this.initPeriods();
        this.initPanel(basisChanged);
        this.setEnabled(this.isEnabled());
    }

    public String getName() {
        return "Change Regular Recurrence";
    }

    private void initPeriods() {
        this.setPeriod((Period)new PeriodWeekday());
        this.setPeriod((Period)new PeriodDay());
        this.setPeriod((Period)new PeriodWeek());
        this.setPeriod((Period)new PeriodMonth());
        this.setPeriod((Period)new PeriodYear());
        this.setPeriod(this.modRecurrence.getPeriod());
        this.setAdvanceNbr(this.modRecurrence.getPeriod().getType(), this.modRecurrence.getAdvanceNbr());
    }

    private void initComponents() {
        this.terminationButtonGroup = new ButtonGroup();
        this.startDatebuttonGroup = new ButtonGroup();
        this.periodLabel = new JLabel();
        this.frequencySpinner = new JSpinner();
        this.periodPanel = new JPanel();
        this.advanceLabel1 = new JLabel();
        this.advanceSpinner = new JSpinner();
        this.advanceLabel2 = new JLabel();
        this.endLabel = new JLabel();
        this.endNeverRadioButton = new JRadioButton();
        this.endNbrRadioButton = new JRadioButton();
        this.endNbrSpinner = new JSpinner();
        this.endNbrLabel = new JLabel();
        this.endDateRadioButton = new JRadioButton();
        this.endDateField = new DateField();
        this.periodComboBox = new PeriodTypeComboBox();
        this.startLabel = new JLabel();
        this.fillerLabel = new JLabel();
        this.startStartDateRadioButton = new JRadioButton();
        this.startActionDateRadioButton = new JRadioButton();
        this.startEnterRadioButton = new JRadioButton();
        this.startEnterDateField = new DateField();
        this.errorLabel1 = new JLabel();
        this.errorLabel2 = new JLabel();
        this.setMaximumSize(new Dimension(1024, 380));
        this.setMinimumSize(new Dimension(680, 380));
        this.setPreferredSize(new Dimension(680, 380));
        this.periodLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.periodLabel, (String)"Periods");
        this.periodLabel.setMaximumSize(new Dimension(100, 23));
        this.periodLabel.setMinimumSize(new Dimension(100, 23));
        this.periodLabel.setPreferredSize(new Dimension(100, 23));
        this.frequencySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.frequencySpinner.setMaximumSize(new Dimension(50, 23));
        this.frequencySpinner.setMinimumSize(new Dimension(50, 23));
        this.frequencySpinner.setPreferredSize(new Dimension(50, 23));
        this.frequencySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceRegularPanelModify.this.frequencySpinnerStateChanged(evt);
            }
        });
        this.periodPanel.setMaximumSize(new Dimension(530, 26));
        this.periodPanel.setMinimumSize(new Dimension(530, 26));
        this.periodPanel.setPreferredSize(new Dimension(530, 26));
        this.periodPanel.setLayout(new FlowLayout(0, 5, 0));
        this.advanceLabel1.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.advanceLabel1, (String)"Generate");
        this.advanceLabel1.setMaximumSize(new Dimension(100, 23));
        this.advanceLabel1.setMinimumSize(new Dimension(100, 23));
        this.advanceLabel1.setPreferredSize(new Dimension(100, 23));
        this.advanceSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.advanceSpinner.setMaximumSize(new Dimension(50, 23));
        this.advanceSpinner.setMinimumSize(new Dimension(50, 23));
        this.advanceSpinner.setPreferredSize(new Dimension(50, 23));
        this.advanceSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceRegularPanelModify.this.advanceSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.advanceLabel2, (String)"periods in advance (from current date)");
        this.advanceLabel2.setMaximumSize(new Dimension(67, 23));
        this.advanceLabel2.setMinimumSize(new Dimension(67, 23));
        this.advanceLabel2.setPreferredSize(new Dimension(67, 23));
        this.endLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.endLabel, (String)"Terminate");
        this.endLabel.setMaximumSize(new Dimension(100, 23));
        this.endLabel.setMinimumSize(new Dimension(100, 23));
        this.endLabel.setPreferredSize(new Dimension(100, 23));
        this.terminationButtonGroup.add(this.endNeverRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNeverRadioButton, (String)"never");
        this.endNeverRadioButton.setMaximumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setMinimumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setPreferredSize(new Dimension(90, 23));
        this.endNeverRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.endNeverRadioButtonActionPerformed(evt);
            }
        });
        this.terminationButtonGroup.add(this.endNbrRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNbrRadioButton, (String)"after");
        this.endNbrRadioButton.setMaximumSize(new Dimension(70, 23));
        this.endNbrRadioButton.setMinimumSize(new Dimension(70, 23));
        this.endNbrRadioButton.setPreferredSize(new Dimension(70, 23));
        this.endNbrRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.endNbrRadioButtonActionPerformed(evt);
            }
        });
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.setMaximumSize(new Dimension(50, 23));
        this.endNbrSpinner.setMinimumSize(new Dimension(50, 23));
        this.endNbrSpinner.setPreferredSize(new Dimension(50, 23));
        this.endNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RecurrenceRegularPanelModify.this.endNbrSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.endNbrLabel, (String)"periods");
        this.endNbrLabel.setMaximumSize(new Dimension(80, 23));
        this.endNbrLabel.setMinimumSize(new Dimension(80, 23));
        this.endNbrLabel.setPreferredSize(new Dimension(80, 23));
        this.terminationButtonGroup.add(this.endDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endDateRadioButton, (String)"after");
        this.endDateRadioButton.setMaximumSize(new Dimension(70, 23));
        this.endDateRadioButton.setMinimumSize(new Dimension(70, 23));
        this.endDateRadioButton.setPreferredSize(new Dimension(70, 23));
        this.endDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.endDateRadioButtonActionPerformed(evt);
            }
        });
        this.endDateField.setMaximumSize(new Dimension(110, 23));
        this.endDateField.setMinimumSize(new Dimension(110, 23));
        this.endDateField.setPreferredSize(new Dimension(110, 23));
        this.endDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RecurrenceRegularPanelModify.this.endDateFieldPropertyChange(evt);
            }
        });
        this.periodComboBox.setMaximumSize(new Dimension(125, 23));
        this.periodComboBox.setMinimumSize(new Dimension(125, 23));
        this.periodComboBox.setPreferredSize(new Dimension(125, 23));
        this.periodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.periodActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.startLabel, (String)"Delete and regenerate recurrent actions from:");
        this.startLabel.setMaximumSize(new Dimension(286, 23));
        this.startLabel.setMinimumSize(new Dimension(286, 23));
        this.startLabel.setPreferredSize(new Dimension(286, 23));
        this.fillerLabel.setHorizontalAlignment(11);
        this.fillerLabel.setMaximumSize(new Dimension(100, 23));
        this.fillerLabel.setMinimumSize(new Dimension(100, 23));
        this.fillerLabel.setPreferredSize(new Dimension(100, 23));
        this.fillerLabel.setVerticalTextPosition(1);
        this.startDatebuttonGroup.add(this.startStartDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.startStartDateRadioButton, (String)"recurrence start date");
        this.startStartDateRadioButton.setMaximumSize(new Dimension(154, 23));
        this.startStartDateRadioButton.setMinimumSize(new Dimension(154, 23));
        this.startStartDateRadioButton.setPreferredSize(new Dimension(154, 23));
        this.startStartDateRadioButton.setVerticalTextPosition(1);
        this.startStartDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.startStartDateRadioButtonActionPerformed(evt);
            }
        });
        this.startDatebuttonGroup.add(this.startActionDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.startActionDateRadioButton, (String)"selected action date");
        this.startActionDateRadioButton.setMaximumSize(new Dimension(150, 23));
        this.startActionDateRadioButton.setMinimumSize(new Dimension(150, 23));
        this.startActionDateRadioButton.setPreferredSize(new Dimension(150, 23));
        this.startActionDateRadioButton.setVerticalTextPosition(1);
        this.startActionDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.startActionDateRadioButtonActionPerformed(evt);
            }
        });
        this.startDatebuttonGroup.add(this.startEnterRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.startEnterRadioButton, (String)"this date");
        this.startEnterRadioButton.setMaximumSize(new Dimension(90, 23));
        this.startEnterRadioButton.setMinimumSize(new Dimension(90, 23));
        this.startEnterRadioButton.setPreferredSize(new Dimension(90, 23));
        this.startEnterRadioButton.setVerticalTextPosition(1);
        this.startEnterRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RecurrenceRegularPanelModify.this.startEnterRadioButtonActionPerformed(evt);
            }
        });
        this.startEnterDateField.setMaximumSize(new Dimension(110, 23));
        this.startEnterDateField.setMinimumSize(new Dimension(110, 23));
        this.startEnterDateField.setPreferredSize(new Dimension(110, 23));
        this.startEnterDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RecurrenceRegularPanelModify.this.startEnterDateFieldPropertyChange(evt);
            }
        });
        this.errorLabel1.setForeground(Color.red);
        this.errorLabel1.setHorizontalAlignment(2);
        this.errorLabel1.setHorizontalTextPosition(0);
        this.errorLabel1.setMaximumSize(new Dimension(1024, 23));
        this.errorLabel1.setMinimumSize(new Dimension(16, 23));
        this.errorLabel1.setOpaque(true);
        this.errorLabel1.setPreferredSize(new Dimension(16, 23));
        this.errorLabel2.setForeground(Color.red);
        this.errorLabel2.setMaximumSize(new Dimension(1024, 23));
        this.errorLabel2.setMinimumSize(new Dimension(0, 23));
        this.errorLabel2.setPreferredSize(new Dimension(0, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.endLabel, -2, -1, -2).add((Component)this.advanceLabel1, -2, -1, -2).add((Component)this.periodLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.advanceSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.advanceLabel2, -2, 271, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.endNeverRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateField, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.periodPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.frequencySpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.periodComboBox, -2, -1, -2)))))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fillerLabel, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.startEnterRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.startEnterDateField, -2, -1, -2)).add((Component)this.startActionDateRadioButton, -1, 530, Short.MAX_VALUE).add((Component)this.startStartDateRadioButton, -1, 530, Short.MAX_VALUE))))).add((GroupLayout.Group)layout.createSequentialGroup().add(56, 56, 56).add((Component)this.startLabel, -1, 604, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel2, -1, 640, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel1, -1, 640, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.periodComboBox, -2, -1, -2).add(2, (Component)this.frequencySpinner, -2, -1, -2).add(2, (Component)this.periodLabel, -2, -1, -2)).addPreferredGap(0).add((Component)this.periodPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.advanceLabel1, -2, -1, -2).add((Component)this.advanceSpinner, -2, -1, -2).add((Component)this.advanceLabel2, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.endDateField, -2, -1, -2).add(2, (Component)this.endDateRadioButton, -2, -1, -2).add(2, (Component)this.endNbrLabel, -2, -1, -2).add(2, (Component)this.endNbrSpinner, -2, -1, -2).add(2, (Component)this.endNbrRadioButton, -2, -1, -2).add(2, (Component)this.endNeverRadioButton, -2, -1, -2).add(2, (Component)this.endLabel, -2, -1, -2)).add(18, 18, 18).add((Component)this.startLabel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.fillerLabel, -2, -1, -2).add((Component)this.startStartDateRadioButton, -2, -1, -2)).add(2, 2, 2).add((Component)this.startActionDateRadioButton, -2, -1, -2).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.startEnterRadioButton, -2, -1, -2).add((Component)this.startEnterDateField, -2, -1, -2)).add(18, 18, 18).add((Component)this.errorLabel1, -2, -1, -2).addPreferredGap(0).add((Component)this.errorLabel2, -2, -1, -2).addContainerGap(37, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.frequencySpinner, this.periodLabel}, 2);
        layout.linkSize(new Component[]{this.advanceLabel1, this.advanceLabel2, this.advanceSpinner}, 2);
        layout.linkSize(new Component[]{this.endDateField, this.endDateRadioButton, this.endLabel, this.endNbrLabel, this.endNbrRadioButton, this.endNbrSpinner, this.endNeverRadioButton}, 2);
    }

    private void endNbrRadioButtonActionPerformed(ActionEvent evt) {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void periodActionPerformed(ActionEvent evt) {
        PeriodType periodType = (PeriodType)this.periodComboBox.getSelectedItem();
        Period period = this.getPeriod(periodType);
        Integer advanceNbr = this.getAdvanceNbr(periodType);
        this.modRecurrence.setPeriod(period);
        this.modRecurrence.setAdvanceNbr(advanceNbr.intValue());
        this.stateChange();
        this.periodPanel.removeAll();
        switch (periodType) {
            case WEEK: {
                this.periodPanel.add(this.onLabel);
                if (this.periodWeeklyPanel == null) {
                    this.periodWeeklyPanel = new PeriodWeeklyPanel();
                    this.periodWeeklyPanel.setPeriodWeek((PeriodWeek)period);
                }
                this.periodWeeklyPanel.notifyStartDate(this.modRecurrence.getStartDate());
                this.periodPanel.add(this.periodWeeklyPanel);
                break;
            }
            case MONTH: {
                if (this.periodMonthlyPanel == null) {
                    this.periodMonthlyPanel = new PeriodMonthlyPanel(this.getDialog(), (PeriodMonth)period);
                }
                this.periodMonthlyPanel.notifyStartDate(this.modRecurrence.getStartDate());
                this.periodPanel.add(this.periodMonthlyPanel);
                break;
            }
            case YEAR: {
                if (this.periodYearlyPanel == null) {
                    this.periodYearlyPanel = new PeriodYearlyPanel(this.getDialog(), (PeriodYear)period);
                }
                this.periodYearlyPanel.notifyStartDate(this.modRecurrence.getStartDate());
                this.periodPanel.add(this.periodYearlyPanel);
            }
        }
        this.advanceSpinner.setValue(advanceNbr);
        this.setEndValues();
        this.periodPanel.validate();
        this.periodPanel.repaint();
    }

    public void setDialog(Dialog dialog) {
        assert (dialog != null);
        this.dialog = dialog;
    }

    private Dialog getDialog() {
        if (this.dialog == null) {
            Window window = SwingUtilities.getWindowAncestor(this);
            this.dialog = window instanceof Dialog ? (Dialog)window : (window instanceof Frame ? new Dialog((Frame)window) : new Dialog(new Frame()));
        }
        assert (this.dialog != null);
        return this.dialog;
    }

    private void advanceSpinnerStateChanged(ChangeEvent evt) {
        Integer newValue;
        Integer oldValue = this.getAdvanceNbr(this.modRecurrence.getPeriod().getType());
        if (oldValue != (newValue = (Integer)this.advanceSpinner.getValue())) {
            this.modRecurrence.setAdvanceNbr(newValue.intValue());
            this.stateChange();
            this.setAdvanceNbr(this.modRecurrence.getPeriod().getType(), this.modRecurrence.getAdvanceNbr());
        }
    }

    private void endNeverRadioButtonActionPerformed(ActionEvent evt) {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void endDateRadioButtonActionPerformed(ActionEvent evt) {
        this.setEndValues();
        this.setEnabled(this.isEnabled());
    }

    private void endNbrSpinnerStateChanged(ChangeEvent evt) {
        this.setEndValues();
    }

    private void endDateFieldPropertyChange(PropertyChangeEvent evt) {
        this.setEndValues();
    }

    private void startStartDateRadioButtonActionPerformed(ActionEvent evt) {
        this.modRecurrence.setStartDate(this.recurrenceStartDate);
        this.setEndValues();
        this.stateChange();
        this.setEnabled(this.isEnabled());
    }

    private void startActionDateRadioButtonActionPerformed(ActionEvent evt) {
        this.modRecurrence.setStartDate(this.actionScheduledDate);
        this.setEndValues();
        this.stateChange();
        this.setEnabled(this.isEnabled());
    }

    private void startEnterDateFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.modRecurrence.setStartDate(this.startEnterDateField.getDate());
            this.setEndValues();
            this.stateChange();
        }
    }

    private void startEnterRadioButtonActionPerformed(ActionEvent evt) {
        this.modRecurrence.setStartDate(this.startEnterDateField.getDate());
        this.setEndValues();
        this.stateChange();
        this.setEnabled(this.isEnabled());
    }

    private void frequencySpinnerStateChanged(ChangeEvent evt) {
        this.modRecurrence.setFrequency(((Integer)this.frequencySpinner.getValue()).intValue());
        this.setEndValues();
        this.stateChange();
    }

    private Integer getAdvanceNbr(PeriodType type) {
        Integer n;
        if (this.mapAdvanceNbrs == null) {
            this.mapAdvanceNbrs = new HashMap<PeriodType, Integer>();
        }
        if ((n = this.mapAdvanceNbrs.get(type)) == null || n < 1) {
            n = this.getPeriod(type).getDefaultAdvanceNbr();
        }
        return n;
    }

    private void setAdvanceNbr(PeriodType type, Integer advanceNbr) {
        if (this.mapAdvanceNbrs == null) {
            this.mapAdvanceNbrs = new HashMap<PeriodType, Integer>();
        }
        this.mapAdvanceNbrs.put(type, advanceNbr);
    }

    private Period getPeriod(PeriodType type) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        return this.mapPeriods.get(type);
    }

    private void setPeriod(Period period) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        this.mapPeriods.put(period.getType(), period);
    }

    public void initPanel(boolean basisChanged) {
        this.onLabel = new JLabel("on ");
        this.frequencySpinner.setValue(this.modRecurrence.getFrequency());
        this.periodComboBox.setSelectedItem(this.modRecurrence.getPeriod().getType());
        this.advanceSpinner.setValue(this.modRecurrence.getAdvanceNbr());
        this.endNbrRadioButton.setSelected(this.modRecurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.modRecurrence.getEndNbr() == null ? 2 : this.modRecurrence.getEndNbr());
        this.endDateRadioButton.setSelected(this.modRecurrence.getEndDate() != null);
        this.endDateField.setDate(this.modRecurrence.getEndDate());
        this.endNeverRadioButton.setSelected(!this.endNbrRadioButton.isSelected() && !this.endDateRadioButton.isSelected());
        if (basisChanged) {
            this.startLabel.setText("Generate recurrent actions from:");
            this.startStartDateRadioButton.setVisible(false);
            this.startStartDateRadioButton.setEnabled(false);
            this.startStartDateRadioButton.setSelected(false);
        } else {
            this.startLabel.setText("Delete and regenerate recurrent actions from:");
            this.startStartDateRadioButton.setVisible(true);
            this.startStartDateRadioButton.setEnabled(true);
            String strStartDate = Constants.DATE_FORMAT_FIXED.format(this.recurrenceStartDate);
            this.startStartDateRadioButton.setText(this.startStartDateRadioButton.getText() + " (" + strStartDate + ")");
        }
        String strActionDate = Constants.DATE_FORMAT_FIXED.format(this.actionScheduledDate);
        this.startActionDateRadioButton.setText(this.startActionDateRadioButton.getText() + " (" + strActionDate + ")");
        this.startActionDateRadioButton.setSelected(true);
        this.modRecurrence.setStartDate(this.actionScheduledDate);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.advanceLabel1.setEnabled(enabled);
        this.advanceLabel2.setEnabled(enabled);
        this.advanceSpinner.setEnabled(enabled);
        this.endDateRadioButton.setEnabled(enabled);
        this.endDateField.setEnabled(enabled && this.endDateRadioButton.isSelected());
        this.endLabel.setEnabled(enabled);
        this.endNbrLabel.setEnabled(enabled);
        this.endNbrRadioButton.setEnabled(enabled);
        this.endNbrSpinner.setEnabled(enabled && this.endNbrRadioButton.isSelected());
        this.endNeverRadioButton.setEnabled(enabled);
        this.frequencySpinner.setEnabled(enabled);
        this.periodComboBox.setEnabled(enabled);
        this.periodLabel.setEnabled(enabled);
        this.periodPanel.setEnabled(enabled);
        if (this.periodWeeklyPanel != null) {
            this.onLabel.setEnabled(enabled);
            this.periodWeeklyPanel.setEnabled(enabled);
        }
        if (this.periodMonthlyPanel != null) {
            this.periodMonthlyPanel.setEnabled(enabled);
        }
        if (this.periodYearlyPanel != null) {
            this.periodYearlyPanel.setEnabled(enabled);
        }
        this.startLabel.setEnabled(enabled);
        this.startStartDateRadioButton.setEnabled(enabled);
        this.startActionDateRadioButton.setEnabled(enabled);
        this.startEnterRadioButton.setEnabled(enabled);
        this.startEnterDateField.setEnabled(enabled && this.startEnterRadioButton.isSelected());
    }

    private void setEndValues() {
        if (this.endNbrRadioButton.isSelected()) {
            this.modRecurrence.setEndNbr((Integer)this.endNbrSpinner.getValue());
            this.modRecurrence.setEndDate(null);
            Date start = this.modRecurrence.getStartDate();
            if (start != null) {
                Period per = this.modRecurrence.getPeriod();
                int freq = this.modRecurrence.getFrequency();
                int endNbr = this.modRecurrence.getEndNbr();
                Intervals intervals = new Intervals(per, freq, start);
                Date endDate = Recurrence.getTerminationEndDate((Intervals)intervals, (int)endNbr);
                this.endDateField.setDate(endDate);
            }
        } else if (this.endDateRadioButton.isSelected()) {
            this.modRecurrence.setEndNbr(null);
            this.modRecurrence.setEndDate(this.endDateField.getDate());
        } else if (this.endNeverRadioButton.isSelected()) {
            this.modRecurrence.setEndNbr(null);
            this.modRecurrence.setEndDate(null);
        }
        this.stateChange();
    }

    public void stateChange() {
        this.putClientProperty("state.change", ++this.counter);
    }

    public boolean isValidForm() {
        if (this.endDateRadioButton.isSelected() && this.endDateField.getDate() == null) {
            this.errorLabel1.setText("Termination date must be entered.");
            this.errorLabel2.setText("");
            return false;
        }
        if (this.startEnterRadioButton.isSelected() && this.startEnterDateField.getDate() == null) {
            this.errorLabel1.setText("Delete and regenerate date must be entered.");
            this.errorLabel2.setText("");
            return false;
        }
        if (this.startEnterRadioButton.isSelected() && this.startEnterDateField.getDate().before(this.actionScheduledDate)) {
            this.errorLabel1.setText("Delete and regenerate date can not be before selected action date.");
            this.errorLabel2.setText("Maybe you need to change the selected action date.");
            return false;
        }
        this.errorLabel1.setText("");
        this.errorLabel2.setText("");
        return true;
    }
}

