/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence.modify;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.model.action.Intervals;
import tr.model.action.Period;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.PeriodMonthlyPanel;
import tr.view.action.PeriodWeeklyPanel;
import tr.view.action.PeriodYearlyPanel;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class RecurrenceRegularPanel
extends JPanel {
    private JLabel advanceLabel1;
    private JLabel advanceLabel2;
    private JSpinner advanceSpinner;
    private ButtonGroup buttonGroup;
    private DateField endDateField;
    private JRadioButton endDateRadioButton;
    private JLabel endLabel;
    private JLabel endNbrLabel;
    private JRadioButton endNbrRadioButton;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadioButton;
    private JSpinner frequencySpinner;
    private PeriodTypeComboBox periodComboBox;
    private JLabel periodLabel;
    private JPanel periodPanel;
    private DateField startDateField;
    private JLabel startLabel;
    private Recurrence recurrence;
    private PeriodWeeklyPanel periodWeeklyPanel;
    private PeriodMonthlyPanel periodMonthlyPanel;
    private PeriodYearlyPanel periodYearlyPanel;
    private JLabel onLabel;

    public RecurrenceRegularPanel() {
        this.initComponents();
    }

    public void setRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        this.initPanel();
    }

    public String getName() {
        return "Change Regular Recurrence";
    }

    private Dialog getDialog() {
        return (Dialog)SwingUtilities.getWindowAncestor(this);
    }

    public void initPanel() {
        Date start;
        this.onLabel = new JLabel("on ");
        this.startDateField.setDate(this.recurrence.getStartDate());
        this.frequencySpinner.setValue(this.recurrence.getFrequency());
        this.periodComboBox.setSelectedItem(this.recurrence.getPeriod().getType());
        this.advanceSpinner.setValue(this.recurrence.getAdvanceNbr());
        this.endNbrRadioButton.setSelected(this.recurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.recurrence.getEndNbr() == null ? 2 : this.recurrence.getEndNbr());
        this.endDateRadioButton.setSelected(this.recurrence.getEndDate() != null);
        this.endDateField.setDate(this.recurrence.getEndDate());
        this.endNeverRadioButton.setSelected(!this.endNbrRadioButton.isSelected() && !this.endDateRadioButton.isSelected());
        this.initPeriodPanel();
        if (this.endNbrRadioButton.isSelected() && (start = this.recurrence.getStartDate()) != null) {
            Period per = this.recurrence.getPeriod();
            int freq = this.recurrence.getFrequency();
            int endNbr = this.recurrence.getEndNbr();
            Intervals intervals = new Intervals(per, freq, start);
            Date endDate = Recurrence.getTerminationEndDate((Intervals)intervals, (int)endNbr);
            this.endDateField.setDate(endDate);
        }
    }

    private void initPeriodPanel() {
        PeriodType periodType = this.recurrence.getPeriod().getType();
        Period period = this.recurrence.getPeriod();
        this.periodPanel.removeAll();
        switch (periodType) {
            case WEEK: {
                this.periodPanel.add(this.onLabel);
                if (this.periodWeeklyPanel == null) {
                    this.periodWeeklyPanel = new PeriodWeeklyPanel();
                    this.periodWeeklyPanel.setPeriodWeek((PeriodWeek)period);
                }
                this.periodPanel.add(this.periodWeeklyPanel);
                break;
            }
            case MONTH: {
                if (this.periodMonthlyPanel == null) {
                    this.periodMonthlyPanel = new PeriodMonthlyPanel(this.getDialog(), (PeriodMonth)period);
                }
                this.periodPanel.add(this.periodMonthlyPanel);
                break;
            }
            case YEAR: {
                if (this.periodYearlyPanel == null) {
                    this.periodYearlyPanel = new PeriodYearlyPanel(this.getDialog(), (PeriodYear)period);
                }
                this.periodPanel.add(this.periodYearlyPanel);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.advanceSpinner.setEnabled(enabled);
        this.endDateRadioButton.setEnabled(enabled);
        this.endDateField.setEnabled(enabled && this.endDateRadioButton.isSelected());
        this.endNbrLabel.setEnabled(enabled);
        this.endNbrRadioButton.setEnabled(enabled);
        this.endNbrSpinner.setEnabled(enabled && this.endNbrRadioButton.isSelected());
        this.endNeverRadioButton.setEnabled(enabled);
        this.frequencySpinner.setEnabled(enabled);
        this.periodComboBox.setEnabled(enabled);
        this.periodPanel.setEnabled(enabled);
        this.startDateField.setEnabled(enabled);
        if (this.periodWeeklyPanel != null) {
            this.periodWeeklyPanel.setEnabled(enabled);
        }
        if (this.periodMonthlyPanel != null) {
            this.periodMonthlyPanel.setEnabled(enabled);
        }
        if (this.periodYearlyPanel != null) {
            this.periodYearlyPanel.setEnabled(enabled);
        }
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.startLabel = new JLabel();
        this.startDateField = new DateField();
        this.periodLabel = new JLabel();
        this.frequencySpinner = new JSpinner();
        this.periodPanel = new JPanel();
        this.advanceLabel1 = new JLabel();
        this.advanceSpinner = new JSpinner();
        this.advanceLabel2 = new JLabel();
        this.endLabel = new JLabel();
        this.endNeverRadioButton = new JRadioButton();
        this.endNbrRadioButton = new JRadioButton();
        this.endNbrSpinner = new JSpinner();
        this.endNbrLabel = new JLabel();
        this.endDateRadioButton = new JRadioButton();
        this.endDateField = new DateField();
        this.periodComboBox = new PeriodTypeComboBox();
        this.setMaximumSize(new Dimension(1024, 184));
        this.setMinimumSize(new Dimension(680, 184));
        this.startLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.startLabel, (String)"Start Date");
        this.startLabel.setMaximumSize(new Dimension(100, 23));
        this.startLabel.setMinimumSize(new Dimension(100, 23));
        this.startLabel.setPreferredSize(new Dimension(100, 23));
        this.startDateField.setMaximumSize(new Dimension(110, 23));
        this.startDateField.setMinimumSize(new Dimension(110, 23));
        this.startDateField.setPreferredSize(new Dimension(110, 23));
        this.periodLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.periodLabel, (String)"Periods");
        this.periodLabel.setMaximumSize(new Dimension(100, 23));
        this.periodLabel.setMinimumSize(new Dimension(100, 23));
        this.periodLabel.setPreferredSize(new Dimension(100, 23));
        this.frequencySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.frequencySpinner.setMaximumSize(new Dimension(50, 23));
        this.frequencySpinner.setMinimumSize(new Dimension(50, 23));
        this.frequencySpinner.setPreferredSize(new Dimension(50, 23));
        this.periodPanel.setMaximumSize(new Dimension(530, 26));
        this.periodPanel.setMinimumSize(new Dimension(530, 26));
        this.periodPanel.setPreferredSize(new Dimension(530, 26));
        this.periodPanel.setLayout(new FlowLayout(0, 5, 0));
        this.advanceLabel1.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.advanceLabel1, (String)"Generate");
        this.advanceLabel1.setMaximumSize(new Dimension(100, 23));
        this.advanceLabel1.setMinimumSize(new Dimension(100, 23));
        this.advanceLabel1.setPreferredSize(new Dimension(100, 23));
        this.advanceSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.advanceSpinner.setMaximumSize(new Dimension(50, 23));
        this.advanceSpinner.setMinimumSize(new Dimension(50, 23));
        this.advanceSpinner.setPreferredSize(new Dimension(50, 23));
        Mnemonics.setLocalizedText((JLabel)this.advanceLabel2, (String)"periods in advance");
        this.advanceLabel2.setMaximumSize(new Dimension(67, 23));
        this.advanceLabel2.setMinimumSize(new Dimension(67, 23));
        this.advanceLabel2.setPreferredSize(new Dimension(67, 23));
        this.endLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.endLabel, (String)"Terminate");
        this.endLabel.setMaximumSize(new Dimension(100, 23));
        this.endLabel.setMinimumSize(new Dimension(100, 23));
        this.endLabel.setPreferredSize(new Dimension(100, 23));
        this.buttonGroup.add(this.endNeverRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNeverRadioButton, (String)"never");
        this.endNeverRadioButton.setMaximumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setMinimumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setPreferredSize(new Dimension(90, 23));
        this.buttonGroup.add(this.endNbrRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNbrRadioButton, (String)"after");
        this.endNbrRadioButton.setMaximumSize(new Dimension(70, 23));
        this.endNbrRadioButton.setMinimumSize(new Dimension(70, 23));
        this.endNbrRadioButton.setPreferredSize(new Dimension(70, 23));
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.setMaximumSize(new Dimension(50, 23));
        this.endNbrSpinner.setMinimumSize(new Dimension(50, 23));
        this.endNbrSpinner.setPreferredSize(new Dimension(50, 23));
        Mnemonics.setLocalizedText((JLabel)this.endNbrLabel, (String)"periods");
        this.endNbrLabel.setMaximumSize(new Dimension(80, 23));
        this.endNbrLabel.setMinimumSize(new Dimension(80, 23));
        this.endNbrLabel.setPreferredSize(new Dimension(80, 23));
        this.buttonGroup.add(this.endDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endDateRadioButton, (String)"after");
        this.endDateRadioButton.setMaximumSize(new Dimension(70, 23));
        this.endDateRadioButton.setMinimumSize(new Dimension(70, 23));
        this.endDateRadioButton.setPreferredSize(new Dimension(70, 23));
        this.endDateField.setMaximumSize(new Dimension(110, 23));
        this.endDateField.setMinimumSize(new Dimension(110, 23));
        this.endDateField.setPreferredSize(new Dimension(110, 23));
        this.periodComboBox.setMaximumSize(new Dimension(125, 23));
        this.periodComboBox.setMinimumSize(new Dimension(125, 23));
        this.periodComboBox.setPreferredSize(new Dimension(125, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.startLabel, -2, -1, -2).add((Component)this.endLabel, -2, -1, -2).add((Component)this.advanceLabel1, -2, -1, -2).add((Component)this.periodLabel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.advanceSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.advanceLabel2, -2, 134, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.endNeverRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrLabel, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateField, -2, -1, -2)).add((Component)this.startDateField, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.periodPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.frequencySpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.periodComboBox, -2, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.startLabel, -2, -1, -2).add((Component)this.startDateField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.periodComboBox, -2, -1, -2).add(2, (Component)this.frequencySpinner, -2, -1, -2).add(2, (Component)this.periodLabel, -2, -1, -2)).addPreferredGap(0).add((Component)this.periodPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.advanceLabel2, -2, -1, -2).add(2, (Component)this.advanceSpinner, -2, -1, -2).add(2, (Component)this.advanceLabel1, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.endLabel, -2, -1, -2).add(2, (Component)this.endNeverRadioButton, -2, -1, -2).add(2, (Component)this.endNbrRadioButton, -2, -1, -2).add(2, (Component)this.endNbrSpinner, -2, -1, -2).add(2, (Component)this.endNbrLabel, -2, -1, -2).add(2, (Component)this.endDateRadioButton, -2, -1, -2).add(2, (Component)this.endDateField, -2, -1, -2)).addContainerGap(22, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.frequencySpinner, this.periodLabel}, 2);
        layout.linkSize(new Component[]{this.advanceLabel1, this.advanceLabel2, this.advanceSpinner}, 2);
        layout.linkSize(new Component[]{this.endDateField, this.endDateRadioButton, this.endLabel, this.endNbrLabel, this.endNbrRadioButton, this.endNbrSpinner, this.endNeverRadioButton}, 2);
    }
}

