/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class NewRecurrenceVisualPanel3
extends JPanel {
    private static int counter;
    private final Recurrence recurrence;
    private Map<PeriodType, Period> mapPeriods;
    private ButtonGroup buttonGroup;
    private DateField endDateField;
    private JRadioButton endDateRadioButton;
    private JLabel endLabel;
    private JLabel endNbrLabel;
    private JRadioButton endNbrRadioButton;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadioButton;
    private JLabel errorLabel1;
    private JSpinner frequencySpinner;
    private JLabel jLabel1;
    private PeriodTypeComboBox periodComboBox;

    public NewRecurrenceVisualPanel3(Recurrence recurrence) {
        this.recurrence = recurrence;
        this.initComponents();
        this.initPeriods();
        this.initPanel();
    }

    public String getName() {
        return "Define Subsequent Recurrence";
    }

    private void initPeriods() {
        this.setPeriod((Period)new PeriodWeekday());
        this.setPeriod((Period)new PeriodDay());
        this.setPeriod((Period)new PeriodWeek());
        this.setPeriod((Period)new PeriodMonth());
        this.setPeriod((Period)new PeriodYear());
        this.setPeriod(this.recurrence.getPeriod());
    }

    private Period getPeriod(PeriodType type) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        return this.mapPeriods.get(type);
    }

    private void setPeriod(Period period) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        this.mapPeriods.put(period.getType(), period);
    }

    private void enableDisableComponents() {
        this.endDateField.setEnabled(this.endDateRadioButton.isSelected());
        this.endNbrSpinner.setEnabled(this.endNbrRadioButton.isSelected());
    }

    private void setEndValues() {
        if (this.endNbrRadioButton.isSelected()) {
            this.recurrence.setEndNbr((Integer)this.endNbrSpinner.getValue());
            this.recurrence.setEndDate(null);
            return;
        }
        if (this.endDateRadioButton.isSelected()) {
            this.recurrence.setEndNbr(null);
            this.recurrence.setEndDate(this.endDateField.getDate());
            return;
        }
    }

    public void initPanel() {
        this.frequencySpinner.setValue(this.recurrence.getFrequency());
        this.periodComboBox.setSelectedItem(this.recurrence.getPeriod().getType());
        this.endNbrRadioButton.setSelected(this.recurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.recurrence.getEndNbr() == null ? 2 : this.recurrence.getEndNbr());
        this.endDateRadioButton.setSelected(this.recurrence.getEndDate() != null);
        this.endDateField.setDate(this.recurrence.getEndDate());
        this.endNeverRadioButton.setSelected(!this.endNbrRadioButton.isSelected() && !this.endDateRadioButton.isSelected());
        this.enableDisableComponents();
    }

    public void stateChange() {
        this.putClientProperty("state.change", ++counter);
    }

    public boolean isValidForm() {
        if (this.endDateRadioButton.isSelected() && this.endDateField.getDate() == null) {
            this.errorLabel1.setText("Termination date must be entered.");
            return false;
        }
        this.errorLabel1.setText("");
        return true;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.frequencySpinner = new JSpinner();
        this.periodComboBox = new PeriodTypeComboBox();
        this.endLabel = new JLabel();
        this.endNeverRadioButton = new JRadioButton();
        this.endNbrRadioButton = new JRadioButton();
        this.endNbrSpinner = new JSpinner();
        this.endNbrLabel = new JLabel();
        this.endDateRadioButton = new JRadioButton();
        this.endDateField = new DateField();
        this.errorLabel1 = new JLabel();
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(680, 280));
        this.setPreferredSize(new Dimension(680, 280));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"Create subsequent action in");
        this.jLabel1.setMaximumSize(new Dimension(180, 23));
        this.jLabel1.setMinimumSize(new Dimension(180, 23));
        this.jLabel1.setPreferredSize(new Dimension(180, 23));
        this.frequencySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.frequencySpinner.setMaximumSize(new Dimension(50, 23));
        this.frequencySpinner.setMinimumSize(new Dimension(50, 23));
        this.frequencySpinner.setPreferredSize(new Dimension(50, 23));
        this.frequencySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.frequencySpinnerStateChanged(evt);
            }
        });
        this.periodComboBox.setMaximumSize(new Dimension(125, 23));
        this.periodComboBox.setMinimumSize(new Dimension(125, 23));
        this.periodComboBox.setPreferredSize(new Dimension(125, 23));
        this.periodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel3.this.periodComboBoxActionPerformed(evt);
            }
        });
        this.endLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.endLabel, (String)"Terminate");
        this.endLabel.setMaximumSize(new Dimension(100, 23));
        this.endLabel.setMinimumSize(new Dimension(100, 23));
        this.endLabel.setPreferredSize(new Dimension(100, 23));
        this.buttonGroup.add(this.endNeverRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNeverRadioButton, (String)"never");
        this.endNeverRadioButton.setMaximumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setMinimumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setPreferredSize(new Dimension(90, 23));
        this.endNeverRadioButton.setVerticalTextPosition(1);
        this.endNeverRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endNeverRadioButtonStateChanged(evt);
            }
        });
        this.buttonGroup.add(this.endNbrRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNbrRadioButton, (String)"after");
        this.endNbrRadioButton.setMaximumSize(new Dimension(62, 23));
        this.endNbrRadioButton.setMinimumSize(new Dimension(62, 23));
        this.endNbrRadioButton.setPreferredSize(new Dimension(62, 23));
        this.endNbrRadioButton.setVerticalTextPosition(1);
        this.endNbrRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel3.this.endNbrRadioButtonActionPerformed(evt);
            }
        });
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.setMaximumSize(new Dimension(50, 23));
        this.endNbrSpinner.setMinimumSize(new Dimension(50, 23));
        this.endNbrSpinner.setPreferredSize(new Dimension(50, 23));
        this.endNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endNbrSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.endNbrLabel, (String)"occurrences");
        this.endNbrLabel.setMaximumSize(new Dimension(90, 23));
        this.endNbrLabel.setMinimumSize(new Dimension(90, 23));
        this.endNbrLabel.setPreferredSize(new Dimension(90, 23));
        this.buttonGroup.add(this.endDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endDateRadioButton, (String)"after");
        this.endDateRadioButton.setMaximumSize(new Dimension(62, 23));
        this.endDateRadioButton.setMinimumSize(new Dimension(62, 23));
        this.endDateRadioButton.setPreferredSize(new Dimension(62, 23));
        this.endDateRadioButton.setVerticalTextPosition(1);
        this.endDateRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endDateRadioButtonStateChanged(evt);
            }
        });
        this.endDateField.setMaximumSize(new Dimension(110, 23));
        this.endDateField.setMinimumSize(new Dimension(110, 23));
        this.endDateField.setPreferredSize(new Dimension(110, 23));
        this.endDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewRecurrenceVisualPanel3.this.endDateFieldPropertyChange(evt);
            }
        });
        this.errorLabel1.setForeground(Color.red);
        this.errorLabel1.setHorizontalAlignment(2);
        this.errorLabel1.setHorizontalTextPosition(0);
        this.errorLabel1.setMaximumSize(new Dimension(1024, 23));
        this.errorLabel1.setMinimumSize(new Dimension(16, 23));
        this.errorLabel1.setOpaque(true);
        this.errorLabel1.setPreferredSize(new Dimension(16, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.jLabel1, -2, -1, -2).add(1, 1, 1).add((Component)this.frequencySpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.periodComboBox, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.endLabel, -2, -1, -2).addPreferredGap(1).add((Component)this.endNeverRadioButton, -2, -1, -2).addPreferredGap(1).add((Component)this.endNbrRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrLabel, -2, -1, -2))).add(18, 18, 18).add((Component)this.endDateRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateField, -2, -1, -2).add(82, 82, 82)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.errorLabel1, -1, 681, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(new Component[]{this.endDateRadioButton, this.endNbrRadioButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(30, 30, 30).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1, -2, -1, -2).add((Component)this.frequencySpinner, -2, -1, -2).add((Component)this.periodComboBox, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.endNeverRadioButton, -2, -1, -2).add((Component)this.endLabel, -2, -1, -2).add((Component)this.endNbrRadioButton, -2, -1, -2).add((Component)this.endNbrSpinner, -2, -1, -2).add((Component)this.endNbrLabel, -2, -1, -2).add((Component)this.endDateRadioButton, -2, -1, -2).add((Component)this.endDateField, -2, -1, -2)).add(18, 18, 18).add((Component)this.errorLabel1, -2, -1, -2).addContainerGap(148, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.endDateField, this.endDateRadioButton, this.endLabel, this.endNbrLabel, this.endNbrRadioButton, this.endNbrSpinner, this.endNeverRadioButton}, 2);
    }

    private void periodComboBoxActionPerformed(ActionEvent evt) {
        this.recurrence.setPeriod(this.getPeriod((PeriodType)this.periodComboBox.getSelectedItem()));
        this.stateChange();
        this.setEndValues();
    }

    private void endNbrRadioButtonActionPerformed(ActionEvent evt) {
        this.setEndValues();
        this.stateChange();
        this.enableDisableComponents();
    }

    private void frequencySpinnerStateChanged(ChangeEvent evt) {
        this.recurrence.setFrequency(((Integer)this.frequencySpinner.getValue()).intValue());
        this.stateChange();
        this.setEndValues();
    }

    private void endNeverRadioButtonStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }

    private void endNbrSpinnerStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
    }

    private void endDateFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.stateChange();
            this.setEndValues();
        }
    }

    private void endDateRadioButtonStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }
}

