'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/ftpd/ftpd.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ftpd" n 1.2.4 ftpd "Tcl FTP Server Package"
.BS
.SH NAME
ftpd \- Tcl FTP server implementation
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBftpd  ?1.2.4?\fR
.sp
\fB::ftpd::server\fR ?\fImyaddr\fR?
.sp
\fB::ftpd::config\fR ?\fIoption value\fR? ?\fIoption value ...\fR?
.sp
\fIfsCmd\fR \fBappend\fR \fIpath\fR
.sp
\fIfsCmd\fR \fBdelete\fR \fIpath\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBdlist\fR \fIpath\fR \fIstyle\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBexists\fR \fIpath\fR
.sp
\fIfsCmd\fR \fBmkdir\fR \fIpath\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBmtime\fR \fIpath\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBpermissions\fR \fIpath\fR
.sp
\fIfsCmd\fR \fBrename\fR \fIpath\fR \fInewpath\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBretr\fR \fIpath\fR
.sp
\fIfsCmd\fR \fBrmdir\fR \fIpath\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBsize\fR \fIpath\fR \fIchannel\fR
.sp
\fIfsCmd\fR \fBstore\fR \fIpath\fR
.sp
.BE
.SH DESCRIPTION
The \fBftpd\fR package provides a simple Tcl-only server library
for the FTP protocol as specified in
RFC 959 (\fIhttp://www.rfc-editor.org/rfc/rfc959.txt\fR).
It works by listening on the standard FTP socket.  Most server errors
are returned as error messages with the appropriate code attached to
them.  Since the server code for the ftp daemon is executed in the
event loop, it is possible that a
\fBbgerror\fR will be thrown on the server if there are problems with
the code in the module.
.SH COMMANDS
.TP
\fB::ftpd::server\fR ?\fImyaddr\fR?
Open a listening socket to listen to and accept ftp connections.
myaddr is an optional argument.  \fImyaddr\fR is the domain-style name
or numerical IP address of the client-side network interface to use
for the connection.
.TP
\fB::ftpd::config\fR ?\fIoption value\fR? ?\fIoption value ...\fR?
The value is always the name of the command to call as the
callback. The option specifies which callback should be configured.
See section \fBCALLBACKS\fR for descriptions of the arguments and
return values for each of the callbacks.
.RS
.TP
-authIpCmd \fIproc\fR
Callback to authenticate new connections based on the ip-address of
the peer.
.TP
-authUsrCmd \fIproc\fR
Callback to authenticate new connections based on the user logging in
(and the users password).
.TP
-authFileCmd \fIproc\fR
Callback to accept or deny a users access to read and write to a
specific path or file.
.TP
-logCmd \fIproc\fR
Callback for log information generated by the FTP engine.
.TP
-fsCmd \fIproc\fR
Callback to connect the engine to the filesystem it operates on.
.TP
-closeCmd \fIproc\fR
Callback to be called when a connection is closed. This allows the
embedding application to perform its own cleanup operations.
.TP
-xferDoneCmd \fIproc\fR
Callback for transfer completion notification. In other words, it is
called whenever a transfer of data to or from the client has
completed.
.RE
.PP
.SH CALLBACKS
.TP
\fBauthIpCmd\fR callback
The authIpCmd receives the ip-address of the peer attempting to
connect to the ftp server as its argument. It returns a 1 to allow
users from the specified IP to attempt to login and a 0 to reject the
login attempt from the specified IP.
.TP
\fBauthUsrCmd\fR callback
The authUsrCmd receives the username and password as its two
arguments. It returns a 1 to accept the attempted login to the ftpd
and a 0 to reject the attempted login.
.TP
\fBauthFileCmd\fR callback
The authFileCmd receives the user (that is currently logged in), the
path or filename that is about to be read or written, and
\fBread\fR or \fBwrite\fR as its three arguments.  It returns a
1 to allow the path or filename to be read or written, and a 0 to
reject the attempted read or write with a permissions error code.
.TP
\fBlogCmd\fR callback
The logCmd receives a severity and a message as its two arguments.
The severities used within the ftpd package are \fBnote\fR,
\fBdebug\fR, and \fBerror\fR. The logCmd doesn't return
anything.
.TP
\fBfsCmd\fR callback
The fsCmd receives a subcommand, a filename or path, and optional
additional arguments (depending on the subcommand).
.sp
The subcommands supported by the fsCmd are:
.RS
.TP
\fIfsCmd\fR \fBappend\fR \fIpath\fR
The append subcommand receives the filename to append to as its
argument. It returns a writable tcl channel as its return value.
.TP
\fIfsCmd\fR \fBdelete\fR \fIpath\fR \fIchannel\fR
The delete subcommand receives the filename to delete, and a channel
to write to as its two arguments.  The file specified is deleted and
the appropriate ftp message is written to the channel that is passed
as the second argument.  The delete subcommand returns nothing.
.TP
\fIfsCmd\fR \fBdlist\fR \fIpath\fR \fIstyle\fR \fIchannel\fR
The dlist subcommand receives the path that it should list the files
that are in, the style in which the files should be listed which is
either \fBnlst\fR or \fBlist\fR, and a channel to write to as
its three arguments.  The files in the specified path are printed to
the specified channel one per line.  If the style is \fBnlst\fR
only the name of the file is printed to the channel.  If the style is
\fBlist\fR then the file permissions, number of links to the file,
the name of the user that owns the file, the name of the group that
owns the file, the size (in bytes) of the file, the modify time of the
file, and the filename are printed out to the channel in a formatted
space separated format.  The \fBdlist\fR subcommand returns
nothing.
.TP
\fIfsCmd\fR \fBexists\fR \fIpath\fR
The exists subcommand receives the name of a file to check the
existence of as its only argument.  The exists subcommand returns a 1
if the path specified exists and the path is not a directory.
.TP
\fIfsCmd\fR \fBmkdir\fR \fIpath\fR \fIchannel\fR
The mkdir subcommand receives the path of a directory to create and a
channel to write to as its two arguments.  The mkdir subcommand
creates the specified directory if necessary and possible.  The mkdir
subcommand then prints the appropriate success or failure message to
the channel.  The mkdir subcommand returns nothing.
.TP
\fIfsCmd\fR \fBmtime\fR \fIpath\fR \fIchannel\fR
The mtime subcommand receives the path of a file to check the modify
time on and a channel as its two arguments.  If the file exists the
mtime is printed to the channel in the proper FTP format, otherwise an
appropriate error message and code are printed to the channel.  The
mtime subcommand returns nothing.
.TP
\fIfsCmd\fR \fBpermissions\fR \fIpath\fR
The permissions subcommand receives the path of a file to retrieve the
permissions of.  The permissions subcommand returns the octal file
permissions of the specified file.  The file is expected to exist.
.TP
\fIfsCmd\fR \fBrename\fR \fIpath\fR \fInewpath\fR \fIchannel\fR
The rename subcommand receives the path of the current file, the new
file path, and a channel to write to as its three arguments.  The
rename subcommand renames the current file to the new file path if the
path to the new file exists, and then prints out the appropriate
message to the channel.  If the new file path doesn't exist the
appropriate error message is printed to the channel.  The rename
subcommand returns nothing.
.TP
\fIfsCmd\fR \fBretr\fR \fIpath\fR
The retr subcommand receives the path of a file to read as its only
argument.  The retr subcommand returns a readable channel that the
specified file can be read from.
.TP
\fIfsCmd\fR \fBrmdir\fR \fIpath\fR \fIchannel\fR
The rmdir subcommand receives the path of a directory to remove and a
channel to write to as its two arguments.  The rmdir subcommand
removes the specified directory (if possible) and prints the
appropriate message to the channel (which may be an error if the
specified directory does not exist or is not empty).  The rmdir
subcommand returns nothing.
.TP
\fIfsCmd\fR \fBsize\fR \fIpath\fR \fIchannel\fR
The size subcommand receives the path of a file to get the size (in
bytes) of and a channel to write to as its two arguments.  The size
subcommand prints the appropriate code and the size of the file if the
specified path is a file, otherwise an appropriate error code and
message are printed to the channel.  The size subcommand returns
nothing.
.TP
\fIfsCmd\fR \fBstore\fR \fIpath\fR
The store subcommand receives the path of a file to write as its only
argument.  The store subcommand returns a writable channel.
.RE
.TP
\fBcloseCmd\fR
The \fBcloseCmd\fR receives no arguments when it is invoked, and any
return value it may generate is discarded.
.TP
\fBxferDoneCmd\fR sock sock2 file bytes filename err
The \fBxferDoneCmd\fR receives six arguments when invoked. These are,
in this order, the channel handle of the control socket for the
connection, the channel handle of the data socket used for the
transfer (already closed), the handle of the channel containing the
transfered file, the number of bytes transfered, the path of the file
which was transfered, and a (possibly empty) error message.
Any return value it may generate is discarded.
.PP
.SH VARIABLES
.TP
\fB::ftpd::cwd\fR
The current working directory for a session when someone first
connects to the FTPD or when the \fBREIN\fR ftp command is received.
.TP
\fB::ftpd::contact\fR
The e-mail address of the person that is the contact for the ftp
server.  This address is printed out as part of the response to the
\fBFTP HELP\fR command.
.TP
\fB::ftpd::port\fR
The port that the ftp server should listen on.
If port is specified as zero, the operating system will allocate an
unused port for use as a server socket; afterwards, the variable will
contain the port number that was allocated.
.TP
\fB::ftpd::welcome\fR
The message that is printed out when the user first connects to the
ftp server.
.TP
\fB::ftpd::CurrentSocket\fR
Accessible to all callbacks and all filesystem commands (which are a
special form of callback) and contains the handle of the socket
channel which was active when the callback was invoked.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIftpd\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
ftp, ftpd, ftpserver, rfc 959, services