'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.11.1/tcllib-1.11.1/modules/fileutil/fileutil.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "fileutil" n 1.13.5 fileutil "file utilities"
.BS
.SH NAME
fileutil \- Procedures implementing some file utilities
.SH SYNOPSIS
package require \fBTcl  8\fR
.sp
package require \fBfileutil  ?1.13.5?\fR
.sp
\fB::fileutil::fullnormalize\fR \fIpath\fR
.sp
\fB::fileutil::test\fR \fIpath\fR \fIcodes\fR ?\fImsgvar\fR? ?\fIlabel\fR?
.sp
\fB::fileutil::cat\fR (?\fIoptions\fR? \fIfile\fR)...
.sp
\fB::fileutil::writeFile\fR ?\fIoptions\fR? \fIfile\fR \fIdata\fR
.sp
\fB::fileutil::appendToFile\fR ?\fIoptions\fR? \fIfile\fR \fIdata\fR
.sp
\fB::fileutil::insertIntoFile\fR ?\fIoptions\fR? \fIfile\fR \fIat\fR \fIdata\fR
.sp
\fB::fileutil::removeFromFile\fR ?\fIoptions\fR? \fIfile\fR \fIat\fR \fIn\fR
.sp
\fB::fileutil::replaceInFile\fR ?\fIoptions\fR? \fIfile\fR \fIat\fR \fIn\fR \fIdata\fR
.sp
\fB::fileutil::updateInPlace\fR ?\fIoptions\fR? \fIfile\fR \fIcmd\fR
.sp
\fB::fileutil::fileType\fR \fIfilename\fR
.sp
\fB::fileutil::find\fR ?\fIbasedir\fR ?\fIfiltercmd\fR??
.sp
\fB::fileutil::findByPattern\fR \fIbasedir\fR ?\fB-regexp\fR|\fB-glob\fR? ?\fB--\fR? \fIpatterns\fR
.sp
\fB::fileutil::foreachLine\fR \fIvar filename cmd\fR
.sp
\fB::fileutil::grep\fR \fIpattern\fR ?\fIfiles\fR?
.sp
\fB::fileutil::install\fR ?\fB-m\fR \fImode\fR? \fIsource\fR \fIdestination\fR
.sp
\fB::fileutil::stripN\fR \fIpath\fR \fIn\fR
.sp
\fB::fileutil::stripPwd\fR \fIpath\fR
.sp
\fB::fileutil::stripPath\fR \fIprefix\fR \fIpath\fR
.sp
\fB::fileutil::jail\fR \fIjail\fR \fIpath\fR
.sp
\fB::fileutil::touch\fR ?\fB-a\fR? ?\fB-c\fR? ?\fB-m\fR? ?\fB-r\fR \fIref_file\fR? ?\fB-t\fR \fItime\fR? \fIfilename\fR ?\fI...\fR?
.sp
\fB::fileutil::tempdir\fR
.sp
\fB::fileutil::tempdir\fR \fIpath\fR
.sp
\fB::fileutil::tempdirReset\fR
.sp
\fB::fileutil::tempfile\fR ?\fIprefix\fR?
.sp
\fB::fileutil::relative\fR \fIbase\fR \fIdst\fR
.sp
\fB::fileutil::relativeUrl\fR \fIbase\fR \fIdst\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides implementations of standard unix utilities.
.TP
\fB::fileutil::fullnormalize\fR \fIpath\fR
This command resolves all symbolic links in the \fIpath\fR and returns
the changed path as its result.
In contrast to the builtin \fBfile normalize\fR this command
resolves a symbolic link in the last element of the path as well.
.TP
\fB::fileutil::test\fR \fIpath\fR \fIcodes\fR ?\fImsgvar\fR? ?\fIlabel\fR?
A command for the testing of several properties of a \fIpath\fR. The
properties to test for are specified in \fIcodes\fR, either as a list
of keywords describing the properties, or as a string where each
letter is a shorthand for a property to test. The recognized keywords,
shorthands, and associated properties are shown in the list below. The
tests are executed in the order given to the command.
.sp
The result of the command is a boolean value. It will be true if and
only if the \fIpath\fR passes all the specified tests.
In the case of the \fIpath\fR not passing one or more test the first
failing test will leave a message in the variable referenced by
\fImsgvar\fR, if such is specified. The message will be prefixed with
\fIlabel\fR, if it is specified.
\fINote\fR that the variabled referenced by \fImsgvar\fR is not touched at
all if all the tests pass.
.sp
.RS
.TP
\fIr\fRead
\fBfile readable\fR
.TP
\fIw\fRrite
\fBfile writable\fR
.TP
\fIe\fRxists
\fBfile exists\fR
.TP
e\fIx\fRec
\fBfile executable\fR
.TP
\fIf\fRile
\fBfile isfile\fR
.TP
\fId\fRir
\fBfile isdirectory\fR
.RE
.TP
\fB::fileutil::cat\fR (?\fIoptions\fR? \fIfile\fR)...
A tcl implementation of the UNIX \fBcat\fR command.  Returns the
contents of the specified file(s). The arguments are files to read,
with interspersed options configuring the process. If there are
problems reading any of the files, an error will occur, and no data
will be returned.
.sp
The options accepted are \fB-encoding\fR, \fB-translation\fR,
\fB-eofchar\fR, and \fB--\fR. With the exception of the last all
options take a single value as argument, as specified by the tcl
builtin command \fBfconfigure\fR. The \fB--\fR has to be used to
terminate option processing before a file if that file's name begins
with a dash.
.sp
Each file can have its own set of options coming before it, and for
anything not specified directly the defaults are inherited from the
options of the previous file. The first file inherits the system
default for unspecified options.
.TP
\fB::fileutil::writeFile\fR ?\fIoptions\fR? \fIfile\fR \fIdata\fR
The command replaces the current contents of the specified \fIfile\fR
with \fIdata\fR, with the process configured by the options. The
command accepts the same options as \fB::fileutil::cat\fR. The
specification of a non-existent file is legal and causes the command
to create the file (and all required but missing directories).
.TP
\fB::fileutil::appendToFile\fR ?\fIoptions\fR? \fIfile\fR \fIdata\fR
This command is like \fB::fileutil::writeFile\fR, except that the
previous contents of \fIfile\fR are not replaced, but appended to. The
command accepts the same options as \fB::fileutil::cat\fR
.TP
\fB::fileutil::insertIntoFile\fR ?\fIoptions\fR? \fIfile\fR \fIat\fR \fIdata\fR
This comment is similar to \fB::fileutil::appendToFile\fR, except that
the new data is not appended at the end, but inserted at a specified
location within the file. In further contrast this command has to be
given the path to an existing file. It will not create a missing file,
but throw an error instead.
.sp
The specified location \fIat\fR has to be an integer number in the
range \fB0\fR ... [file size \fIfile\fR]. \fB0\fR will cause
insertion of the new data before the first character of the existing
content, whereas [file size \fIfile\fR] causes insertion after
the last character of the existing content, i.e. appending.
.sp
The command accepts the same options as \fB::fileutil::cat\fR.
.TP
\fB::fileutil::removeFromFile\fR ?\fIoptions\fR? \fIfile\fR \fIat\fR \fIn\fR
This command is the complement to \fB::fileutil::insertIntoFile\fR, removing \fIn\fR characters from the \fIfile\fR, starting at location \fIat\fR.
The specified location \fIat\fR has to be an integer number in the
range \fB0\fR ... [file size \fIfile\fR] - \fIn\fR. \fB0\fR
will cause the removal of the new data to start with the first
character of the existing content,
whereas [file size \fIfile\fR] - \fIn\fR causes the removal of
the tail of the existing content, i.e. the truncation of the file.
.sp
The command accepts the same options as \fB::fileutil::cat\fR.
.TP
\fB::fileutil::replaceInFile\fR ?\fIoptions\fR? \fIfile\fR \fIat\fR \fIn\fR \fIdata\fR
This command is a combination of \fB::fileutil::removeFromFile\fR and
\fB::fileutil::insertIntoFile\fR. It first removes the part of the
contents specified by the arguments \fIat\fR and \fIn\fR, and then
inserts \fIdata\fR at the given location, effectively replacing the
removed by content with \fIdata\fR.
All constraints imposed on \fIat\fR and \fIn\fR by
\fB::fileutil::removeFromFile\fR and \fB::fileutil::insertIntoFile\fR
are obeyed.
.sp
The command accepts the same options as \fB::fileutil::cat\fR.
.TP
\fB::fileutil::updateInPlace\fR ?\fIoptions\fR? \fIfile\fR \fIcmd\fR
This command can be seen as the generic core functionality of
\fB::fileutil::replaceInFile\fR.
It first reads the contents of the specified \fIfile\fR, then runs the
command prefix \fIcmd\fR with that data appended to it, and at last
writes the result of that invokation back as the new contents of the
file.
.sp
If the executed command throws an error the \fIfile\fR is not changed.
.sp
The command accepts the same options as \fB::fileutil::cat\fR.
.TP
\fB::fileutil::fileType\fR \fIfilename\fR
An implementation of the UNIX \fBfile\fR command, which uses
various heuristics to guess the type of a file.  Returns a list
specifying as much type information as can be determined about the
file, from most general (eg, "binary" or "text") to most specific (eg,
"gif").  For example, the return value for a GIF file would be "binary
graphic gif".  The command will detect the following types of files:
directory, empty, binary, text, script (with interpreter), executable
elf, executable dos, executable ne, executable pe, graphic gif,
graphic jpeg, graphic png, graphic tiff, graphic bitmap, html,
xml (with doctype if available), message pgp, binary pdf, text ps,
text eps, binary gravity_wave_data_frame, compressed bzip,
compressed gzip, compressed zip, compressed tar, audio wave,
audio mpeg, and link.
.TP
\fB::fileutil::find\fR ?\fIbasedir\fR ?\fIfiltercmd\fR??
An implementation of the unix command \fBfind\fR. Adapted from the
Tcler's Wiki. Takes at most two arguments, the path to the directory
to start searching from and a command to use to evaluate interest in
each file. The path defaults to "\fI.\fR", i.e. the current
directory. The command defaults to the empty string, which means that
all files are of interest. The command takes care \fInot\fR to
lose itself in infinite loops upon encountering circular link
structures. The result of the command is a list containing the paths
to the interesting files.
.sp
The \fIfiltercmd\fR, if specified, is interpreted as a command prefix
and one argument is added to it, the name of the file or directory
find is currently looking at. Note that this name is \fInot\fR fully
qualified. It has to be joined it with the result of \fBpwd\fR to get
an absolute filename.
.sp
The result of \fIfiltercmd\fR is a boolean value that indicates if the
current file should be included in the list of interesting files.
.sp
Example:
.sp
.nf

    # find .tcl files
    package require fileutil
    proc is_tcl {name} {return [string match *.tcl $name]}
    set tcl_files [fileutil::find . is_tcl]

.fi
.TP
\fB::fileutil::findByPattern\fR \fIbasedir\fR ?\fB-regexp\fR|\fB-glob\fR? ?\fB--\fR? \fIpatterns\fR
This command is based upon the \fBTclX\fR command
\fBrecursive_glob\fR, except that it doesn't allow recursion over more
than one directory at a time. It uses \fB::fileutil::find\fR
internally and is thus able to and does follow symbolic links,
something the \fBTclX\fR command does not do. First argument is
the directory to start the search in, second argument is a list of
\fIpatterns\fR. The command returns a list of all files reachable
through \fIbasedir\fR whose names match at least one of the
patterns. The options before the pattern-list determine the style of
matching, either regexp or glob. glob-style matching is the default if
no options are given. Usage of the option \fB--\fR stops option
processing. This allows the use of a leading '-' in the patterns.
.TP
\fB::fileutil::foreachLine\fR \fIvar filename cmd\fR
The command reads the file \fIfilename\fR and executes the script
\fIcmd\fR for every line in the file. During the execution of the
script the variable \fIvar\fR is set to the contents of the current
line. The return value of this command is the result of the last
invocation of the script \fIcmd\fR or the empty string if the file was
empty.
.TP
\fB::fileutil::grep\fR \fIpattern\fR ?\fIfiles\fR?
Implementation of \fBgrep\fR. Adapted from the Tcler's Wiki. The
first argument defines the \fIpattern\fR to search for. This is
followed by a list of \fIfiles\fR to search through. The list is
optional and \fBstdin\fR will be used if it is missing. The result
of the procedures is a list containing the matches. Each match is a
single element of the list and contains filename, number and contents
of the matching line, separated by a colons.
.TP
\fB::fileutil::install\fR ?\fB-m\fR \fImode\fR? \fIsource\fR \fIdestination\fR
The \fBinstall\fR command is similar in functionality to the \fBinstall\fR
command found on many unix systems, or the shell script
distributed with many source distributions (unix/install-sh in the Tcl
sources, for example).  It copies \fIsource\fR, which can be either a
file or directory to \fIdestination\fR, which should be a directory,
unless \fIsource\fR is also a single file.  The ?-m? option lets
the user specify a unix-style mode (either octal or symbolic - see
\fBfile attributes\fR.
.TP
\fB::fileutil::stripN\fR \fIpath\fR \fIn\fR
Removes the first \fIn\fR elements from the specified \fIpath\fR and
returns the modified path. If \fIn\fR is greater than the number of
components in \fIpath\fR an empty string is returned. The number of
components in a given path may be determined by performing
\fBllength\fR on the list returned by \fBfile split\fR.
.TP
\fB::fileutil::stripPwd\fR \fIpath\fR
If, and only if the \fIpath\fR is inside of the directory returned by
[\fBpwd\fR] (or the current working directory itself) it is made
relative to that directory. In other words, the current working
directory is stripped from the \fIpath\fR.  The possibly modified path
is returned as the result of the command. If the current working
directory itself was specified for \fIpath\fR the result is the string
"\fB.\fR".
.TP
\fB::fileutil::stripPath\fR \fIprefix\fR \fIpath\fR
If, and only of the \fIpath\fR is inside of the directory
"\fIprefix\fR" (or the prefix directory itself) it is made relative to
that directory. In other words, the prefix directory is stripped from
the \fIpath\fR. The possibly modified path is returned as the result
of the command.
If the prefix directory itself was specified for \fIpath\fR the result
is the string "\fB.\fR".
.TP
\fB::fileutil::jail\fR \fIjail\fR \fIpath\fR
This command ensures that the \fIpath\fR is not escaping the directory
\fIjail\fR. It always returns an absolute path derived from \fIpath\fR
which is within \fIjail\fR.
.sp
If \fIpath\fR is an absolute path and already within \fIjail\fR it is
returned unmodified.
.sp
An absolute path outside of \fIjail\fR is stripped of its root element
and then put into the \fIjail\fR by prefixing it with it. The same
happens if \fIpath\fR is relative, except that nothing is stripped of
it. Before adding the \fIjail\fR prefix the \fIpath\fR is lexically
normalized to prevent the caller from using \fB..\fR segments in
\fIpath\fR to escape the jail.
.TP
\fB::fileutil::touch\fR ?\fB-a\fR? ?\fB-c\fR? ?\fB-m\fR? ?\fB-r\fR \fIref_file\fR? ?\fB-t\fR \fItime\fR? \fIfilename\fR ?\fI...\fR?
Implementation of \fBtouch\fR. Alter the atime and mtime of the
specified files. If \fB-c\fR, do not create files if they do not
already exist. If \fB-r\fR, use the atime and mtime from
\fIref_file\fR. If \fB-t\fR, use the integer clock value
\fItime\fR. It is illegal to specify both \fB-r\fR and
\fB-t\fR. If \fB-a\fR, only change the atime. If \fB-m\fR,
only change the mtime.
.sp
\fIThis command is not available for Tcl versions less than 8.3.\fR
.TP
\fB::fileutil::tempdir\fR
The command returns the path of a directory where the caller can
place temporary files, such as "\fI/tmp\fR" on Unix systems. The
algorithm we use to find the correct directory is as follows:
.RS
.IP [1]
The directory set by an invokation of \fB::fileutil::tempdir\fR with
an argument. If this is present it is tried exclusively and none of
the following item are tried.
.IP [2]
The directory named in the TMPDIR environment variable.
.IP [3]
The directory named in the TEMP environment variable.
.IP [4]
The directory named in the TMP environment variable.
.IP [5]
A platform specific location:
.RS
.TP
Windows
"\fIC:\\TEMP\fR", "\fIC:\\TMP\fR", "\fI\\TEMP\fR",
and "\fI\\TMP\fR" are tried in that order.
.TP
(classic) Macintosh
The TRASH_FOLDER environment variable is used.  This is most likely
not correct.
.TP
Unix
The directories "\fI/tmp\fR", "\fI/var/tmp\fR", and "\fI/usr/tmp\fR" are
tried in that order.
.RE
.RE
.sp
The algorithm utilized is mainly that used in the Python standard
library. The exception is the first item, the ability to have the
search overridden by a user-specified directory.
.TP
\fB::fileutil::tempdir\fR \fIpath\fR
In this mode the command sets the \fIpath\fR as the first and only
directory to try as a temp. directory. See the previous item for the
use of the set directory. The command returns the empty string.
.TP
\fB::fileutil::tempdirReset\fR
Invoking this command clears the information set by the
last call of [\fB::fileutil::tempdir\fR \fIpath\fR].
See the last item too.
.TP
\fB::fileutil::tempfile\fR ?\fIprefix\fR?
The command generates a temporary file name suitable for writing to,
and the associated file.  The file name will be unique, and the file
will be writable and contained in the appropriate system specific temp
directory. The name of the file will be returned as the result of the
command.
.sp
The code was taken from \fIhttp://wiki.tcl.tk/772\fR, attributed to
Igor Volobouev and anon.
.TP
\fB::fileutil::relative\fR \fIbase\fR \fIdst\fR
This command takes two directory paths, both either absolute or relative
and computes the path of \fIdst\fR relative to \fIbase\fR. This relative
path is returned as the result of the command. As implied in the previous
sentence, the command is not able to compute this relationship between the
arguments if one of the paths is absolute and the other relative.
.sp
\fINote:\fR The processing done by this command is purely lexical.
Symbolic links are \fInot\fR taken into account.
.TP
\fB::fileutil::relativeUrl\fR \fIbase\fR \fIdst\fR
This command takes two file paths, both either absolute or relative
and computes the path of \fIdst\fR relative to \fIbase\fR, as seen
from inside of the \fIbase\fR. This is the algorithm how a browser
resolves a relative link found in the currently shown file.
.sp
The computed relative path is returned as the result of the command.
As implied in the previous sentence, the command is not able to compute
this relationship between the arguments if one of the paths is absolute
and the other relative.
.sp
\fINote:\fR The processing done by this command is purely lexical.
Symbolic links are \fInot\fR taken into account.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIfileutil\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
cat, file utilities, grep, temp file, test, touch, type