/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int bufferHandle;
    int tabs = 8;
    int lastEventTime = 0;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    boolean doubleClick;
    static final int INNER_BORDER = 2;
    static final int ITER_SIZEOF = OS.GtkTextIter_sizeof();
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\n";

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
    }

    static int checkStyle(int style) {
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        if ((this.style & 4) != 0) {
            this.handle = OS.gtk_entry_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            OS.gtk_editable_set_editable(this.handle, (this.style & 8) == 0);
            OS.gtk_entry_set_has_frame(this.handle, (this.style & 0x800) != 0);
            OS.gtk_entry_set_visibility(this.handle, (this.style & 0x400000) == 0);
            float alignment = 0.0f;
            if ((this.style & 0x1000000) != 0) {
                alignment = 0.5f;
            }
            if ((this.style & 0x20000) != 0) {
                alignment = 1.0f;
            }
            if (alignment > 0.0f) {
                OS.gtk_entry_set_alignment(this.handle, alignment);
            }
        } else {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            this.handle = OS.gtk_text_view_new();
            if (this.handle == 0) {
                this.error(2);
            }
            this.bufferHandle = OS.gtk_text_view_get_buffer(this.handle);
            if (this.bufferHandle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            OS.gtk_text_view_set_editable(this.handle, (this.style & 8) == 0);
            if ((this.style & 0x40) != 0) {
                OS.gtk_text_view_set_wrap_mode(this.handle, 2);
            }
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
            if ((this.style & 0x800) != 0) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
            int just = 0;
            if ((this.style & 0x1000000) != 0) {
                just = 2;
            }
            if ((this.style & 0x20000) != 0) {
                just = 1;
            }
            OS.gtk_text_view_set_justification(this.handle, just);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.doubleClick = true;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, new int[]{-1});
            OS.gtk_editable_set_position(this.handle, -1);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, position);
            OS.gtk_text_buffer_insert(this.bufferHandle, position, buffer, buffer.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int position = OS.gtk_editable_get_position(this.handle);
            OS.gtk_editable_select_region(this.handle, position, position);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            int insertMark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
            OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, insertMark);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, selectionMark, position);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, insertMark, position);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int[] w = new int[1];
        int[] h = new int[1];
        if ((this.style & 4) != 0) {
            int layout = OS.gtk_entry_get_layout(this.handle);
            OS.pango_layout_get_size(layout, w, h);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, start, end);
            int text = OS.gtk_text_buffer_get_text(this.bufferHandle, start, end, true);
            int layout = OS.gtk_widget_create_pango_layout(this.handle, text);
            OS.g_free(text);
            OS.pango_layout_set_width(layout, wHint * 1024);
            OS.pango_layout_get_size(layout, w, h);
            OS.g_object_unref(layout);
        }
        int width = OS.PANGO_PIXELS(w[0]);
        int height = OS.PANGO_PIXELS(h[0]);
        width = wHint == -1 ? width : wHint;
        height = hHint == -1 ? height : hHint;
        Rectangle trim = this.computeTrim(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int xborder = 0;
        int yborder = 0;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x800) != 0) {
                int style = OS.gtk_widget_get_style(this.handle);
                xborder += OS.gtk_style_get_xthickness(style);
                yborder += OS.gtk_style_get_ythickness(style);
            }
            xborder += 2;
            yborder += 2;
        } else {
            int borderWidth = OS.gtk_container_get_border_width(this.handle);
            xborder += borderWidth;
            yborder += borderWidth;
        }
        int[] property = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.interior_focus, property, 0);
        if (property[0] == 0) {
            OS.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0);
            xborder += property[0];
            yborder += property[0];
        }
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_copy_clipboard(this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get(0);
            OS.gtk_text_buffer_copy_clipboard(this.bufferHandle, clipboard);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_cut_clipboard(this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get(0);
            OS.gtk_text_buffer_cut_clipboard(this.bufferHandle, clipboard, OS.gtk_text_view_get_editable(this.handle));
        }
    }

    void deregister() {
        int imContext;
        super.deregister();
        if (this.bufferHandle != 0) {
            this.display.removeWidget(this.bufferHandle);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.removeWidget(imContext);
        }
    }

    boolean dragDetect(int x, int y) {
        Object[] e;
        Object[] s;
        int start = 0;
        int end = 0;
        if ((this.style & 4) != 0) {
            s = new int[1];
            e = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, s, e);
            start = s[0];
            end = e[0];
        } else {
            s = new byte[ITER_SIZEOF];
            e = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, (byte[])s, (byte[])e);
            start = OS.gtk_text_iter_get_offset((byte[])s);
            end = OS.gtk_text_iter_get_offset((byte[])e);
        }
        if (start == end) {
            return false;
        }
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        int offset = -1;
        if ((this.style & 4) != 0) {
            int layout = OS.gtk_entry_get_layout(this.handle);
            int[] index = new int[1];
            int[] trailing = new int[1];
            OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
            int ptr = OS.pango_layout_get_text(layout);
            offset = OS.g_utf8_pointer_to_offset(ptr, ptr + index[0]);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.gtk_text_view_get_iter_at_location(this.handle, position, x, y);
            offset = OS.gtk_text_iter_get_offset(position);
        }
        return offset > start && offset < end;
    }

    boolean dragOverride() {
        return true;
    }

    boolean filterKey(int keyval, int event) {
        int time = OS.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            int imContext = this.imContext();
            if (imContext != 0) {
                return OS.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    void fixIM() {
        int imContext;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (imContext = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public int getBorderWidth() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return super.getBorderWidth();
        }
        int style = OS.gtk_widget_get_style(this.handle);
        if ((this.style & 0x800) != 0) {
            return OS.gtk_style_get_xthickness(style);
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        return OS.gtk_text_iter_get_line(position);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int index = OS.gtk_editable_get_position(this.handle);
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) {
                index = OS.gtk_entry_text_index_to_layout_index(this.handle, index);
            }
            int[] offset_x = new int[1];
            int[] offset_y = new int[1];
            OS.gtk_entry_get_layout_offsets(this.handle, offset_x, offset_y);
            int layout = OS.gtk_entry_get_layout(this.handle);
            PangoRectangle pos = new PangoRectangle();
            OS.pango_layout_index_to_pos(layout, index, pos);
            int x = offset_x[0] + OS.PANGO_PIXELS(pos.x) - this.getBorderWidth();
            int y = offset_y[0] + OS.PANGO_PIXELS(pos.y);
            return new Point(x, y);
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_iter_location(this.handle, position, rect);
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_text_view_buffer_to_window_coords(this.handle, 2, rect.x, rect.y, x, y);
        return new Point(x[0], y[0]);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_position(this.handle);
        }
        byte[] position = new byte[ITER_SIZEOF];
        int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_buffer_get_iter_at_mark(this.bufferHandle, position, mark);
        return OS.gtk_text_iter_get_offset(position);
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            return OS.g_utf8_strlen(ptr, -1);
        }
        return OS.gtk_text_buffer_get_char_count(this.bufferHandle);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        if ((this.style & 4) != 0 && !OS.gtk_entry_get_visibility(this.handle)) {
            return OS.gtk_entry_get_invisible_char(this.handle);
        }
        return '\u0000';
    }

    public boolean getEditable() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.gtk_editable_get_editable(this.handle);
        }
        return OS.gtk_text_view_get_editable(this.handle);
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        return OS.gtk_text_buffer_get_line_count(this.bufferHandle);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return "\n";
    }

    public int getLineHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, start, end);
            return new Point(start[0], end[0]);
        }
        byte[] start = new byte[ITER_SIZEOF];
        byte[] end = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, start, end);
        return new Point(OS.gtk_text_iter_get_offset(start), OS.gtk_text_iter_get_offset(end));
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point selection = this.getSelection();
        return Math.abs(selection.y - selection.x);
    }

    public String getSelectionText() {
        this.checkWidget();
        Point selection = this.getSelection();
        return this.getText().substring(selection.x, selection.y);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int tabs) {
        byte[] buffer = Converter.wcsToMbcs(null, " ", true);
        int layout = OS.gtk_widget_create_pango_layout(this.handle, buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_size(layout, width, height);
        OS.g_object_unref(layout);
        return width[0] * tabs;
    }

    public String getText() {
        int address;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            address = OS.gtk_entry_get_text(this.handle);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_bounds(this.bufferHandle, start, end);
            address = OS.gtk_text_buffer_get_text(this.bufferHandle, start, end, true);
        }
        if (address == 0) {
            return "";
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        if ((this.style & 2) != 0) {
            OS.g_free(address);
        }
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public String getText(int start, int end) {
        int length;
        int address;
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        start = Math.max(0, start);
        if ((this.style & 4) != 0) {
            address = OS.gtk_editable_get_chars(this.handle, start, end + 1);
        } else {
            length = OS.gtk_text_buffer_get_char_count(this.bufferHandle);
            end = Math.min(end, length - 1);
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, startIter, start);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, endIter, end + 1);
            address = OS.gtk_text_buffer_get_text(this.bufferHandle, startIter, endIter, true);
        }
        if (address == 0) {
            this.error(12);
        }
        length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        OS.g_free(address);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    public int getTextLimit() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return LIMIT;
        }
        int limit = OS.gtk_entry_get_max_length(this.handle);
        return limit == 0 ? 65535 : limit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, rect);
        OS.gtk_text_view_get_line_at_y(this.handle, position, rect.y, null);
        return OS.gtk_text_iter_get_line(position);
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        GdkRectangle rect = new GdkRectangle();
        OS.gtk_text_view_get_visible_rect(this.handle, rect);
        int[] lineTop = new int[1];
        OS.gtk_text_view_get_line_at_y(this.handle, position, rect.y, lineTop);
        return lineTop[0];
    }

    int gtk_activate(int widget) {
        this.postEvent(14);
        return 0;
    }

    int gtk_button_press_event(int widget, int event) {
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if (!this.doubleClick) {
            switch (gdkEvent.type) {
                case 5: 
                case 6: {
                    return 1;
                }
            }
        }
        return result;
    }

    int gtk_button_release_event(int widget, int event) {
        if (this.display.dragOverride && !this.display.dragging) {
            int offset;
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
            int x = (int)gdkEvent.x;
            int y = (int)gdkEvent.y;
            if ((this.style & 4) != 0) {
                int layout = OS.gtk_entry_get_layout(this.handle);
                int[] index = new int[1];
                int[] trailing = new int[1];
                OS.pango_layout_xy_to_index(layout, x * 1024, y * 1024, index, trailing);
                int ptr = OS.pango_layout_get_text(layout);
                offset = OS.g_utf8_pointer_to_offset(ptr, ptr + index[0]);
            } else {
                byte[] position = new byte[ITER_SIZEOF];
                OS.gtk_text_view_get_iter_at_location(this.handle, position, x, y);
                offset = OS.gtk_text_iter_get_offset(position);
            }
            if ((this.style & 4) != 0) {
                OS.gtk_editable_set_position(this.handle, offset);
            } else {
                byte[] position = new byte[ITER_SIZEOF];
                OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, position, offset);
                OS.gtk_text_buffer_place_cursor(this.bufferHandle, position);
                int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
                OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    int gtk_changed(int widget) {
        boolean keyPress = false;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    keyPress = true;
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    int gtk_commit(int imContext, int text) {
        if (text == 0) {
            return 0;
        }
        if ((this.style & 4) != 0 && !OS.gtk_editable_get_editable(this.handle)) {
            return 0;
        }
        int length = OS.strlen(text);
        if (length == 0) {
            return 0;
        }
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, length);
        char[] chars = Converter.mbcsToWcs(null, buffer);
        char[] newChars = this.sendIMKeyEvent(1, null, chars);
        if (newChars == null) {
            return 0;
        }
        if ((this.style & 4) != 0) {
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0, 0, 9);
        int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0, 0, this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(null, newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.handle);
        if ((this.style & 4) != 0) {
            if (this.fixStart != -1 && this.fixEnd != -1) {
                OS.gtk_editable_set_position(this.handle, this.fixStart);
                OS.gtk_editable_select_region(this.handle, this.fixStart, this.fixEnd);
            }
            this.fixEnd = -1;
            this.fixStart = -1;
        }
        return 0;
    }

    int gtk_delete_range(int widget, int iter1, int iter2) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] startIter = new byte[ITER_SIZEOF];
        byte[] endIter = new byte[ITER_SIZEOF];
        OS.memmove(startIter, iter1, startIter.length);
        OS.memmove(endIter, iter2, endIter.length);
        int start = OS.gtk_text_iter_get_offset(startIter);
        int end = OS.gtk_text_iter_get_offset(endIter);
        String newText = this.verifyText("", start, end);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        } else if (newText.length() > 0) {
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.gtk_text_buffer_delete(this.bufferHandle, startIter, endIter);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 51);
            OS.gtk_text_buffer_insert(this.bufferHandle, startIter, buffer, buffer.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 51);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.delete_range);
        }
        return 0;
    }

    int gtk_delete_text(int widget, int start_pos, int end_pos) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String newText = this.verifyText("", start_pos, end_pos);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{end_pos};
            byte[] buffer = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.handle, pos[0]);
        }
        return 0;
    }

    int gtk_event_after(int widget, int gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            GdkEvent event = new GdkEvent();
            OS.memmove(event, gdkEvent, GdkEvent.sizeof);
            switch (event.type) {
                case 12: {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    OS.memmove(gdkEventFocus, gdkEvent, GdkEventFocus.sizeof);
                    if (gdkEventFocus.in != 0) break;
                    int settings = OS.gtk_settings_get_default();
                    OS.g_object_set(settings, OS.gtk_entry_select_on_focus, true, 0);
                }
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    int gtk_focus_out_event(int widget, int event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    int gtk_grab_focus(int widget) {
        int result = super.gtk_grab_focus(widget);
        if ((this.style & 4) != 0 && this.display.entrySelectOnFocus) {
            int settings = OS.gtk_settings_get_default();
            OS.g_object_set(settings, OS.gtk_entry_select_on_focus, false, 0);
        }
        return result;
    }

    int gtk_insert_text(int widget, int new_text, int new_text_length, int position) {
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (new_text == 0 || new_text_length == 0) {
            return 0;
        }
        byte[] buffer = new byte[new_text_length];
        OS.memmove(buffer, new_text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        int[] pos = new int[1];
        OS.memmove(pos, position, 4);
        if (pos[0] == -1) {
            int ptr = OS.gtk_entry_get_text(this.handle);
            pos[0] = OS.g_utf8_strlen(ptr, -1);
        }
        if ((newText = this.verifyText(oldText, pos[0], pos[0])) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                }
                byte[] buffer3 = Converter.wcsToMbcs(null, newText, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.handle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
                newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0] && newEnd[0] != pos[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            OS.memmove(position, pos, 4);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int widget, int event) {
        int result = super.gtk_key_press_event(widget, event);
        if (result != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            result = 1;
        }
        this.gdkEventKey = 0;
        return result;
    }

    int gtk_popup_menu(int widget) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer(0, x, y, null);
        return this.showMenu(x[0], y[0]) ? 1 : 0;
    }

    int gtk_text_buffer_insert_text(int widget, int iter, int text, int length) {
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        byte[] position = new byte[ITER_SIZEOF];
        OS.memmove(position, iter, position.length);
        int start = OS.gtk_text_iter_get_offset(position);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, text, buffer.length);
        String oldText = new String(Converter.mbcsToWcs(null, buffer));
        String newText = this.verifyText(oldText, start, start);
        if (newText == null) {
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        } else if (newText != oldText) {
            byte[] buffer1 = Converter.wcsToMbcs(null, newText, false);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 51);
            OS.gtk_text_buffer_insert(this.bufferHandle, iter, buffer1, buffer1.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 51);
            OS.g_signal_stop_emission_by_name(this.bufferHandle, OS.insert_text);
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 4) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
            OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.closures[26], false);
            OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.closures[13], false);
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
            OS.g_signal_connect_closure(this.handle, OS.grab_focus, this.display.closures[23], false);
        } else {
            OS.g_signal_connect_closure(this.bufferHandle, OS.changed, this.display.closures[6], false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.insert_text, this.display.closures[51], false);
            OS.g_signal_connect_closure(this.bufferHandle, OS.delete_range, this.display.closures[12], false);
        }
        int imContext = this.imContext();
        if (imContext != 0) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.closures[9], false);
            int id = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0, 0, this.handle);
        }
    }

    int imContext() {
        return (this.style & 4) != 0 ? OS.GTK_ENTRY_IM_CONTEXT(this.handle) : OS.GTK_TEXTVIEW_IM_CONTEXT(this.handle);
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, false);
        if ((this.style & 4) != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            OS.gtk_editable_get_selection_bounds(this.handle, start, end);
            OS.gtk_editable_delete_selection(this.handle);
            OS.gtk_editable_insert_text(this.handle, buffer, buffer.length, start);
            OS.gtk_editable_set_position(this.handle, start[0]);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            if (OS.gtk_text_buffer_get_selection_bounds(this.bufferHandle, start, end)) {
                OS.gtk_text_buffer_delete(this.bufferHandle, start, end);
            }
            OS.gtk_text_buffer_insert(this.bufferHandle, start, buffer, buffer.length);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, start);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
    }

    int paintWindow() {
        if ((this.style & 4) != 0) {
            int window = super.paintWindow();
            int children = OS.gdk_window_get_children(window);
            if (children != 0) {
                window = OS.g_list_data(children);
            }
            OS.g_list_free(children);
            return window;
        }
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_text_view_get_window(this.handle, 2);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_paste_clipboard(this.handle);
        } else {
            int clipboard = OS.gtk_clipboard_get(0);
            OS.gtk_text_buffer_paste_clipboard(this.bufferHandle, clipboard, null, OS.gtk_text_view_get_editable(this.handle));
        }
    }

    void register() {
        int imContext;
        super.register();
        if (this.bufferHandle != 0) {
            this.display.addWidget(this.bufferHandle, this);
        }
        if ((imContext = this.imContext()) != 0) {
            this.display.addWidget(imContext, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && (this.style & 2) != 0) {
            int clipboard = OS.gtk_clipboard_get(0);
            OS.gtk_text_buffer_paste_clipboard(this.bufferHandle, clipboard, null, OS.gtk_text_view_get_editable(this.handle));
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_select_region(this.handle, 0, -1);
        } else {
            byte[] start = new byte[ITER_SIZEOF];
            byte[] end = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, start, 0);
            OS.gtk_text_buffer_get_end_iter(this.bufferHandle, end);
            int insertMark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, selectionMark, start);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, insertMark, end);
        }
    }

    void setBackgroundColor(GdkColor color) {
        super.setBackgroundColor(color);
        OS.gtk_widget_modify_base(this.handle, 0, color);
    }

    void setCursor(int cursor) {
        int defaultCursor = 0;
        if (cursor == 0) {
            defaultCursor = OS.gdk_cursor_new(152);
        }
        super.setCursor(cursor != 0 ? cursor : defaultCursor);
        if (cursor == 0) {
            OS.gdk_cursor_destroy(defaultCursor);
        }
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_visibility(this.handle, echo == '\u0000');
            OS.gtk_entry_set_invisible_char(this.handle, echo);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!editable) {
            this.style |= 8;
        }
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_editable(this.handle, editable);
        } else {
            OS.gtk_text_view_set_editable(this.handle, editable);
        }
    }

    void setFontDescription(int font) {
        super.setFontDescription(font);
        this.setTabStops(this.tabs);
    }

    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        OS.gtk_widget_modify_text(this.handle, 0, color);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(int start) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_position(this.handle, start);
        } else {
            byte[] position = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, position, start);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.gtk_editable_set_position(this.handle, start);
            OS.gtk_editable_select_region(this.handle, start, end);
        } else {
            byte[] startIter = new byte[ITER_SIZEOF];
            byte[] endIter = new byte[ITER_SIZEOF];
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, startIter, start);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, endIter, end);
            int insertMark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            int selectionMark = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, selectionMark, startIter);
            OS.gtk_text_buffer_move_mark(this.bufferHandle, insertMark, endIter);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (tabs < 0) {
            return;
        }
        this.tabs = tabs;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int tabs) {
        if ((this.style & 4) != 0) {
            return;
        }
        int tabWidth = this.getTabWidth(tabs);
        int tabArray = OS.pango_tab_array_new(1, false);
        OS.pango_tab_array_set_tab(tabArray, 0, 0, tabWidth);
        OS.gtk_text_view_set_tabs(this.handle, tabArray);
        OS.pango_tab_array_free(tabArray);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount())) == null) {
            return;
        }
        if ((this.style & 4) != 0) {
            byte[] buffer = Converter.wcsToMbcs(null, string, true);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 13);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 26);
            OS.gtk_entry_set_text(this.handle, buffer);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 13);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 26);
        } else {
            byte[] buffer = Converter.wcsToMbcs(null, string, false);
            byte[] position = new byte[ITER_SIZEOF];
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_block_matched(this.bufferHandle, 16, 0, 0, 0, 0, 51);
            OS.gtk_text_buffer_set_text(this.bufferHandle, buffer, buffer.length);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 12);
            OS.g_signal_handlers_unblock_matched(this.bufferHandle, 16, 0, 0, 0, 0, 51);
            OS.gtk_text_buffer_get_iter_at_offset(this.bufferHandle, position, 0);
            OS.gtk_text_buffer_place_cursor(this.bufferHandle, position);
            int mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
            OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        }
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        if ((this.style & 4) != 0) {
            OS.gtk_entry_set_max_length(this.handle, limit);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        byte[] position = new byte[ITER_SIZEOF];
        OS.gtk_text_buffer_get_iter_at_line(this.bufferHandle, position, index);
        OS.gtk_text_view_scroll_to_iter(this.handle, position, 0.0, true, 0.0, 0.0);
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int mark = OS.gtk_text_buffer_get_selection_bound(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
        mark = OS.gtk_text_buffer_get_insert(this.bufferHandle);
        OS.gtk_text_view_scroll_mark_onscreen(this.handle, mark);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        int key = keyEvent.keyval;
        switch (key) {
            case 65293: 
            case 65421: {
                int imContext = this.imContext();
                if (imContext == 0) break;
                int[] preeditString = new int[1];
                OS.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0) break;
                int length = OS.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(keyEvent);
    }

    int traversalCode(int key, GdkEventKey event) {
        int bits = super.traversalCode(key, event);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 65289 && event != null) {
                boolean next;
                boolean bl = next = (event.state & 1) == 0;
                if (next && (event.state & 4) == 0) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    String verifyText(String string, int start, int end) {
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        int eventPtr = OS.gtk_get_current_event();
        if (eventPtr != 0) {
            GdkEventKey gdkEvent = new GdkEventKey();
            OS.memmove(gdkEvent, eventPtr, GdkEventKey.sizeof);
            switch (gdkEvent.type) {
                case 8: {
                    this.setKeyState(event, gdkEvent);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

