/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.PocketExcelConstants;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.ColourConverter;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class FontDescription
implements BIFFRecord {
    private byte[] dwHeight = new byte[2];
    private byte[] grbit = new byte[2];
    private byte[] icvFore = new byte[2];
    private byte[] bls = new byte[2];
    private byte[] Reserved2 = new byte[2];
    private byte uls;
    private byte bFamily;
    private byte bCharSet;
    private byte Reserved3;
    private byte cch;
    private byte[] rgch;
    public static final int UNDERLINE = 1;
    public static final int ITALIC = 2;

    public FontDescription(Format format) throws IOException {
        Debug.log((int)4, (String)("Building FontDescriptor based on Format : " + format));
        this.dwHeight = EndianConverter.writeShort((short)((short)(format.getFontSize() * 20)));
        this.grbit = new byte[]{0, 0};
        this.bls = EndianConverter.writeShort((short)400);
        this.uls = 0;
        if (format.getAttribute(2)) {
            this.grbit[0] = (byte)(this.grbit[0] | 2);
        }
        if (format.getAttribute(1)) {
            this.bls = EndianConverter.writeShort((short)700);
        }
        if (format.getAttribute(4)) {
            this.uls = (byte)(this.uls | 1);
        }
        this.bFamily = 0;
        this.bCharSet = 0;
        String string = format.getFontName();
        if (!string.equals("Tahoma") && !string.equals("Courier New")) {
            string = new String("Tahoma");
        }
        this.cch = (byte)string.length();
        this.rgch = string.getBytes("UTF-16LE");
        Color color = format.getForeground();
        if (color != null) {
            ColourConverter colourConverter = new ColourConverter(PocketExcelConstants.cLookup);
            this.icvFore = EndianConverter.writeShort((short)colourConverter.convertFromRGB(color));
        } else {
            this.icvFore = new byte[]{-1, 0};
        }
        this.Reserved2 = EndianConverter.writeShort((short)0);
        this.Reserved3 = 0;
    }

    public boolean isItalic() {
        return EndianConverter.readShort((byte[])this.grbit) == 2;
    }

    public boolean isUnderline() {
        return this.uls == 1;
    }

    public boolean isBold() {
        return EndianConverter.readShort((byte[])this.bls) == 700;
    }

    public Color getForeground() {
        short s = EndianConverter.readShort((byte[])this.icvFore);
        Color color = null;
        if (s != 255) {
            ColourConverter colourConverter = new ColourConverter(PocketExcelConstants.cLookup);
            color = colourConverter.convertToRGB(s);
        }
        return color;
    }

    public boolean compareTo(FontDescription fontDescription) {
        if (EndianConverter.readShort((byte[])this.icvFore) != EndianConverter.readShort((byte[])fontDescription.icvFore)) {
            return false;
        }
        if (EndianConverter.readShort((byte[])this.dwHeight) != EndianConverter.readShort((byte[])this.dwHeight)) {
            return false;
        }
        if (this.getFont() != fontDescription.getFont()) {
            return false;
        }
        if (this.isBold() != fontDescription.isBold()) {
            return false;
        }
        if (this.isUnderline() != fontDescription.isUnderline()) {
            return false;
        }
        return this.isItalic() == fontDescription.isItalic();
    }

    public FontDescription(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 49;
    }

    public int getFontSize() {
        return EndianConverter.readShort((byte[])this.dwHeight) / 20;
    }

    public String getFont() {
        String string;
        try {
            string = new String(this.rgch, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "Tahoma";
        }
        return string;
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.dwHeight);
        n += inputStream.read(this.grbit);
        n += inputStream.read(this.icvFore);
        n += inputStream.read(this.bls);
        n += inputStream.read(this.Reserved2);
        this.uls = (byte)inputStream.read();
        this.bFamily = (byte)inputStream.read();
        this.bCharSet = (byte)inputStream.read();
        this.Reserved3 = (byte)inputStream.read();
        this.cch = (byte)inputStream.read();
        this.rgch = new byte[this.cch * 2];
        inputStream.read(this.rgch, 0, this.cch * 2);
        Debug.log((int)4, (String)("\tdwHeight : " + EndianConverter.readShort((byte[])this.dwHeight) + " grbit : " + EndianConverter.readShort((byte[])this.grbit) + " bls : " + EndianConverter.readShort((byte[])this.bls) + " uls : " + this.uls + "\n\tFamily : " + this.bFamily + " bCharSet : " + this.bCharSet + " cch : " + this.cch + " rgch : " + new String(this.rgch, "UTF-16LE")));
        return n += 5;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.dwHeight);
        outputStream.write(this.grbit);
        outputStream.write(this.icvFore);
        outputStream.write(this.bls);
        outputStream.write(this.Reserved2);
        outputStream.write(this.uls);
        outputStream.write(this.bFamily);
        outputStream.write(this.bCharSet);
        outputStream.write(this.Reserved3);
        outputStream.write(this.cch);
        outputStream.write(this.rgch);
        Debug.log((int)4, (String)"Writing FontDescription record");
    }
}

