/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.Size;
import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XLayoutConstrains;
import com.sun.star.awt.XTextListener;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.deployment.XPackageInformationProvider;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.logging.XLogger;
import com.sun.star.logging.XLoggerPool;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.InvalidQueryException;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.report.Dataimport;
import com.sun.star.wizards.report.GroupFieldHandler;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportFinalizer;
import com.sun.star.wizards.report.ReportLayouter;
import com.sun.star.wizards.report.ReportTextImplementation;
import com.sun.star.wizards.ui.CommandFieldSelection;
import com.sun.star.wizards.ui.FieldSelection;
import com.sun.star.wizards.ui.SortingComponent;
import com.sun.star.wizards.ui.TitlesComponent;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import com.sun.star.wizards.ui.XCompletion;
import com.sun.star.wizards.ui.XFieldSelectionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;

public class ReportWizard
extends WizardDialog
implements XTextListener,
XCompletion {
    FieldSelection CurGroupFieldSelection;
    SortingComponent CurSortingComponent;
    UnoDialog CurUnoProgressDialog;
    TitlesComponent CurTitlesComponent;
    CommandFieldSelection CurDBCommandFieldSelection;
    GroupFieldHandler CurGroupFieldHandler;
    ReportLayouter CurReportLayouter;
    ReportFinalizer CurReportFinalizer;
    PropertyValue[] DBGPROPERTYVALUE;
    String sCommandName = "";
    int nCommandType = -1;
    int nReportMode = 1;
    private String m_sReportName = "";
    public static final String SOREPORTFORMNAME = "ReportSource";
    final int SOSELGROUPLST = 33;
    final int SOTXTCOLTITLE = 48;
    final int SOTITLESCROLLBAR = 49;
    public static final int SONULLPAGE = 0;
    public static final int SOMAINPAGE = 1;
    public static final int SOTITLEPAGE = 2;
    public static final int SOGROUPPAGE = 3;
    public static final int SOSORTPAGE = 4;
    public static final int SOTEMPLATEPAGE = 5;
    public static final int SOSTOREPAGE = 6;
    IReportDocument CurReportDocument;
    static String sMsgWizardName;
    static String slblFields;
    static String slblSelFields;
    static String sShowBinaryFields;
    static String sGroupings;
    String[] WizardHeaderText = new String[6];
    static String[] WizardTitle;
    static String sWriterFilterName;
    static String slstDatabasesDefaultText;
    static String slstTablesDefaultText;
    static String sMsgErrorOccured;
    static String sMsgSavingImpossible;
    static String sMsgNoConnection;
    static String slblColumnTitles;
    static String slblColumnNames;
    static String sMsgNoConnectionforDataimport;
    static String sMsgQueryCreationImpossible;
    public static String sMsgFilePathInvalid;
    static String slblTables;
    public static boolean bCloseDocument;
    public boolean bHasEscapeProcessing = true;
    private static XLogger m_xLogger;

    public ReportWizard(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory, 34320);
        super.addResourceHandler("Report Wizard", "dbw");
        if (this.getReportResources(false)) {
            Helper.setUnoPropertyValues(this.xDialogModel, new String[]{"Height", "Moveable", "Name", "PositionX", "PositionY", "Step", "TabIndex", "Title", "Width"}, new Object[]{new Integer(210), Boolean.TRUE, "DialogReport", new Integer(102), new Integer(41), new Integer(1), new Short(0), sMsgWizardName, new Integer(310)});
            this.drawNaviBar();
            this.setRightPaneHeaders(this.WizardHeaderText);
        }
    }

    protected void enterStep(int n, int n2) {
        if (n >= 5 && n2 < 5) {
            this.CurReportDocument.removeTextTableAndTextSection();
        }
        switch (n2) {
            case 1: {
                this.CurDBCommandFieldSelection.setModified(false);
                break;
            }
            case 2: {
                String[] stringArray = this.CurReportDocument.getRecordParser().getFieldNames();
                Map map = this.CurReportDocument.getRecordParser().getFieldTitleSet();
                this.CurTitlesComponent.initialize(stringArray, map);
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.initialize();
                break;
            }
            case 4: {
                String[] stringArray = this.CurReportDocument.getRecordParser().getFieldNames();
                String[][] stringArray2 = this.CurReportDocument.getRecordParser().getSortFieldNames();
                this.CurSortingComponent.initialize(stringArray, stringArray2);
                int n3 = this.CurReportDocument.getRecordParser().GroupFieldNames.length;
                this.CurSortingComponent.setReadOnlyUntil(n3, false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.CurReportFinalizer.initialize(this.CurReportDocument.getRecordParser());
                break;
            }
        }
    }

    protected void leaveStep(int n, int n2) {
        switch (n) {
            case 1: {
                String[] stringArray = this.CurDBCommandFieldSelection.getSelectedFieldNames();
                String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
                int n3 = this.CurDBCommandFieldSelection.getSelectedCommandType();
                this.CurReportDocument.initializeFieldColumns(n3, string, stringArray);
                if (!this.CurDBCommandFieldSelection.isModified()) break;
                this.CurReportDocument.clearDocument();
                this.CurReportDocument.getRecordParser().setGroupFieldNames(new String[0]);
                this.CurGroupFieldHandler.removeGroupFieldNames();
                break;
            }
            case 2: {
                String[] stringArray = this.CurTitlesComponent.getFieldTitles();
                this.CurReportDocument.setFieldTitles(stringArray);
                break;
            }
            case 3: {
                this.CurGroupFieldHandler.getGroupFieldNames(this.CurReportDocument.getRecordParser());
                String[] stringArray = this.CurReportDocument.getRecordParser().GroupFieldNames;
                this.CurReportDocument.setGrouping(stringArray);
                break;
            }
            case 4: {
                String[][] stringArray = this.CurSortingComponent.getSortFieldNames();
                this.CurReportDocument.setSorting(stringArray);
                super.enablefromStep(5, true);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
        if (n < 5 && super.getNewStep() >= 5) {
            this.CurReportDocument.getRecordParser().createRecordFieldNames();
            this.CurReportLayouter.initialize(this.CurReportDocument.getContentPath());
        }
    }

    private XComponent[] dialogFinish(short s) {
        XComponent[] xComponentArray = null;
        boolean bl = true;
        switch (s) {
            case 0: {
                this.xComponent.dispose();
                if (bCloseDocument) {
                    this.CurReportDocument.dispose();
                    return xComponentArray;
                }
                if (this.nReportMode == 2 || this.nReportMode == 3) {
                    bl = false;
                    this.CurReportDocument.addReportToDBView();
                    boolean bl2 = this.nReportMode == 2;
                    xComponentArray = this.CurReportDocument.createFinalReportDocument(this.m_sReportName, true, bl2);
                } else {
                    bl = false;
                    this.CurReportDocument.importReportData(this);
                    xComponentArray = this.CurReportDocument.createFinalReportDocument(this.m_sReportName, false, false);
                }
                return xComponentArray;
            }
            case 1: {
                if (!bl) break;
            }
        }
        return null;
    }

    private boolean executeQuery() {
        boolean bl = false;
        if (this.CurDBCommandFieldSelection.getSelectedCommandType() == 0) {
            bl = this.CurReportDocument.getRecordParser().oSQLQueryComposer.setQueryCommand(sMsgWizardName, this.xWindow, false, false);
            this.CurReportDocument.setCommandType(2);
            String string = this.CurReportDocument.getRecordParser().oSQLQueryComposer.getQuery();
            this.CurReportDocument.setCommand(string);
        } else {
            try {
                String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
                DBMetaData.CommandObject commandObject = this.CurReportDocument.getRecordParser().getQueryByName(string);
                this.bHasEscapeProcessing = this.CurReportDocument.getRecordParser().hasEscapeProcessing(commandObject.xPropertySet);
                String string2 = (String)commandObject.xPropertySet.getPropertyValue("Command");
                if (this.bHasEscapeProcessing) {
                    bl = !string2.equals("");
                    this.CurReportDocument.getRecordParser().oSQLQueryComposer.m_xQueryAnalyzer.setQuery(string2);
                    this.CurReportDocument.getRecordParser().oSQLQueryComposer.prependSortingCriteria();
                    this.CurReportDocument.setCommandType(2);
                    this.CurReportDocument.setCommand(this.CurReportDocument.getRecordParser().oSQLQueryComposer.getQuery());
                    bl = true;
                } else {
                    this.CurReportDocument.setCommandType(2);
                    this.CurReportDocument.setCommand(string2);
                    bl = true;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        if (!bl) {
            super.vetoableChange(null);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "uno:socket,host=localhost,port=8107;urp;StarOffice.NamingService";
        try {
            XMultiServiceFactory xMultiServiceFactory = Desktop.connect(string);
            ReportWizard.tests(xMultiServiceFactory);
            ReportWizard reportWizard = new ReportWizard(xMultiServiceFactory);
            if (xMultiServiceFactory != null) {
                System.out.println("Connected to " + string);
                PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("DataSourceName", "RptWizard01_DB")};
                reportWizard.startReportWizard(xMultiServiceFactory, propertyValueArray, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        System.exit(1);
    }

    private static void tests(XMultiServiceFactory xMultiServiceFactory) {
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlContainer");
            Object object2 = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedTextModel");
            XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)object2);
            Object object3 = xMultiServiceFactory.createInstance("com.sun.star.awt.UnoControlFixedText");
            XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)object3);
            String[] stringArray = xServiceInfo.getSupportedServiceNames();
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)object3);
            xWindow.setVisible(true);
            XFixedText xFixedText = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)object3);
            xFixedText.setText("Dies ist ein String");
            XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)xFixedText);
            xControl.setModel(xControlModel);
            XLayoutConstrains xLayoutConstrains = (XLayoutConstrains)UnoRuntime.queryInterface(XLayoutConstrains.class, (Object)object3);
            Size size = xLayoutConstrains.getPreferredSize();
            boolean bl = false;
        }
        catch (Exception exception) {
            boolean bl = false;
        }
    }

    public void buildSteps() {
        this.CurDBCommandFieldSelection = new CommandFieldSelection(this, this.CurReportDocument.getRecordParser(), 100, slblFields, slblSelFields, slblTables, true, 34330);
        this.CurDBCommandFieldSelection.addFieldSelectionListener(new FieldSelectionListener());
        this.insertLabel("lblBinaryFields", new String[]{"Height", "Label", "PositionX", "PositionY", "Step", "Width"}, new Object[]{new Integer(16), sShowBinaryFields, new Integer(95), new Integer(162), new Integer(1), new Integer(210)});
        this.CurTitlesComponent = new TitlesComponent((WizardDialog)this, 2, 97, 37, 210, 7, slblColumnNames, slblColumnTitles, 34381);
        this.CurTitlesComponent.addTextListener(this);
        this.CurGroupFieldHandler = new GroupFieldHandler(this.CurReportDocument, this);
        this.CurSortingComponent = new SortingComponent(this, 4, 95, 30, 210, 34346);
        this.CurReportLayouter = new ReportLayouter(this.xMSF, this.CurReportDocument, this);
        this.CurReportFinalizer = new ReportFinalizer(this.xMSF, this.CurReportDocument, this);
        bCloseDocument = true;
        this.enableNavigationButtons(false, false, false);
    }

    public void finishWizard() {
        int n = this.getCurrentStep();
        if ((this.switchToStep(n, 6) || n == 6) && this.executeQuery() && this.CurReportFinalizer.finish()) {
            this.nReportMode = this.CurReportFinalizer.getReportOpenMode();
            this.m_sReportName = this.CurReportFinalizer.getStoreName();
            this.xDialog.endExecute();
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    public void insertQueryRelatedSteps() {
        this.setRMItemLabels(this.m_oResource, 2380);
        this.addRoadmap();
        int n = 0;
        n = this.insertRoadmapItem(0, true, this.m_oResource.getResText(2380), 1);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText(2468), 2);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText(2411), 3);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText(2412), 4);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText(2413), 5);
        n = this.insertRoadmapItem(n, false, this.m_oResource.getResText(2414), 6);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    private boolean isReportBuilderInstalled() {
        XContentEnumerationAccess xContentEnumerationAccess = (XContentEnumerationAccess)UnoRuntime.queryInterface(XContentEnumerationAccess.class, (Object)this.xMSF);
        XEnumeration xEnumeration = xContentEnumerationAccess.createContentEnumeration("com.sun.star.report.pentaho.SOReportJobFactory");
        if (xEnumeration == null) {
            return false;
        }
        return xEnumeration.hasMoreElements();
    }

    public static String getPathToExtension(XMultiServiceFactory xMultiServiceFactory) {
        XComponentContext xComponentContext = Helper.getComponentContext(xMultiServiceFactory);
        Object object = xComponentContext.getValueByName("/singletons/com.sun.star.deployment.PackageInformationProvider");
        XPackageInformationProvider xPackageInformationProvider = (XPackageInformationProvider)UnoRuntime.queryInterface(XPackageInformationProvider.class, (Object)object);
        String string = xPackageInformationProvider.getPackageLocation("com.sun.reportdesigner");
        return string;
    }

    private static void initializeLogger(XMultiServiceFactory xMultiServiceFactory) {
        XComponentContext xComponentContext = Helper.getComponentContext(xMultiServiceFactory);
        Object object = xComponentContext.getValueByName("/singletons/com.sun.star.logging.LoggerPool");
        if (object == null) {
            System.out.println("Can't get singleton from logging");
        }
        XLoggerPool xLoggerPool = (XLoggerPool)UnoRuntime.queryInterface(XLoggerPool.class, (Object)object);
        m_xLogger = xLoggerPool.getNamedLogger("com.sun.star.wizards.ReportBuilder");
    }

    public static XLogger getLogger() {
        return m_xLogger;
    }

    public XComponent[] startReportWizard(XMultiServiceFactory xMultiServiceFactory, PropertyValue[] propertyValueArray) {
        return this.startReportWizard(xMultiServiceFactory, propertyValueArray, false);
    }

    public XComponent[] startReportWizard(XMultiServiceFactory xMultiServiceFactory, PropertyValue[] propertyValueArray, boolean bl) {
        Object object;
        Object object2;
        ReportWizard.initializeLogger(xMultiServiceFactory);
        ReportWizard.getLogger().log(1000, "Start Report Wizard");
        XComponent[] xComponentArray = null;
        this.xMSF = xMultiServiceFactory;
        this.DBGPROPERTYVALUE = propertyValueArray;
        boolean bl2 = false;
        if (!this.isReportBuilderInstalled()) {
            bl2 = true;
        }
        if (bl && !bl2) {
            try {
                object2 = Class.forName("com.sun.star.wizards.reportbuilder.ReportBuilderImplementation");
                object = ((Class)object2).getMethod("create", XMultiServiceFactory.class, Resource.class);
                this.CurReportDocument = (IReportDocument)((Method)object).invoke(object2, this.xMSF, this.m_oResource);
            }
            catch (Exception exception) {
                boolean bl3 = false;
            }
        } else if (!bl2 && ((String)(object2 = ReportWizard.getPathToExtension(this.xMSF))).length() > 0) {
            try {
                URI uRI = URI.create((String)object2 + "/" + "reportbuilderwizard.jar");
                URL[] uRLArray = new URL[]{uRI.toURL()};
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
                Class<?> clazz = uRLClassLoader.loadClass("com.sun.star.wizards.reportbuilder.ReportBuilderImplementation");
                Method method = clazz.getMethod("create", XMultiServiceFactory.class, Resource.class);
                this.CurReportDocument = (IReportDocument)method.invoke(clazz, this.xMSF, this.m_oResource);
            }
            catch (Exception exception) {
                boolean bl4 = false;
                System.out.println("There could be a problem with the path '" + (String)object2 + "'");
            }
        }
        try {
            if (this.CurReportDocument == null) {
                this.CurReportDocument = ReportTextImplementation.create(this.xMSF, this.m_oResource);
            }
            if (this.CurReportDocument.getRecordParser().getConnection(propertyValueArray)) {
                this.CurReportDocument.getRecordParser().oSQLQueryComposer = new SQLQueryComposer(this.CurReportDocument.getRecordParser());
                this.buildSteps();
                this.CurReportDocument.checkInvariants();
                this.CurDBCommandFieldSelection.preselectCommand(propertyValueArray, false);
                this.createWindowPeer(this.CurReportDocument.getWizardParent());
                this.CurReportDocument.getRecordParser().setWindowPeer(this.xControl.getPeer());
                this.insertQueryRelatedSteps();
                short s = this.executeDialog(this.CurReportDocument.getFrame().getComponentWindow().getPosSize());
                xComponentArray = this.dialogFinish(s);
            }
            this.CurReportDocument.getRecordParser().dispose();
        }
        catch (IOException iOException) {
            object = iOException.getMessage();
            if (((String)object).equals("default.otr")) {
                object = this.m_oResource.getResText(2492);
            }
            SystemDialog.showMessageBox(this.xMSF, "ErrorBox", 0x400000, (String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return xComponentArray;
    }

    public void importReportData(XMultiServiceFactory xMultiServiceFactory, Dataimport dataimport) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            bl2 = !this.bHasEscapeProcessing ? this.CurReportDocument.getRecordParser().executeCommand(1) : this.CurReportDocument.getRecordParser().executeCommand(2);
            if (bl2) {
                bl2 = this.CurReportDocument.getRecordParser().getFields(this.CurReportDocument.getRecordParser().getFieldNames(), false);
            }
            if (bl2) {
                this.CurReportDocument.insertDatabaseDatatoReportDocument(xMultiServiceFactory);
            }
            if (this.CurReportFinalizer.getReportOpenMode() == 1) {
                bl = this.CurReportDocument.getRecordParser().storeDatabaseDocumentToTempPath(this.CurReportDocument.getComponent(), this.CurReportFinalizer.getStoreName());
            }
        }
        catch (InvalidQueryException invalidQueryException) {
            // empty catch block
        }
        dataimport.xComponent.dispose();
        if (bl) {
            this.CurReportDocument.getRecordParser().addReportDocument(this.CurReportDocument.getComponent(), false);
        }
        this.CurReportDocument.getRecordParser().dispose();
    }

    public boolean getReportResources(boolean bl) {
        sMsgWizardName = this.m_oResource.getResText(2400);
        if (!bl) {
            sShowBinaryFields = this.m_oResource.getResText(2460);
            slstDatabasesDefaultText = this.m_oResource.getResText(1037);
            slstTablesDefaultText = this.m_oResource.getResText(1038);
            sMsgErrorOccured = this.m_oResource.getResText(1006);
            slblTables = this.m_oResource.getResText(2206);
            slblFields = this.m_oResource.getResText(2212);
            slblSelFields = this.m_oResource.getResText(2409);
            this.WizardHeaderText[0] = this.m_oResource.getResText(2428);
            this.WizardHeaderText[1] = this.m_oResource.getResText(2469);
            this.WizardHeaderText[2] = this.m_oResource.getResText(2429);
            this.WizardHeaderText[3] = this.m_oResource.getResText(2430);
            this.WizardHeaderText[4] = this.m_oResource.getResText(2431);
            this.WizardHeaderText[5] = this.m_oResource.getResText(2432);
            sMsgSavingImpossible = this.m_oResource.getResText(1030);
        }
        sMsgFilePathInvalid = this.m_oResource.getResText(1036);
        slblColumnTitles = this.m_oResource.getResText(2470);
        slblColumnNames = this.m_oResource.getResText(2471);
        return true;
    }

    public static String getBlindTextNote(Object object, Resource resource) {
        String string = "";
        if (object instanceof ReportTextImplementation) {
            string = resource.getResText(2475);
            string = JavaTools.replaceSubString(string, String.valueOf('\r'), "<BR>");
        }
        return string;
    }

    public void enableRoadmapItems(boolean bl) {
        try {
            Object object = null;
            int n = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.xDialogModel, "Step"));
            boolean bl2 = false;
            for (int i = 0; i < this.getRMItemCount(); ++i) {
                object = this.xIndexContRoadmap.getByIndex(i);
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(object, "ID"));
                bl2 = n2 > n ? bl : true;
                Helper.setUnoPropertyValue(object, "Enabled", new Boolean(bl2));
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void enableWizardSteps(String[] stringArray) {
        boolean bl = stringArray.length > 0;
        this.setControlProperty("btnWizardNext", "Enabled", new Boolean(bl));
        this.setControlProperty("btnWizardFinish", "Enabled", new Boolean(bl));
        this.enableRoadmapItems(bl);
    }

    public void textChanged(TextEvent textEvent) {
        try {
            Object object = UnoDialog.getModel(textEvent.Source);
            String string = (String)Helper.getUnoPropertyValue(object, "Text");
            String string2 = this.CurTitlesComponent.getFieldNameByTitleControl(object);
            this.CurReportDocument.liveupdate_changeUserFieldContent(string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void disposing(EventObject eventObject) {
    }

    public void setmodified(int n, Object object, Object object2) {
        switch (n) {
            case 1: {
                break;
            }
        }
    }

    private void toggleSortingPage() {
        boolean bl;
        int n = this.CurDBCommandFieldSelection.getSelectedCommandType();
        boolean bl2 = bl = n == 0;
        if (!bl) {
            String string = this.CurDBCommandFieldSelection.getSelectedCommandName();
            DBMetaData.CommandObject commandObject = this.CurReportDocument.getRecordParser().getQueryByName(string);
            bl = this.CurReportDocument.getRecordParser().hasEscapeProcessing(commandObject.xPropertySet);
        }
        super.setStepEnabled(4, bl);
    }

    static {
        WizardTitle = new String[6];
    }

    public class FieldSelectionListener
    implements XFieldSelectionListener {
        protected int m_nID;

        public int getID() {
            return this.m_nID;
        }

        public void setID(String string) {
            this.m_nID = 1;
            if (string != null && !string.equals("") && !string.equals("_")) {
                String string2 = JavaTools.ArrayoutofString(string, "_")[1];
                this.m_nID = Integer.parseInt(string2);
            }
        }

        public void shiftFromLeftToRight(String[] stringArray, String[] stringArray2) {
            if (this.m_nID == 1) {
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
                ReportWizard.this.enableWizardSteps(stringArray2);
                ReportWizard.this.toggleSortingPage();
            } else {
                boolean bl = ReportWizard.this.CurGroupFieldSelection.getSelectedFieldNames().length > 0;
                Helper.setUnoPropertyValue(ReportWizard.this.getRoadmapItemByID(3), "Enabled", new Boolean(bl));
            }
        }

        public void shiftFromRightToLeft(String[] stringArray, String[] stringArray2) {
            if (this.m_nID == 1) {
                ReportWizard.this.enableWizardSteps(stringArray2);
                ReportWizard.this.CurDBCommandFieldSelection.setModified(true);
            } else {
                boolean bl = ReportWizard.this.CurGroupFieldSelection.getSelectedFieldNames().length > 0;
                Helper.setUnoPropertyValue(ReportWizard.this.getRoadmapItemByID(3), "Enabled", new Boolean(bl));
            }
        }

        public void moveItemDown(String string) {
        }

        public void moveItemUp(String string) {
        }
    }
}

