/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.extensions;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.tests.WasRun;

public class ExtensionTest
extends TestCase {
    public void testRunningErrorInTestSetup() {
        TestCase test = new TestCase("failure"){

            public void runTest() {
                1.fail();
            }
        };
        TestSetup wrapper = new TestSetup(test);
        TestResult result = new TestResult();
        wrapper.run(result);
        ExtensionTest.assertTrue(!result.wasSuccessful());
    }

    public void testRunningErrorsInTestSetup() {
        TestCase failure = new TestCase("failure"){

            public void runTest() {
                2.fail();
            }
        };
        TestCase error = new TestCase("error"){

            public void runTest() {
                throw new Error();
            }
        };
        TestSuite suite = new TestSuite();
        suite.addTest(failure);
        suite.addTest(error);
        TestSetup wrapper = new TestSetup(suite);
        TestResult result = new TestResult();
        wrapper.run(result);
        ExtensionTest.assertEquals(1, result.failureCount());
        ExtensionTest.assertEquals(1, result.errorCount());
    }

    public void testSetupErrorDontTearDown() {
        WasRun test = new WasRun();
        TornDown wrapper = new TornDown(test){

            public void setUp() {
                4.fail();
            }
        };
        TestResult result = new TestResult();
        wrapper.run(result);
        ExtensionTest.assertTrue(!wrapper.fTornDown);
    }

    public void testSetupErrorInTestSetup() {
        WasRun test = new WasRun();
        TestSetup wrapper = new TestSetup(test){

            public void setUp() {
                5.fail();
            }
        };
        TestResult result = new TestResult();
        wrapper.run(result);
        ExtensionTest.assertTrue(!test.fWasRun);
        ExtensionTest.assertTrue(!result.wasSuccessful());
    }

    static class TornDown
    extends TestSetup {
        boolean fTornDown = false;

        TornDown(Test test) {
            super(test);
        }

        protected void tearDown() {
            this.fTornDown = true;
        }
    }
}

