/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.FileOwnerAttributeViewImpl;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;

class UnixFileAttributeViews {
    UnixFileAttributeViews() {
    }

    static BasicFileAttributeView createBasicView(UnixPath unixPath, boolean bl) {
        return new Basic(unixPath, bl);
    }

    static PosixFileAttributeView createPosixView(UnixPath unixPath, boolean bl) {
        return new Posix(unixPath, bl);
    }

    static PosixFileAttributeView createUnixView(UnixPath unixPath, boolean bl) {
        return new Unix(unixPath, bl);
    }

    static FileOwnerAttributeView createOwnerView(UnixPath unixPath, boolean bl) {
        return new FileOwnerAttributeViewImpl(UnixFileAttributeViews.createPosixView(unixPath, bl));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Unix
    extends Posix {
        private static final String MODE_NAME = "mode";
        private static final String INO_NAME = "ino";
        private static final String DEV_NAME = "dev";
        private static final String RDEV_NAME = "rdev";
        private static final String UID_NAME = "uid";
        private static final String GID_NAME = "gid";
        private static final String CTIME_NAME = "ctime";

        Unix(UnixPath unixPath, boolean bl) {
            super(unixPath, bl);
        }

        @Override
        public String name() {
            return "unix";
        }

        @Override
        public Object getAttribute(String string) throws IOException {
            if (string.equals(MODE_NAME)) {
                return this.readAttributes().mode();
            }
            if (string.equals(INO_NAME)) {
                return this.readAttributes().ino();
            }
            if (string.equals(DEV_NAME)) {
                return this.readAttributes().dev();
            }
            if (string.equals(RDEV_NAME)) {
                return this.readAttributes().rdev();
            }
            if (string.equals(UID_NAME)) {
                return this.readAttributes().uid();
            }
            if (string.equals(GID_NAME)) {
                return this.readAttributes().gid();
            }
            if (string.equals(CTIME_NAME)) {
                return this.readAttributes().ctime();
            }
            return super.getAttribute(string);
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            if (string.equals(MODE_NAME)) {
                this.setMode((Integer)object);
                return;
            }
            if (string.equals(UID_NAME)) {
                this.setOwners((Integer)object, -1);
                return;
            }
            if (string.equals(GID_NAME)) {
                this.setOwners(-1, (Integer)object);
                return;
            }
            super.setAttribute(string, object);
        }

        @Override
        public Map<String, ?> readAttributes(String string, String[] stringArray) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(string, stringArray);
            UnixFileAttributes unixFileAttributes = this.readAttributes();
            this.addBasicAttributesToBuilder(unixFileAttributes, attributesBuilder);
            this.addPosixAttributesToBuilder(unixFileAttributes, attributesBuilder);
            if (attributesBuilder.match(MODE_NAME)) {
                attributesBuilder.add(MODE_NAME, unixFileAttributes.mode());
            }
            if (attributesBuilder.match(INO_NAME)) {
                attributesBuilder.add(INO_NAME, unixFileAttributes.ino());
            }
            if (attributesBuilder.match(DEV_NAME)) {
                attributesBuilder.add(DEV_NAME, unixFileAttributes.dev());
            }
            if (attributesBuilder.match(RDEV_NAME)) {
                attributesBuilder.add(RDEV_NAME, unixFileAttributes.rdev());
            }
            if (attributesBuilder.match(UID_NAME)) {
                attributesBuilder.add(UID_NAME, unixFileAttributes.uid());
            }
            if (attributesBuilder.match(GID_NAME)) {
                attributesBuilder.add(GID_NAME, unixFileAttributes.gid());
            }
            if (attributesBuilder.match(CTIME_NAME)) {
                attributesBuilder.add(CTIME_NAME, unixFileAttributes.ctime());
            }
            return attributesBuilder.unmodifiableMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Posix
    extends Basic
    implements PosixFileAttributeView {
        private static final String PERMISSIONS_NAME = "permissions";
        private static final String OWNER_NAME = "owner";
        private static final String GROUP_NAME = "group";

        Posix(UnixPath unixPath, boolean bl) {
            super(unixPath, bl);
        }

        final void checkReadExtended() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.file.checkRead();
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        final void checkWriteExtended() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.file.checkWrite();
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        @Override
        public String name() {
            return "posix";
        }

        @Override
        public Object getAttribute(String string) throws IOException {
            if (string.equals(PERMISSIONS_NAME)) {
                return this.readAttributes().permissions();
            }
            if (string.equals(OWNER_NAME)) {
                return this.readAttributes().owner();
            }
            if (string.equals(GROUP_NAME)) {
                return this.readAttributes().group();
            }
            return super.getAttribute(string);
        }

        @Override
        public void setAttribute(String string, Object object) throws IOException {
            if (string.equals(PERMISSIONS_NAME)) {
                this.setPermissions((Set)object);
                return;
            }
            if (string.equals(OWNER_NAME)) {
                this.setOwner((UserPrincipal)object);
                return;
            }
            if (string.equals(GROUP_NAME)) {
                this.setGroup((GroupPrincipal)object);
                return;
            }
            super.setAttribute(string, object);
        }

        final void addPosixAttributesToBuilder(PosixFileAttributes posixFileAttributes, AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder) {
            if (attributesBuilder.match(PERMISSIONS_NAME)) {
                attributesBuilder.add(PERMISSIONS_NAME, posixFileAttributes.permissions());
            }
            if (attributesBuilder.match(OWNER_NAME)) {
                attributesBuilder.add(OWNER_NAME, posixFileAttributes.owner());
            }
            if (attributesBuilder.match(GROUP_NAME)) {
                attributesBuilder.add(GROUP_NAME, posixFileAttributes.group());
            }
        }

        @Override
        public Map<String, ?> readAttributes(String string, String[] stringArray) throws IOException {
            AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(string, stringArray);
            UnixFileAttributes unixFileAttributes = this.readAttributes();
            this.addBasicAttributesToBuilder(unixFileAttributes, attributesBuilder);
            this.addPosixAttributesToBuilder(unixFileAttributes, attributesBuilder);
            return attributesBuilder.unmodifiableMap();
        }

        @Override
        public UnixFileAttributes readAttributes() throws IOException {
            this.checkReadExtended();
            try {
                return UnixFileAttributes.get(this.file, this.followLinks);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setMode(int n) throws IOException {
            block6: {
                this.checkWriteExtended();
                try {
                    if (this.followLinks) {
                        UnixNativeDispatcher.chmod(this.file, n);
                        break block6;
                    }
                    int n2 = this.file.openForAttributeAccess(false);
                    try {
                        UnixNativeDispatcher.fchmod(n2, n);
                    }
                    finally {
                        UnixNativeDispatcher.close(n2);
                    }
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
            }
        }

        final void setOwners(int n, int n2) throws IOException {
            this.checkWriteExtended();
            try {
                if (this.followLinks) {
                    UnixNativeDispatcher.chown(this.file, n, n2);
                } else {
                    UnixNativeDispatcher.lchown(this.file, n, n2);
                }
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
            }
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> set) throws IOException {
            this.setMode(UnixFileModeAttribute.toUnixMode(set));
        }

        @Override
        public void setOwner(UserPrincipal userPrincipal) throws IOException {
            if (userPrincipal == null) {
                throw new NullPointerException("'owner' is null");
            }
            if (!(userPrincipal instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            if (userPrincipal instanceof UnixUserPrincipals.Group) {
                throw new IOException("'owner' parameter can't be a group");
            }
            int n = ((UnixUserPrincipals.User)userPrincipal).uid();
            this.setOwners(n, -1);
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setGroup(GroupPrincipal groupPrincipal) throws IOException {
            if (groupPrincipal == null) {
                throw new NullPointerException("'owner' is null");
            }
            if (!(groupPrincipal instanceof UnixUserPrincipals.Group)) {
                throw new ProviderMismatchException();
            }
            int n = ((UnixUserPrincipals.Group)groupPrincipal).gid();
            this.setOwners(-1, n);
        }
    }

    static class Basic
    extends AbstractBasicFileAttributeView {
        protected final UnixPath file;
        protected final boolean followLinks;

        Basic(UnixPath unixPath, boolean bl) {
            this.file = unixPath;
            this.followLinks = bl;
        }

        public BasicFileAttributes readAttributes() throws IOException {
            this.file.checkRead();
            try {
                UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(this.file, this.followLinks);
                return unixFileAttributes.asBasicFileAttributes();
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTimes(Long l, Long l2, Long l3, TimeUnit timeUnit) throws IOException {
            if (l == null && l2 == null) {
                return;
            }
            this.file.checkWrite();
            int n = this.file.openForAttributeAccess(this.followLinks);
            try {
                long l4;
                long l5;
                UnixFileAttributes unixFileAttributes = null;
                if (l == null || l2 == null) {
                    try {
                        unixFileAttributes = UnixFileAttributes.get(n);
                    }
                    catch (UnixException unixException) {
                        unixException.rethrowAsIOException(this.file);
                    }
                }
                if (l == null) {
                    l5 = unixFileAttributes.lastModifiedTime();
                } else if (l >= 0L) {
                    l5 = TimeUnit.MILLISECONDS.convert(l, timeUnit);
                } else {
                    if (l != -1L) {
                        throw new IllegalArgumentException();
                    }
                    l5 = System.currentTimeMillis();
                }
                if (l2 == null) {
                    l4 = unixFileAttributes.lastAccessTime();
                } else if (l2 >= 0L) {
                    l4 = TimeUnit.MILLISECONDS.convert(l2, timeUnit);
                } else {
                    if (l2 != -1L) {
                        throw new IllegalArgumentException();
                    }
                    l4 = System.currentTimeMillis();
                }
                try {
                    UnixNativeDispatcher.futimes(n, l4, l5);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
            }
            finally {
                UnixNativeDispatcher.close(n);
            }
        }
    }
}

