/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.AsynchronousChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import sun.nio.ch.AbstractFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompletedFuture<V, A>
extends AbstractFuture<V, A> {
    private final V result;
    private final Throwable exc;

    private CompletedFuture(AsynchronousChannel asynchronousChannel, V v, Throwable throwable, A a) {
        super(asynchronousChannel, a);
        this.result = v;
        this.exc = throwable;
    }

    static <V, A> CompletedFuture<V, A> withResult(AsynchronousChannel asynchronousChannel, V v, A a) {
        return new CompletedFuture<V, A>(asynchronousChannel, v, null, a);
    }

    static <V, A> CompletedFuture<V, A> withFailure(AsynchronousChannel asynchronousChannel, Throwable throwable, A a) {
        if (!(throwable instanceof IOException) && !(throwable instanceof SecurityException)) {
            throwable = new IOException(throwable);
        }
        return new CompletedFuture<Object, A>(asynchronousChannel, null, throwable, a);
    }

    @Override
    public V get() throws ExecutionException {
        if (this.exc != null) {
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws ExecutionException {
        if (timeUnit == null) {
            throw new NullPointerException();
        }
        if (this.exc != null) {
            throw new ExecutionException(this.exc);
        }
        return this.result;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    Throwable exception() {
        return this.exc;
    }

    @Override
    V value() {
        return this.result;
    }
}

