/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pisces.LineSink;
import sun.java2d.pisces.PiscesMath;
import sun.java2d.pisces.Transform4;

public class Dasher
extends LineSink {
    LineSink output;
    int[] dash;
    int startPhase;
    boolean startDashOn;
    int startIdx;
    int idx;
    boolean dashOn;
    int phase;
    int sx;
    int sy;
    int x0;
    int y0;
    int m00;
    int m01;
    int m10;
    int m11;
    Transform4 transform;
    boolean symmetric;
    long ldet;
    boolean firstDashOn;
    boolean starting;
    int sx1;
    int sy1;

    public Dasher() {
    }

    public Dasher(LineSink lineSink, int[] nArray, int n, Transform4 transform4) {
        this.setOutput(lineSink);
        this.setParameters(nArray, n, transform4);
    }

    public void setOutput(LineSink lineSink) {
        this.output = lineSink;
    }

    public void setParameters(int[] nArray, int n, Transform4 transform4) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("phase < 0 !");
        }
        int n3 = 0;
        this.dashOn = true;
        while (n >= (n2 = nArray[n3])) {
            n -= n2;
            n3 = (n3 + 1) % nArray.length;
            this.dashOn = !this.dashOn;
        }
        this.dash = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.dash[i] = nArray[i];
        }
        this.startPhase = this.phase = n;
        this.startDashOn = this.dashOn;
        this.startIdx = n3;
        this.transform = transform4;
        this.m00 = transform4.m00;
        this.m01 = transform4.m01;
        this.m10 = transform4.m10;
        this.m11 = transform4.m11;
        this.ldet = (long)this.m00 * (long)this.m11 - (long)this.m01 * (long)this.m10 >> 16;
        this.symmetric = this.m00 == this.m11 && this.m10 == -this.m01;
    }

    public void moveTo(int n, int n2) {
        this.output.moveTo(n, n2);
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.sx = this.x0 = n;
        this.sy = this.y0 = n2;
        this.starting = true;
    }

    public void lineJoin() {
        this.output.lineJoin();
    }

    private void goTo(int n, int n2) {
        if (this.dashOn) {
            if (this.starting) {
                this.sx1 = n;
                this.sy1 = n2;
                this.firstDashOn = true;
                this.starting = false;
            }
            this.output.lineTo(n, n2);
        } else {
            if (this.starting) {
                this.firstDashOn = false;
                this.starting = false;
            }
            this.output.moveTo(n, n2);
        }
        this.x0 = n;
        this.y0 = n2;
    }

    public void lineTo(int n, int n2) {
        while (true) {
            long l;
            int n3;
            int n4 = this.dash[this.idx] - this.phase;
            int n5 = n - this.x0;
            int n6 = n2 - this.y0;
            if (this.symmetric) {
                n3 = (int)((long)PiscesMath.hypot(n5, n6) * 65536L / this.ldet);
            } else {
                l = ((long)n6 * (long)this.m00 - (long)n5 * (long)this.m10) / this.ldet;
                long l2 = ((long)n6 * (long)this.m01 - (long)n5 * (long)this.m11) / this.ldet;
                n3 = (int)PiscesMath.hypot(l, l2);
            }
            if (n3 < n4) {
                this.goTo(n, n2);
                this.phase += n3;
                return;
            }
            l = ((long)n4 << 16) / (long)n3;
            int n7 = this.x0 + (int)(l * (long)(n - this.x0) >> 16);
            int n8 = this.y0 + (int)(l * (long)(n2 - this.y0) >> 16);
            this.goTo(n7, n8);
            this.idx = (this.idx + 1) % this.dash.length;
            this.dashOn = !this.dashOn;
            this.phase = 0;
        }
    }

    public void close() {
        this.lineTo(this.sx, this.sy);
        if (this.firstDashOn) {
            this.output.lineTo(this.sx1, this.sy1);
        }
    }

    public void end() {
        this.output.end();
    }
}

