/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodHandles;
import java.dyn.MethodType;
import sun.dyn.Access;
import sun.dyn.MethodHandleImpl;

public class Invokers {
    private final MethodType targetType;
    private MethodHandle exactInvoker;
    private MethodHandle genericInvoker;

    public Invokers(Access access, MethodType methodType) {
        Access.check(access);
        this.targetType = methodType;
    }

    public static MethodType invokerType(MethodType methodType) {
        return methodType.insertParameterType(0, MethodHandle.class);
    }

    public MethodHandle exactInvoker() {
        MethodHandle methodHandle = this.exactInvoker;
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = MethodHandleImpl.IMPL_LOOKUP.findVirtual(MethodHandle.class, "invoke", this.targetType);
        if (methodHandle == null) {
            throw new InternalError("JVM cannot find invoker for " + this.targetType);
        }
        assert (Invokers.invokerType(this.targetType) == methodHandle.type());
        this.exactInvoker = methodHandle;
        return methodHandle;
    }

    public MethodHandle genericInvoker() {
        MethodHandle methodHandle = this.exactInvoker();
        MethodHandle methodHandle2 = this.genericInvoker;
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        MethodType methodType = this.targetType.generic();
        this.genericInvoker = methodHandle2 = MethodHandles.convertArguments(methodHandle, Invokers.invokerType(methodType));
        return methodHandle2;
    }

    public MethodHandle varargsInvoker() {
        throw new UnsupportedOperationException("NYI");
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }
}

