/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.awt.X11.InfoWindow;
import sun.awt.X11.XAWTIcon32_security_icon_bw16_png;
import sun.awt.X11.XAWTIcon32_security_icon_bw24_png;
import sun.awt.X11.XAWTIcon32_security_icon_bw32_png;
import sun.awt.X11.XAWTIcon32_security_icon_bw48_png;
import sun.awt.X11.XAWTIcon32_security_icon_interim16_png;
import sun.awt.X11.XAWTIcon32_security_icon_interim24_png;
import sun.awt.X11.XAWTIcon32_security_icon_interim32_png;
import sun.awt.X11.XAWTIcon32_security_icon_interim48_png;
import sun.awt.X11.XAWTIcon32_security_icon_yellow16_png;
import sun.awt.X11.XAWTIcon32_security_icon_yellow24_png;
import sun.awt.X11.XAWTIcon32_security_icon_yellow32_png;
import sun.awt.X11.XAWTIcon32_security_icon_yellow48_png;
import sun.awt.X11.XAWTIcon64_security_icon_bw16_png;
import sun.awt.X11.XAWTIcon64_security_icon_bw24_png;
import sun.awt.X11.XAWTIcon64_security_icon_bw32_png;
import sun.awt.X11.XAWTIcon64_security_icon_bw48_png;
import sun.awt.X11.XAWTIcon64_security_icon_interim16_png;
import sun.awt.X11.XAWTIcon64_security_icon_interim24_png;
import sun.awt.X11.XAWTIcon64_security_icon_interim32_png;
import sun.awt.X11.XAWTIcon64_security_icon_interim48_png;
import sun.awt.X11.XAWTIcon64_security_icon_yellow16_png;
import sun.awt.X11.XAWTIcon64_security_icon_yellow24_png;
import sun.awt.X11.XAWTIcon64_security_icon_yellow32_png;
import sun.awt.X11.XAWTIcon64_security_icon_yellow48_png;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

class XWarningWindow
extends XWindow {
    private static final int showingDelay = 330;
    private static final int hidingDelay = 2000;
    private final Window ownerWindow;
    private WeakReference<XWindowPeer> ownerPeer;
    private long parentWindow;
    private static final String OWNER = "OWNER";
    private static XIconInfo[][] icons;
    private InfoWindow.Tooltip tooltip;
    private volatile int currentIcon = 0;
    private volatile int currentSize = -1;
    private volatile boolean sizeUpdated = true;
    private final Runnable hidingTask = new Runnable(){

        public void run() {
            XWarningWindow.this.xSetVisible(false);
        }
    };
    private final Runnable showingTask = new Runnable(){

        public void run() {
            new Thread(){

                public void run() {
                    if (!XWarningWindow.this.isVisible()) {
                        XWarningWindow.this.xSetVisible(true);
                        XWarningWindow.this.updateWarningWindowBounds();
                    }
                    XWarningWindow.this.repaint();
                    if (XWarningWindow.this.currentIcon > 0) {
                        XWarningWindow.this.currentIcon--;
                        XToolkit.schedule(XWarningWindow.this.showingTask, 330L);
                    }
                }
            }.start();
        }
    };

    public final Window getOwnerWindow() {
        return this.ownerWindow;
    }

    private static synchronized XIconInfo getSecurityIconInfo(int n, int n2) {
        if (icons == null) {
            icons = new XIconInfo[4][3];
            if (XlibWrapper.dataModel == 32) {
                XWarningWindow.icons[0][0] = new XIconInfo(XAWTIcon32_security_icon_bw16_png.security_icon_bw16_png);
                XWarningWindow.icons[0][1] = new XIconInfo(XAWTIcon32_security_icon_interim16_png.security_icon_interim16_png);
                XWarningWindow.icons[0][2] = new XIconInfo(XAWTIcon32_security_icon_yellow16_png.security_icon_yellow16_png);
                XWarningWindow.icons[1][0] = new XIconInfo(XAWTIcon32_security_icon_bw24_png.security_icon_bw24_png);
                XWarningWindow.icons[1][1] = new XIconInfo(XAWTIcon32_security_icon_interim24_png.security_icon_interim24_png);
                XWarningWindow.icons[1][2] = new XIconInfo(XAWTIcon32_security_icon_yellow24_png.security_icon_yellow24_png);
                XWarningWindow.icons[2][0] = new XIconInfo(XAWTIcon32_security_icon_bw32_png.security_icon_bw32_png);
                XWarningWindow.icons[2][1] = new XIconInfo(XAWTIcon32_security_icon_interim32_png.security_icon_interim32_png);
                XWarningWindow.icons[2][2] = new XIconInfo(XAWTIcon32_security_icon_yellow32_png.security_icon_yellow32_png);
                XWarningWindow.icons[3][0] = new XIconInfo(XAWTIcon32_security_icon_bw48_png.security_icon_bw48_png);
                XWarningWindow.icons[3][1] = new XIconInfo(XAWTIcon32_security_icon_interim48_png.security_icon_interim48_png);
                XWarningWindow.icons[3][2] = new XIconInfo(XAWTIcon32_security_icon_yellow48_png.security_icon_yellow48_png);
            } else {
                XWarningWindow.icons[0][0] = new XIconInfo(XAWTIcon64_security_icon_bw16_png.security_icon_bw16_png);
                XWarningWindow.icons[0][1] = new XIconInfo(XAWTIcon64_security_icon_interim16_png.security_icon_interim16_png);
                XWarningWindow.icons[0][2] = new XIconInfo(XAWTIcon64_security_icon_yellow16_png.security_icon_yellow16_png);
                XWarningWindow.icons[1][0] = new XIconInfo(XAWTIcon64_security_icon_bw24_png.security_icon_bw24_png);
                XWarningWindow.icons[1][1] = new XIconInfo(XAWTIcon64_security_icon_interim24_png.security_icon_interim24_png);
                XWarningWindow.icons[1][2] = new XIconInfo(XAWTIcon64_security_icon_yellow24_png.security_icon_yellow24_png);
                XWarningWindow.icons[2][0] = new XIconInfo(XAWTIcon64_security_icon_bw32_png.security_icon_bw32_png);
                XWarningWindow.icons[2][1] = new XIconInfo(XAWTIcon64_security_icon_interim32_png.security_icon_interim32_png);
                XWarningWindow.icons[2][2] = new XIconInfo(XAWTIcon64_security_icon_yellow32_png.security_icon_yellow32_png);
                XWarningWindow.icons[3][0] = new XIconInfo(XAWTIcon64_security_icon_bw48_png.security_icon_bw48_png);
                XWarningWindow.icons[3][1] = new XIconInfo(XAWTIcon64_security_icon_interim48_png.security_icon_interim48_png);
                XWarningWindow.icons[3][2] = new XIconInfo(XAWTIcon64_security_icon_yellow48_png.security_icon_yellow48_png);
            }
        }
        int n3 = n % icons.length;
        return icons[n3][n2 % icons[n3].length];
    }

    private synchronized boolean updateIconSize() {
        int n = this.currentSize;
        if (this.ownerWindow != null) {
            Insets insets = this.ownerWindow.getInsets();
            int n2 = Math.max(insets.top, Math.max(insets.bottom, Math.max(insets.left, insets.right)));
            n = n2 < 24 ? 0 : (n2 < 32 ? 1 : (n2 < 48 ? 2 : 3));
        }
        if (n != this.currentSize) {
            this.currentSize = n;
            this.sizeUpdated = true;
        }
        return this.sizeUpdated;
    }

    private synchronized XIconInfo getSecurityIconInfo() {
        this.updateIconSize();
        return XWarningWindow.getSecurityIconInfo(this.currentSize, this.currentIcon);
    }

    XWarningWindow(Window window, long l, XWindowPeer xWindowPeer) {
        super(new XCreateWindowParams(new Object[]{"target", window, OWNER, l}));
        this.ownerWindow = window;
        this.parentWindow = l;
        this.tooltip = new InfoWindow.Tooltip(null, this.getTarget(), new InfoWindow.Tooltip.LiveArguments(){

            public boolean isDisposed() {
                return XWarningWindow.this.isDisposed();
            }

            public Rectangle getBounds() {
                return XWarningWindow.this.getBounds();
            }

            public String getTooltipString() {
                return XWarningWindow.this.ownerWindow.getWarningString();
            }
        });
        this.ownerPeer = new WeakReference<XWindowPeer>(xWindowPeer);
    }

    private void requestNoTaskbar() {
        XNETProtocol xNETProtocol = XWM.getWM().getNETProtocol();
        if (xNETProtocol != null) {
            xNETProtocol.requestState(this, xNETProtocol.XA_NET_WM_STATE_SKIP_TASKBAR, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        XToolkit.awtLock();
        try {
            XWM.setMotifDecor(this, false, 0, 0);
            XWM.setOLDecor(this, false, 0);
            long l = (Long)xCreateWindowParams.get(OWNER);
            XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), this.getWindow(), l);
            XWMHints xWMHints = this.getWMHints();
            xWMHints.set_flags(xWMHints.get_flags() | 1L | 2L);
            xWMHints.set_input(false);
            xWMHints.set_initial_state(1);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), xWMHints.pData);
            this.initWMProtocols();
            this.requestNoTaskbar();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWarningWindowBounds() {
        XWindowPeer xWindowPeer = (XWindowPeer)this.ownerPeer.get();
        if (xWindowPeer != null) {
            XWarningWindow xWarningWindow = this;
            synchronized (xWarningWindow) {
                if (this.updateIconSize()) {
                    XIconInfo xIconInfo = this.getSecurityIconInfo();
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.SetBitmapShape(XToolkit.getDisplay(), this.getWindow(), xIconInfo.getWidth(), xIconInfo.getHeight(), xIconInfo.getIntData());
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    this.sizeUpdated = false;
                    AWTAccessor.getWindowAccessor().setSecurityWarningSize(this.ownerWindow, xIconInfo.getWidth(), xIconInfo.getHeight());
                }
            }
            xWindowPeer.repositionSecurityWarning();
        }
    }

    public void reposition(int n, int n2, int n3, int n4) {
        Point2D point2D = AWTAccessor.getWindowAccessor().calculateSecurityWarningPosition(this.ownerWindow, n, n2, n3, n4);
        this.reshape((int)point2D.getX(), (int)point2D.getY(), this.getWidth(), this.getHeight());
    }

    protected String getWMName() {
        return "Warning window";
    }

    public Graphics getGraphics() {
        if (this.surfaceData == null || this.ownerWindow == null) {
            return null;
        }
        return this.getGraphics(this.surfaceData, this.getColor(), this.getBackground(), this.getFont());
    }

    void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawImage(this.getSecurityIconInfo().getImage(), 0, 0, null);
    }

    String getWarningString() {
        return this.ownerWindow.getWarningString();
    }

    int getWidth() {
        return this.getSecurityIconInfo().getWidth();
    }

    int getHeight() {
        return this.getSecurityIconInfo().getHeight();
    }

    Color getBackground() {
        return SystemColor.window;
    }

    Color getColor() {
        return Color.black;
    }

    Font getFont() {
        return this.ownerWindow.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        Rectangle rectangle = this.getBounds();
        Graphics graphics = this.getGraphics();
        try {
            this.paint(graphics, 0, 0, rectangle.width, rectangle.height);
            Object var4_3 = null;
            graphics.dispose();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            graphics.dispose();
            throw throwable;
        }
    }

    public void handleExposeEvent(XEvent xEvent) {
        super.handleExposeEvent(xEvent);
        XExposeEvent xExposeEvent = xEvent.get_xexpose();
        final int n = xExposeEvent.get_x();
        final int n2 = xExposeEvent.get_y();
        final int n3 = xExposeEvent.get_width();
        final int n4 = xExposeEvent.get_height();
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Graphics graphics = XWarningWindow.this.getGraphics();
                try {
                    XWarningWindow.this.paint(graphics, n, n2, n3, n4);
                    Object var3_2 = null;
                    graphics.dispose();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
        });
    }

    protected boolean isEventDisabled(XEvent xEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withdraw() {
        XEvent xEvent = new XEvent();
        try {
            long l;
            XToolkit.awtLock();
            try {
                l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            xEvent.set_type(18);
            XUnmapEvent xUnmapEvent = xEvent.get_xunmap();
            xUnmapEvent.set_event(l);
            xUnmapEvent.set_window(this.getWindow());
            xUnmapEvent.set_from_configure(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), l, false, 0x180000L, xEvent.pData);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var9_10 = null;
            xEvent.dispose();
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            xEvent.dispose();
            throw throwable;
        }
    }

    protected void stateChanged(long l, int n, int n2) {
        if (n2 == 3) {
            super.xSetVisible(false);
            this.withdraw();
        }
    }

    protected void setMouseAbove(boolean bl) {
        super.setMouseAbove(bl);
        XWindowPeer xWindowPeer = (XWindowPeer)this.ownerPeer.get();
        if (xWindowPeer != null) {
            xWindowPeer.updateSecurityWarningVisibility();
        }
    }

    protected void enterNotify(long l) {
        super.enterNotify(l);
        if (l == this.getWindow()) {
            this.tooltip.enter();
        }
    }

    protected void leaveNotify(long l) {
        super.leaveNotify(l);
        if (l == this.getWindow()) {
            this.tooltip.exit();
        }
    }

    public void xSetVisible(boolean bl) {
        super.xSetVisible(bl);
        this.requestNoTaskbar();
    }

    public void setSecurityWarningVisible(boolean bl) {
        this.setSecurityWarningVisible(bl, true);
    }

    public void setSecurityWarningVisible(boolean bl, boolean bl2) {
        if (bl) {
            XToolkit.remove(this.hidingTask);
            XToolkit.remove(this.showingTask);
            this.currentIcon = this.isVisible() ? 0 : 3;
            if (bl2) {
                XToolkit.schedule(this.showingTask, 1L);
            } else {
                this.showingTask.run();
            }
        } else {
            XToolkit.remove(this.showingTask);
            XToolkit.remove(this.hidingTask);
            if (!this.isVisible()) {
                return;
            }
            if (bl2) {
                XToolkit.schedule(this.hidingTask, 2000L);
            } else {
                this.hidingTask.run();
            }
        }
    }
}

