/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOError;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileRef;
import java.nio.file.Files;
import sun.nio.fs.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectoryStreamFilters {
    private DirectoryStreamFilters() {
    }

    public static <T extends FileRef> DirectoryStream.Filter<T> newContentTypeFilter(String string) {
        final MimeType mimeType = MimeType.parse(string);
        if (mimeType.hasParameters()) {
            throw new IllegalArgumentException("Parameters not allowed");
        }
        return new DirectoryStream.Filter<T>(){

            @Override
            public boolean accept(T t) {
                String string;
                try {
                    string = Files.probeContentType(t);
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
                if (string != null) {
                    return mimeType.match(string);
                }
                return false;
            }
        };
    }

    public static <T> DirectoryStream.Filter<T> allOf(final Iterable<? extends DirectoryStream.Filter<? super T>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("'filters' is null");
        }
        return new DirectoryStream.Filter<T>(){

            @Override
            public boolean accept(T t) {
                for (DirectoryStream.Filter filter : iterable) {
                    if (filter.accept(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> DirectoryStream.Filter<T> anyOf(final Iterable<? extends DirectoryStream.Filter<? super T>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("'filters' is null");
        }
        return new DirectoryStream.Filter<T>(){

            @Override
            public boolean accept(T t) {
                for (DirectoryStream.Filter filter : iterable) {
                    if (!filter.accept(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> DirectoryStream.Filter<T> complementOf(final DirectoryStream.Filter<T> filter) {
        if (filter == null) {
            throw new NullPointerException("'filter' is null");
        }
        return new DirectoryStream.Filter<T>(){

            @Override
            public boolean accept(T t) {
                return !filter.accept(t);
            }
        };
    }
}

