/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.CompletionHandler;
import java.nio.channels.MulticastChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsynchronousDatagramChannel
implements AsynchronousByteChannel,
MulticastChannel {
    private final AsynchronousChannelProvider provider;

    protected AsynchronousDatagramChannel(AsynchronousChannelProvider asynchronousChannelProvider) {
        this.provider = asynchronousChannelProvider;
    }

    public final AsynchronousChannelProvider provider() {
        return this.provider;
    }

    public static AsynchronousDatagramChannel open(ProtocolFamily protocolFamily, AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        AsynchronousChannelProvider asynchronousChannelProvider = asynchronousChannelGroup == null ? AsynchronousChannelProvider.provider() : asynchronousChannelGroup.provider();
        return asynchronousChannelProvider.openAsynchronousDatagramChannel(protocolFamily, asynchronousChannelGroup);
    }

    public static AsynchronousDatagramChannel open() throws IOException {
        return AsynchronousDatagramChannel.open(null, null);
    }

    @Override
    public abstract AsynchronousDatagramChannel bind(SocketAddress var1) throws IOException;

    @Override
    public abstract <T> AsynchronousDatagramChannel setOption(SocketOption<T> var1, T var2) throws IOException;

    public abstract SocketAddress getRemoteAddress() throws IOException;

    public abstract AsynchronousDatagramChannel connect(SocketAddress var1) throws IOException;

    public abstract AsynchronousDatagramChannel disconnect() throws IOException;

    public abstract <A> Future<SocketAddress> receive(ByteBuffer var1, long var2, TimeUnit var4, A var5, CompletionHandler<SocketAddress, ? super A> var6);

    public final <A> Future<SocketAddress> receive(ByteBuffer byteBuffer, A a, CompletionHandler<SocketAddress, ? super A> completionHandler) {
        return this.receive(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    public final <A> Future<SocketAddress> receive(ByteBuffer byteBuffer) {
        return this.receive(byteBuffer, 0L, TimeUnit.MILLISECONDS, null, null);
    }

    public abstract <A> Future<Integer> send(ByteBuffer var1, SocketAddress var2, long var3, TimeUnit var5, A var6, CompletionHandler<Integer, ? super A> var7);

    public final <A> Future<Integer> send(ByteBuffer byteBuffer, SocketAddress socketAddress, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        return this.send(byteBuffer, socketAddress, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    public final Future<Integer> send(ByteBuffer byteBuffer, SocketAddress socketAddress) {
        return this.send(byteBuffer, socketAddress, 0L, TimeUnit.MILLISECONDS, null, null);
    }

    public abstract <A> Future<Integer> read(ByteBuffer var1, long var2, TimeUnit var4, A var5, CompletionHandler<Integer, ? super A> var6);

    @Override
    public final <A> Future<Integer> read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        return this.read(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    @Override
    public final Future<Integer> read(ByteBuffer byteBuffer) {
        return this.read(byteBuffer, 0L, TimeUnit.MILLISECONDS, null, null);
    }

    public abstract <A> Future<Integer> write(ByteBuffer var1, long var2, TimeUnit var4, A var5, CompletionHandler<Integer, ? super A> var6);

    @Override
    public final <A> Future<Integer> write(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
        return this.write(byteBuffer, 0L, TimeUnit.MILLISECONDS, a, completionHandler);
    }

    @Override
    public final Future<Integer> write(ByteBuffer byteBuffer) {
        return this.write(byteBuffer, 0L, TimeUnit.MILLISECONDS, null, null);
    }
}

