/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.UtilException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.PortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainsModel {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.util");
    private Class annotatedClass;
    private List<HandlerChainType> handlerChains;
    private String id;
    public static final String PROTOCOL_SOAP11_TOKEN = "##SOAP11_HTTP";
    public static final String PROTOCOL_SOAP12_TOKEN = "##SOAP12_HTTP";
    public static final String PROTOCOL_XML_TOKEN = "##XML_HTTP";
    public static final String NS_109 = "http://java.sun.com/xml/ns/javaee";
    public static final QName QNAME_CHAIN_PORT_PATTERN = new QName("http://java.sun.com/xml/ns/javaee", "port-name-pattern");
    public static final QName QNAME_CHAIN_PROTOCOL_BINDING = new QName("http://java.sun.com/xml/ns/javaee", "protocol-bindings");
    public static final QName QNAME_CHAIN_SERVICE_PATTERN = new QName("http://java.sun.com/xml/ns/javaee", "service-name-pattern");
    public static final QName QNAME_HANDLER_CHAIN = new QName("http://java.sun.com/xml/ns/javaee", "handler-chain");
    public static final QName QNAME_HANDLER_CHAINS = new QName("http://java.sun.com/xml/ns/javaee", "handler-chains");
    public static final QName QNAME_HANDLER = new QName("http://java.sun.com/xml/ns/javaee", "handler");
    public static final QName QNAME_HANDLER_NAME = new QName("http://java.sun.com/xml/ns/javaee", "handler-name");
    public static final QName QNAME_HANDLER_CLASS = new QName("http://java.sun.com/xml/ns/javaee", "handler-class");
    public static final QName QNAME_HANDLER_PARAM = new QName("http://java.sun.com/xml/ns/javaee", "init-param");
    public static final QName QNAME_HANDLER_PARAM_NAME = new QName("http://java.sun.com/xml/ns/javaee", "param-name");
    public static final QName QNAME_HANDLER_PARAM_VALUE = new QName("http://java.sun.com/xml/ns/javaee", "param-value");
    public static final QName QNAME_HANDLER_HEADER = new QName("http://java.sun.com/xml/ns/javaee", "soap-header");
    public static final QName QNAME_HANDLER_ROLE = new QName("http://java.sun.com/xml/ns/javaee", "soap-role");

    private HandlerChainsModel(Class clazz) {
        this.annotatedClass = clazz;
    }

    private List<HandlerChainType> getHandlerChain() {
        if (this.handlerChains == null) {
            this.handlerChains = new ArrayList<HandlerChainType>();
        }
        return this.handlerChains;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public static HandlerChainsModel parseHandlerConfigFile(Class clazz, XMLStreamReader xMLStreamReader) {
        HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER_CHAINS);
        HandlerChainsModel handlerChainsModel = new HandlerChainsModel(clazz);
        List<HandlerChainType> list = handlerChainsModel.getHandlerChain();
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        while (xMLStreamReader.getName().equals(QNAME_HANDLER_CHAIN)) {
            String string;
            Object object;
            Object object2;
            HandlerChainType handlerChainType = new HandlerChainType();
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            if (xMLStreamReader.getName().equals(QNAME_CHAIN_PORT_PATTERN)) {
                object2 = XMLStreamReaderUtil.getElementQName(xMLStreamReader);
                handlerChainType.setPortNamePattern((QName)object2);
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            } else if (xMLStreamReader.getName().equals(QNAME_CHAIN_PROTOCOL_BINDING)) {
                object2 = XMLStreamReaderUtil.getElementText(xMLStreamReader);
                object = new StringTokenizer((String)object2);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    handlerChainType.addProtocolBinding(string);
                }
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            } else if (xMLStreamReader.getName().equals(QNAME_CHAIN_SERVICE_PATTERN)) {
                object2 = XMLStreamReaderUtil.getElementQName(xMLStreamReader);
                handlerChainType.setServiceNamePattern((QName)object2);
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            }
            object2 = handlerChainType.getHandlers();
            while (xMLStreamReader.getName().equals(QNAME_HANDLER)) {
                object = new HandlerType();
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
                if (xMLStreamReader.getName().equals(QNAME_HANDLER_NAME)) {
                    string = XMLStreamReaderUtil.getElementText(xMLStreamReader).trim();
                    ((HandlerType)object).setHandlerName(string);
                    XMLStreamReaderUtil.nextContent(xMLStreamReader);
                }
                HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER_CLASS);
                string = XMLStreamReaderUtil.getElementText(xMLStreamReader).trim();
                ((HandlerType)object).setHandlerClass(string);
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
                while (xMLStreamReader.getName().equals(QNAME_HANDLER_PARAM)) {
                    HandlerChainsModel.skipInitParamElement(xMLStreamReader);
                }
                while (xMLStreamReader.getName().equals(QNAME_HANDLER_HEADER)) {
                    HandlerChainsModel.skipTextElement(xMLStreamReader);
                }
                while (xMLStreamReader.getName().equals(QNAME_HANDLER_ROLE)) {
                    List<String> list2 = ((HandlerType)object).getSoapRoles();
                    list2.add(XMLStreamReaderUtil.getElementText(xMLStreamReader));
                    XMLStreamReaderUtil.nextContent(xMLStreamReader);
                }
                object2.add(object);
                HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER);
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
            }
            HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER_CHAIN);
            list.add(handlerChainType);
            XMLStreamReaderUtil.nextContent(xMLStreamReader);
        }
        return handlerChainsModel;
    }

    public static HandlerAnnotationInfo parseHandlerFile(XMLStreamReader xMLStreamReader, ClassLoader classLoader, QName qName, QName qName2, WSBinding wSBinding) {
        HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER_CHAINS);
        String string = wSBinding.getBindingId().toString();
        HandlerAnnotationInfo handlerAnnotationInfo = new HandlerAnnotationInfo();
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        HashSet<String> hashSet = new HashSet<String>();
        while (xMLStreamReader.getName().equals(QNAME_HANDLER_CHAIN)) {
            boolean bl;
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            if (xMLStreamReader.getName().equals(QNAME_CHAIN_PORT_PATTERN)) {
                if (qName2 == null) {
                    logger.warning("handler chain sepcified for port but port QName passed to parser is null");
                }
                if (!(bl = JAXWSUtils.matchQNames(qName2, XMLStreamReaderUtil.getElementQName(xMLStreamReader)))) {
                    HandlerChainsModel.skipChain(xMLStreamReader);
                    continue;
                }
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            } else if (xMLStreamReader.getName().equals(QNAME_CHAIN_PROTOCOL_BINDING)) {
                if (string == null) {
                    logger.warning("handler chain sepcified for bindingId but bindingId passed to parser is null");
                }
                String string2 = XMLStreamReaderUtil.getElementText(xMLStreamReader);
                boolean bl2 = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string4 = DeploymentDescriptorParser.getBindingIdForToken(string4);
                    String string5 = BindingID.parse(string4).toString();
                    arrayList2.add(string5);
                }
                if (arrayList2.contains(string)) {
                    bl2 = false;
                }
                if (bl2) {
                    HandlerChainsModel.skipChain(xMLStreamReader);
                    continue;
                }
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            } else if (xMLStreamReader.getName().equals(QNAME_CHAIN_SERVICE_PATTERN)) {
                if (qName == null) {
                    logger.warning("handler chain sepcified for service but service QName passed to parser is null");
                }
                if (!(bl = JAXWSUtils.matchQNames(qName, XMLStreamReaderUtil.getElementQName(xMLStreamReader)))) {
                    HandlerChainsModel.skipChain(xMLStreamReader);
                    continue;
                }
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            }
            while (xMLStreamReader.getName().equals(QNAME_HANDLER)) {
                Handler handler;
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
                if (xMLStreamReader.getName().equals(QNAME_HANDLER_NAME)) {
                    HandlerChainsModel.skipTextElement(xMLStreamReader);
                }
                HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER_CLASS);
                try {
                    handler = (Handler)HandlerChainsModel.loadClass(classLoader, XMLStreamReaderUtil.getElementText(xMLStreamReader).trim()).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
                while (xMLStreamReader.getName().equals(QNAME_HANDLER_PARAM)) {
                    HandlerChainsModel.skipInitParamElement(xMLStreamReader);
                }
                while (xMLStreamReader.getName().equals(QNAME_HANDLER_HEADER)) {
                    HandlerChainsModel.skipTextElement(xMLStreamReader);
                }
                while (xMLStreamReader.getName().equals(QNAME_HANDLER_ROLE)) {
                    hashSet.add(XMLStreamReaderUtil.getElementText(xMLStreamReader));
                    XMLStreamReaderUtil.nextContent(xMLStreamReader);
                }
                for (Method method : handler.getClass().getMethods()) {
                    if (method.getAnnotation(PostConstruct.class) == null) continue;
                    try {
                        method.invoke(handler, new Object[0]);
                        break;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
                arrayList.add(handler);
                HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER);
                XMLStreamReaderUtil.nextContent(xMLStreamReader);
            }
            HandlerChainsModel.ensureProperName(xMLStreamReader, QNAME_HANDLER_CHAIN);
            XMLStreamReaderUtil.nextContent(xMLStreamReader);
        }
        handlerAnnotationInfo.setHandlers(arrayList);
        handlerAnnotationInfo.setRoles(hashSet);
        return handlerAnnotationInfo;
    }

    public HandlerAnnotationInfo getHandlersForPortInfo(PortInfo portInfo) {
        HandlerAnnotationInfo handlerAnnotationInfo = new HandlerAnnotationInfo();
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        HashSet<String> hashSet = new HashSet<String>();
        for (HandlerChainType handlerChainType : this.handlerChains) {
            boolean bl = false;
            if (!handlerChainType.isConstraintSet() || JAXWSUtils.matchQNames(portInfo.getServiceName(), handlerChainType.getServiceNamePattern()) || JAXWSUtils.matchQNames(portInfo.getPortName(), handlerChainType.getPortNamePattern()) || handlerChainType.getProtocolBindings().contains(portInfo.getBindingID())) {
                bl = true;
            }
            if (!bl) continue;
            for (HandlerType handlerType : handlerChainType.getHandlers()) {
                try {
                    Handler handler = (Handler)HandlerChainsModel.loadClass(this.annotatedClass.getClassLoader(), handlerType.getHandlerClass()).newInstance();
                    HandlerChainsModel.callHandlerPostConstruct(handler);
                    arrayList.add(handler);
                }
                catch (InstantiationException instantiationException) {
                    throw new RuntimeException(instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                hashSet.addAll(handlerType.getSoapRoles());
            }
        }
        handlerAnnotationInfo.setHandlers(arrayList);
        handlerAnnotationInfo.setRoles(hashSet);
        return handlerAnnotationInfo;
    }

    private static Class loadClass(ClassLoader classLoader, String string) {
        try {
            return Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UtilException("util.handler.class.not.found", string);
        }
    }

    private static void callHandlerPostConstruct(Object object) {
        for (Method method : object.getClass().getMethods()) {
            if (method.getAnnotation(PostConstruct.class) == null) continue;
            try {
                method.invoke(object, new Object[0]);
                break;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static void skipChain(XMLStreamReader xMLStreamReader) {
        while (XMLStreamReaderUtil.nextContent(xMLStreamReader) != 2 || !xMLStreamReader.getName().equals(QNAME_HANDLER_CHAIN)) {
        }
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    private static void skipTextElement(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderUtil.nextContent(xMLStreamReader);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    private static void skipInitParamElement(XMLStreamReader xMLStreamReader) {
        int n;
        while ((n = XMLStreamReaderUtil.nextContent(xMLStreamReader)) != 2 || !xMLStreamReader.getName().equals(QNAME_HANDLER_PARAM)) {
        }
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    private static void ensureProperName(XMLStreamReader xMLStreamReader, QName qName) {
        if (!xMLStreamReader.getName().equals(qName)) {
            HandlerChainsModel.failWithLocalName("util.parser.wrong.element", xMLStreamReader, qName.getLocalPart());
        }
    }

    static void ensureProperName(XMLStreamReader xMLStreamReader, String string) {
        if (!xMLStreamReader.getLocalName().equals(string)) {
            HandlerChainsModel.failWithLocalName("util.parser.wrong.element", xMLStreamReader, string);
        }
    }

    private static void failWithLocalName(String string, XMLStreamReader xMLStreamReader, String string2) {
        throw new UtilException(string, Integer.toString(xMLStreamReader.getLocation().getLineNumber()), xMLStreamReader.getLocalName(), string2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HandlerType {
        String handlerName;
        String handlerClass;
        List<String> soapRoles;
        String id;

        public String getHandlerName() {
            return this.handlerName;
        }

        public void setHandlerName(String string) {
            this.handlerName = string;
        }

        public String getHandlerClass() {
            return this.handlerClass;
        }

        public void setHandlerClass(String string) {
            this.handlerClass = string;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public List<String> getSoapRoles() {
            if (this.soapRoles == null) {
                this.soapRoles = new ArrayList<String>();
            }
            return this.soapRoles;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HandlerChainType {
        QName serviceNamePattern;
        QName portNamePattern;
        List<String> protocolBindings = new ArrayList<String>();
        boolean constraintSet = false;
        List<HandlerType> handlers;
        String id;

        public void setServiceNamePattern(QName qName) {
            this.serviceNamePattern = qName;
            this.constraintSet = true;
        }

        public QName getServiceNamePattern() {
            return this.serviceNamePattern;
        }

        public void setPortNamePattern(QName qName) {
            this.portNamePattern = qName;
            this.constraintSet = true;
        }

        public QName getPortNamePattern() {
            return this.portNamePattern;
        }

        public List<String> getProtocolBindings() {
            return this.protocolBindings;
        }

        public void addProtocolBinding(String string) {
            string = DeploymentDescriptorParser.getBindingIdForToken(string);
            String string2 = BindingID.parse(string).toString();
            this.protocolBindings.add(string2);
            this.constraintSet = true;
        }

        public boolean isConstraintSet() {
            return this.constraintSet || !this.protocolBindings.isEmpty();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public List<HandlerType> getHandlers() {
            if (this.handlers == null) {
                this.handlers = new ArrayList<HandlerType>();
            }
            return this.handlers;
        }
    }
}

