/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.client.p2p;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.util.Base64;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.messaging.saaj.util.JaxmURI;
import com.sun.xml.internal.messaging.saaj.util.ParseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class HttpSOAPConnection
extends SOAPConnection {
    public static final String vmVendor = System.getProperty("java.vendor.url");
    private static final String sunVmVendor = "http://java.sun.com/";
    private static final String ibmVmVendor = "http://www.ibm.com/";
    private static final boolean isSunVM = "http://java.sun.com/".equals(vmVendor);
    private static final boolean isIBMVM = "http://www.ibm.com/".equals(vmVendor);
    private static final String JAXM_URLENDPOINT = "javax.xml.messaging.URLEndpoint";
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.client.p2p", "com.sun.xml.internal.messaging.saaj.client.p2p.LocalStrings");
    public static final String defaultProxyHost = null;
    public static final int defaultProxyPort = -1;
    MessageFactory messageFactory = null;
    boolean closed = false;
    private String proxyHost = defaultProxyHost;
    private int proxyPort = -1;
    private static final String SSL_PKG;
    private static final String SSL_PROVIDER;
    private static final int dL = 0;

    public HttpSOAPConnection() throws SOAPException {
        try {
            this.messageFactory = MessageFactory.newInstance("Dynamic Protocol");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "SAAJ0001.p2p.cannot.create.msg.factory", exception);
            throw new SOAPExceptionImpl("Unable to create message factory", exception);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            log.severe("SAAJ0002.p2p.close.already.closed.conn");
            throw new SOAPExceptionImpl("Connection already closed");
        }
        this.messageFactory = null;
        this.closed = true;
    }

    public SOAPMessage call(SOAPMessage sOAPMessage, Object object) throws SOAPException {
        Object object2;
        Object object3;
        if (this.closed) {
            log.severe("SAAJ0003.p2p.call.already.closed.conn");
            throw new SOAPExceptionImpl("Connection is closed");
        }
        Class<?> clazz = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = classLoader != null ? classLoader.loadClass(JAXM_URLENDPOINT) : Class.forName(JAXM_URLENDPOINT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.finest("SAAJ0090.p2p.endpoint.available.only.for.JAXM");
        }
        if (clazz != null && clazz.isInstance(object)) {
            object3 = null;
            try {
                object2 = clazz.getMethod("getURL", null);
                object3 = (String)((Method)object2).invoke(object, null);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0004.p2p.internal.err", exception);
                throw new SOAPExceptionImpl("Internal error: " + exception.getMessage());
            }
            try {
                object = new URL((String)object3);
            }
            catch (MalformedURLException malformedURLException) {
                log.log(Level.SEVERE, "SAAJ0005.p2p.", malformedURLException);
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof String) {
            try {
                object = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                log.log(Level.SEVERE, "SAAJ0006.p2p.bad.URL", malformedURLException);
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof URL) {
            try {
                object3 = new PriviledgedPost(this, sOAPMessage, (URL)object);
                object2 = (SOAPMessage)AccessController.doPrivileged(object3);
                return object2;
            }
            catch (Exception exception) {
                throw new SOAPExceptionImpl(exception);
            }
        }
        log.severe("SAAJ0007.p2p.bad.endPoint.type");
        throw new SOAPExceptionImpl("Bad endPoint type " + object);
    }

    public void setProxy(String string, int n) {
        try {
            this.proxyPort = n;
            PriviledgedSetProxyAction priviledgedSetProxyAction = new PriviledgedSetProxyAction(string, n);
            this.proxyHost = (String)AccessController.doPrivileged(priviledgedSetProxyAction);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    SOAPMessage post(SOAPMessage sOAPMessage, URL uRL) throws SOAPException {
        Object[] objectArray;
        Object object;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n2;
        HttpURLConnection httpURLConnection;
        boolean bl;
        block27: {
            bl = false;
            URL uRL2 = null;
            httpURLConnection = null;
            n2 = 0;
            try {
                if (uRL.getProtocol().equals("https")) {
                    this.initHttps();
                }
                object5 = new JaxmURI(uRL.toString());
                object4 = ((JaxmURI)object5).getUserinfo();
                uRL2 = uRL;
                if (!uRL2.getProtocol().equalsIgnoreCase("http") && !uRL2.getProtocol().equalsIgnoreCase("https")) {
                    log.severe("SAAJ0052.p2p.protocol.mustbe.http.or.https");
                    throw new IllegalArgumentException("Protocol " + uRL2.getProtocol() + " not supported in URL " + uRL2);
                }
                httpURLConnection = this.createConnection(uRL2);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                HttpURLConnection.setFollowRedirects(true);
                if (sOAPMessage.saveRequired()) {
                    sOAPMessage.saveChanges();
                }
                object3 = sOAPMessage.getMimeHeaders();
                object2 = ((MimeHeaders)object3).getAllHeaders();
                n = 0;
                while (object2.hasNext()) {
                    object = (MimeHeader)object2.next();
                    objectArray = ((MimeHeaders)object3).getHeader(((MimeHeader)object).getName());
                    if (objectArray.length == 1) {
                        httpURLConnection.setRequestProperty(((MimeHeader)object).getName(), ((MimeHeader)object).getValue());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (i != 0) {
                                stringBuffer.append(',');
                            }
                            stringBuffer.append(objectArray[i]);
                        }
                        httpURLConnection.setRequestProperty(((MimeHeader)object).getName(), stringBuffer.toString());
                    }
                    if (!"Authorization".equals(((MimeHeader)object).getName())) continue;
                    n = 1;
                    log.fine("SAAJ0091.p2p.https.auth.in.POST.true");
                }
                if (n == 0 && object4 != null) {
                    this.initAuthUserInfo(httpURLConnection, (String)object4);
                }
                object = httpURLConnection.getOutputStream();
                sOAPMessage.writeTo((OutputStream)object);
                ((OutputStream)object).flush();
                ((OutputStream)object).close();
                httpURLConnection.connect();
                try {
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 == 500) {
                        bl = true;
                    } else if (n2 / 100 != 2) {
                        log.log(Level.SEVERE, "SAAJ0008.p2p.bad.response", new String[]{httpURLConnection.getResponseMessage()});
                        throw new SOAPExceptionImpl("Bad response: (" + n2 + httpURLConnection.getResponseMessage());
                    }
                }
                catch (IOException iOException) {
                    n2 = httpURLConnection.getResponseCode();
                    if (n2 == 500) {
                        bl = true;
                        break block27;
                    }
                    throw iOException;
                }
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.severe("SAAJ0009.p2p.msg.send.failed");
                throw new SOAPExceptionImpl("Message send failed", exception);
            }
        }
        object5 = null;
        if (n2 == 200 || bl) {
            try {
                int n3;
                object4 = new MimeHeaders();
                n = 1;
                while (true) {
                    object3 = httpURLConnection.getHeaderFieldKey(n);
                    object2 = httpURLConnection.getHeaderField(n);
                    if (object3 == null && object2 == null) break;
                    if (object3 != null) {
                        object = new StringTokenizer((String)object2, ",");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            ((MimeHeaders)object4).addHeader((String)object3, ((StringTokenizer)object).nextToken().trim());
                        }
                    }
                    ++n;
                }
                object = bl ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                objectArray = this.readFully((InputStream)object);
                int n4 = n3 = httpURLConnection.getContentLength() == -1 ? objectArray.length : httpURLConnection.getContentLength();
                if (n3 == 0) {
                    object5 = null;
                    log.warning("SAAJ0014.p2p.content.zero");
                } else {
                    ByteInputStream byteInputStream = new ByteInputStream((byte[])objectArray, n3);
                    object5 = this.messageFactory.createMessage((MimeHeaders)object4, byteInputStream);
                }
                ((InputStream)object).close();
                httpURLConnection.disconnect();
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0010.p2p.cannot.read.resp", exception);
                throw new SOAPExceptionImpl("Unable to read response: " + exception.getMessage());
            }
        }
        return object5;
    }

    public SOAPMessage get(Object object) throws SOAPException {
        Object object2;
        Object object3;
        if (this.closed) {
            log.severe("SAAJ0011.p2p.get.already.closed.conn");
            throw new SOAPExceptionImpl("Connection is closed");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(JAXM_URLENDPOINT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null && clazz.isInstance(object)) {
            object3 = null;
            try {
                object2 = clazz.getMethod("getURL", null);
                object3 = (String)((Method)object2).invoke(object, null);
            }
            catch (Exception exception) {
                log.severe("SAAJ0004.p2p.internal.err");
                throw new SOAPExceptionImpl("Internal error: " + exception.getMessage());
            }
            try {
                object = new URL((String)object3);
            }
            catch (MalformedURLException malformedURLException) {
                log.severe("SAAJ0005.p2p.");
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof String) {
            try {
                object = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                log.severe("SAAJ0006.p2p.bad.URL");
                throw new SOAPExceptionImpl("Bad URL: " + malformedURLException.getMessage());
            }
        }
        if (object instanceof URL) {
            try {
                object3 = new PriviledgedGet(this, (URL)object);
                object2 = (SOAPMessage)AccessController.doPrivileged(object3);
                return object2;
            }
            catch (Exception exception) {
                throw new SOAPExceptionImpl(exception);
            }
        }
        throw new SOAPExceptionImpl("Bad endPoint type " + object);
    }

    SOAPMessage get(URL uRL) throws SOAPException {
        Object object;
        Object object2;
        int n;
        HttpURLConnection httpURLConnection;
        boolean bl;
        block20: {
            bl = false;
            URL uRL2 = null;
            httpURLConnection = null;
            n = 0;
            try {
                if (uRL.getProtocol().equals("https")) {
                    this.initHttps();
                }
                object2 = new JaxmURI(uRL.toString());
                object = ((JaxmURI)object2).getUserinfo();
                uRL2 = uRL;
                if (!uRL2.getProtocol().equalsIgnoreCase("http") && !uRL2.getProtocol().equalsIgnoreCase("https")) {
                    log.severe("SAAJ0052.p2p.protocol.mustbe.http.or.https");
                    throw new IllegalArgumentException("Protocol " + uRL2.getProtocol() + " not supported in URL " + uRL2);
                }
                httpURLConnection = this.createConnection(uRL2);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                HttpURLConnection.setFollowRedirects(true);
                httpURLConnection.connect();
                try {
                    n = httpURLConnection.getResponseCode();
                    if (n == 500) {
                        bl = true;
                    } else if (n / 100 != 2) {
                        log.log(Level.SEVERE, "SAAJ0008.p2p.bad.response", new String[]{httpURLConnection.getResponseMessage()});
                        throw new SOAPExceptionImpl("Bad response: (" + n + httpURLConnection.getResponseMessage());
                    }
                }
                catch (IOException iOException) {
                    n = httpURLConnection.getResponseCode();
                    if (n == 500) {
                        bl = true;
                        break block20;
                    }
                    throw iOException;
                }
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.severe("SAAJ0012.p2p.get.failed");
                throw new SOAPExceptionImpl("Get failed", exception);
            }
        }
        object2 = null;
        if (n == 200 || bl) {
            try {
                int n2;
                Object object3;
                object = new MimeHeaders();
                int n3 = 1;
                while (true) {
                    String string = httpURLConnection.getHeaderFieldKey(n3);
                    String string2 = httpURLConnection.getHeaderField(n3);
                    if (string == null && string2 == null) break;
                    if (string != null) {
                        object3 = new StringTokenizer(string2, ",");
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            ((MimeHeaders)object).addHeader(string, ((StringTokenizer)object3).nextToken().trim());
                        }
                    }
                    ++n3;
                }
                object3 = bl ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
                byte[] byArray = this.readFully((InputStream)object3);
                int n4 = n2 = httpURLConnection.getContentLength() == -1 ? byArray.length : httpURLConnection.getContentLength();
                if (n2 == 0) {
                    object2 = null;
                    log.warning("SAAJ0014.p2p.content.zero");
                } else {
                    ByteInputStream byteInputStream = new ByteInputStream(byArray, n2);
                    object2 = this.messageFactory.createMessage((MimeHeaders)object, byteInputStream);
                }
                ((InputStream)object3).close();
                httpURLConnection.disconnect();
            }
            catch (SOAPException sOAPException) {
                throw sOAPException;
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "SAAJ0010.p2p.cannot.read.resp", exception);
                throw new SOAPExceptionImpl("Unable to read response: " + exception.getMessage());
            }
        }
        return object2;
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private void initHttps() {
        String string = System.getProperty("java.protocol.handler.pkgs");
        log.log(Level.FINE, "SAAJ0053.p2p.providers", new String[]{string});
        if (string == null || string.indexOf(SSL_PKG) < 0) {
            string = string == null ? SSL_PKG : string + "|" + SSL_PKG;
            System.setProperty("java.protocol.handler.pkgs", string);
            log.log(Level.FINE, "SAAJ0054.p2p.set.providers", new String[]{string});
            try {
                Class<?> clazz = Class.forName(SSL_PROVIDER);
                Provider provider = (Provider)clazz.newInstance();
                Security.addProvider(provider);
                log.log(Level.FINE, "SAAJ0055.p2p.added.ssl.provider", new String[]{SSL_PROVIDER});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initAuthUserInfo(HttpURLConnection httpURLConnection, String string) {
        if (string != null) {
            String string2;
            String string3;
            int n = string.indexOf(58);
            if (n == -1) {
                string3 = ParseUtil.decode(string);
                string2 = null;
            } else {
                string3 = ParseUtil.decode(string.substring(0, n++));
                string2 = ParseUtil.decode(string.substring(n));
            }
            String string4 = string3 + ":";
            byte[] byArray = string4.getBytes();
            byte[] byArray2 = string2.getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            String string5 = "Basic " + new String(Base64.encode(byArray3));
            httpURLConnection.setRequestProperty("Authorization", string5);
        }
    }

    private void d(String string) {
        log.log(Level.SEVERE, "SAAJ0013.p2p.HttpSOAPConnection", new String[]{string});
        System.err.println("HttpSOAPConnection: " + string);
    }

    private HttpURLConnection createConnection(URL uRL) throws IOException {
        return (HttpURLConnection)uRL.openConnection();
    }

    static {
        if (isIBMVM) {
            SSL_PKG = "com.ibm.net.ssl.internal.www.protocol";
            SSL_PROVIDER = "com.ibm.net.ssl.internal.ssl.Provider";
        } else {
            SSL_PKG = "com.sun.net.ssl.internal.www.protocol";
            SSL_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
        }
    }

    static class PriviledgedGet
    implements PrivilegedExceptionAction {
        HttpSOAPConnection c;
        URL endPoint;

        PriviledgedGet(HttpSOAPConnection httpSOAPConnection, URL uRL) {
            this.c = httpSOAPConnection;
            this.endPoint = uRL;
        }

        public Object run() throws Exception {
            return this.c.get(this.endPoint);
        }
    }

    static class PriviledgedSetProxyAction
    implements PrivilegedExceptionAction {
        String proxyHost = null;
        int proxyPort = 0;

        PriviledgedSetProxyAction(String string, int n) {
            this.proxyHost = string;
            this.proxyPort = n;
        }

        public Object run() throws Exception {
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", new Integer(this.proxyPort).toString());
            log.log(Level.FINE, "SAAJ0050.p2p.proxy.host", new String[]{this.proxyHost});
            log.log(Level.FINE, "SAAJ0051.p2p.proxy.port", new String[]{new Integer(this.proxyPort).toString()});
            return this.proxyHost;
        }
    }

    static class PriviledgedPost
    implements PrivilegedExceptionAction {
        HttpSOAPConnection c;
        SOAPMessage message;
        URL endPoint;

        PriviledgedPost(HttpSOAPConnection httpSOAPConnection, SOAPMessage sOAPMessage, URL uRL) {
            this.c = httpSOAPConnection;
            this.message = sOAPMessage;
            this.endPoint = uRL;
        }

        public Object run() throws Exception {
            return this.c.post(this.message, this.endPoint);
        }
    }
}

