/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tracing;

import com.sun.tracing.Provider;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.util.HashSet;
import java.util.logging.Logger;
import sun.tracing.MultiplexProviderFactory;
import sun.tracing.NullProviderFactory;
import sun.tracing.PrintStreamProviderFactory;
import sun.tracing.dtrace.DTraceProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderFactory {
    protected ProviderFactory() {
    }

    public abstract <T extends Provider> T createProvider(Class<T> var1);

    public static ProviderFactory getDefaultFactory() {
        HashSet<ProviderFactory> hashSet = new HashSet<ProviderFactory>();
        String string = null;
        try {
            string = System.getProperty("com.sun.tracing.dtrace");
        }
        catch (AccessControlException accessControlException) {
            Logger.getAnonymousLogger().fine("Cannot access property com.sun.tracing.dtrace");
        }
        if ((string == null || !string.equals("disable")) && DTraceProviderFactory.isSupported()) {
            hashSet.add(new DTraceProviderFactory());
        }
        try {
            string = System.getProperty("sun.tracing.stream");
        }
        catch (AccessControlException accessControlException) {
            Logger.getAnonymousLogger().fine("Cannot access property sun.tracing.stream");
        }
        if (string != null) {
            for (String string2 : string.split(",")) {
                PrintStream printStream = ProviderFactory.getPrintStreamFromSpec(string2);
                if (printStream == null) continue;
                hashSet.add(new PrintStreamProviderFactory(printStream));
            }
        }
        if (hashSet.size() == 0) {
            return new NullProviderFactory();
        }
        if (hashSet.size() == 1) {
            return hashSet.toArray(new ProviderFactory[1])[0];
        }
        return new MultiplexProviderFactory(hashSet);
    }

    private static PrintStream getPrintStreamFromSpec(String string) {
        try {
            int n = string.lastIndexOf(46);
            Class<?> clazz = Class.forName(string.substring(0, n));
            Field field = clazz.getField(string.substring(n + 1));
            Class<?> clazz2 = field.getType();
            return (PrintStream)field.get(null);
        }
        catch (Exception exception) {
            Logger.getAnonymousLogger().warning("Could not parse sun.tracing.stream property: " + exception);
            return null;
        }
    }
}

