/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;

public class SoftAudioBuffer {
    private int size;
    private float[] buffer;
    private boolean empty = true;
    private AudioFormat format;
    private AudioFloatConverter converter;
    private byte[] converter_buffer;

    public SoftAudioBuffer(int n, AudioFormat audioFormat) {
        this.size = n;
        this.format = audioFormat;
        this.converter = AudioFloatConverter.getConverter(audioFormat);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        if (!this.empty) {
            Arrays.fill(this.buffer, 0.0f);
            this.empty = true;
        }
    }

    public boolean isSilent() {
        return this.empty;
    }

    public float[] array() {
        this.empty = false;
        if (this.buffer == null) {
            this.buffer = new float[this.size];
        }
        return this.buffer;
    }

    public void get(byte[] byArray, int n) {
        int n2 = this.format.getFrameSize() / this.format.getChannels();
        int n3 = this.size * n2;
        if (this.converter_buffer == null || this.converter_buffer.length < n3) {
            this.converter_buffer = new byte[n3];
        }
        if (this.format.getChannels() == 1) {
            this.converter.toByteArray(this.array(), this.size, byArray);
        } else {
            this.converter.toByteArray(this.array(), this.size, this.converter_buffer);
            if (n >= this.format.getChannels()) {
                return;
            }
            int n4 = this.format.getChannels() * n2;
            int n5 = n2;
            for (int i = 0; i < n2; ++i) {
                int n6 = i;
                int n7 = n * n2 + i;
                for (int j = 0; j < this.size; ++j) {
                    byArray[n7] = this.converter_buffer[n6];
                    n7 += n4;
                    n6 += n5;
                }
            }
        }
    }
}

