/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractSpinnerModel;

public class SpinnerDateModel
extends AbstractSpinnerModel
implements Serializable {
    private Calendar date;
    private Comparable start;
    private Comparable end;
    private int calendarField;
    private static final long serialVersionUID = -4802518107105940612L;

    public SpinnerDateModel() {
        this(new Date(), null, null, 5);
    }

    public SpinnerDateModel(Date date, Comparable comparable, Comparable comparable2, int n) {
        if (date == null) {
            throw new IllegalArgumentException("Null 'value' argument.");
        }
        if (comparable != null && comparable.compareTo(date) > 0) {
            throw new IllegalArgumentException("Require value on or after start.");
        }
        if (comparable2 != null && comparable2.compareTo(date) < 0) {
            throw new IllegalArgumentException("Require value on or before end.");
        }
        this.date = Calendar.getInstance();
        this.date.setTime(date);
        this.start = comparable;
        this.end = comparable2;
        this.setCalendarField(n);
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public Date getDate() {
        return this.date.getTime();
    }

    public Comparable getStart() {
        return this.start;
    }

    public Comparable getEnd() {
        return this.end;
    }

    public Object getValue() {
        return this.date.getTime();
    }

    public Object getNextValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date.getTime());
        calendar.roll(this.calendarField, true);
        Date date = calendar.getTime();
        if (this.end != null && this.end.compareTo(date) < 0) {
            return null;
        }
        return date;
    }

    public Object getPreviousValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.date.getTime());
        calendar.roll(this.calendarField, false);
        Date date = calendar.getTime();
        if (this.start != null && this.start.compareTo(date) > 0) {
            return null;
        }
        return date;
    }

    public void setCalendarField(int n) {
        if (n < 0 || n >= 17 || n == 15 || n == 16) {
            throw new IllegalArgumentException("Illegal calendarField");
        }
        if (this.calendarField != n) {
            this.calendarField = n;
            this.fireStateChanged();
        }
    }

    public void setStart(Comparable comparable) {
        if (this.start != comparable) {
            this.start = comparable;
            this.fireStateChanged();
        }
    }

    public void setEnd(Comparable comparable) {
        if (this.end != comparable) {
            this.end = comparable;
            this.fireStateChanged();
        }
    }

    public void setValue(Object object) {
        if (!(object instanceof Date) || object == null) {
            throw new IllegalArgumentException("Value not a date.");
        }
        if (!this.date.getTime().equals(object)) {
            this.date.setTime((Date)object);
            this.fireStateChanged();
        }
    }
}

