/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.dgc;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.Arrays;

public final class VMID
implements Serializable {
    static final long serialVersionUID = -538642295484486218L;
    static boolean areWeUnique;
    static byte[] localAddr;
    private byte[] addr = localAddr;
    transient int hash;
    private UID uid = new UID();

    public static boolean isUnique() {
        return areWeUnique;
    }

    public int hashCode() {
        if (this.hash == 0) {
            for (int i = 0; i < localAddr.length; ++i) {
                this.hash += this.addr[i];
            }
            this.hash ^= this.uid.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof VMID) {
            VMID vMID = (VMID)object;
            return this.uid.equals(vMID.uid) && Arrays.equals(this.addr, vMID.addr);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[VMID: ");
        for (int i = 0; i < this.addr.length; ++i) {
            if (i > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(Integer.toString(this.addr[i]));
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.uid.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        byte[] byArray = new byte[]{127, 0, 0, 1};
        try {
            localAddr = InetAddress.getLocalHost().getAddress();
            areWeUnique = Arrays.equals(byArray, localAddr) ^ true;
        }
        catch (UnknownHostException unknownHostException) {
            localAddr = byArray;
            areWeUnique = false;
        }
    }
}

