/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.javax.crypto.mac.IMac;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MacOutputStream
extends FilterOutputStream {
    private boolean digesting;
    private IMac mac;

    public MacOutputStream(OutputStream outputStream, IMac iMac) {
        super(outputStream);
        if (iMac == null) {
            throw new NullPointerException();
        }
        this.mac = iMac;
        this.digesting = true;
    }

    public IMac getMac() {
        return this.mac;
    }

    public void setMac(IMac iMac) {
        if (iMac == null) {
            throw new NullPointerException();
        }
        this.mac = iMac;
    }

    public void on(boolean bl) {
        this.digesting = bl;
    }

    public void write(int n) throws IOException {
        if (this.digesting) {
            this.mac.update((byte)n);
        }
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.digesting) {
            this.mac.update(byArray, n, n2);
        }
        this.out.write(byArray, n, n2);
    }
}

