/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralNames;
import java.io.IOException;
import java.math.BigInteger;

public class AuthorityKeyIdentifier
extends Extension.Value {
    public static final OID ID = new OID("2.5.29.35");
    private final byte[] keyIdentifier;
    private final GeneralNames authorityCertIssuer;
    private final BigInteger authorityCertSerialNumber;

    public AuthorityKeyIdentifier(byte[] byArray) throws IOException {
        super(byArray);
        DERReader dERReader = new DERReader(byArray);
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed AuthorityKeyIdentifier");
        }
        if (dERValue.getLength() > 0) {
            dERValue = dERReader.read();
        }
        if (dERValue.getTagClass() == 64 && dERValue.getTag() == 0) {
            this.keyIdentifier = (byte[])dERValue.getValue();
            dERValue = dERReader.read();
        } else {
            this.keyIdentifier = null;
        }
        if (dERValue.getTagClass() == 64 && dERValue.getTag() == 1) {
            byte[] byArray2 = dERValue.getEncoded();
            byArray2[0] = 48;
            this.authorityCertIssuer = new GeneralNames(byArray2);
            dERReader.skip(dERValue.getLength());
            dERValue = dERReader.read();
        } else {
            this.authorityCertIssuer = null;
        }
        this.authorityCertSerialNumber = dERValue.getTagClass() == 64 && dERValue.getTag() == 2 ? new BigInteger((byte[])dERValue.getValue()) : null;
    }

    public byte[] getKeyIdentifier() {
        if (this.keyIdentifier != null) {
            return (byte[])this.keyIdentifier.clone();
        }
        return null;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    public String toString() {
        return AuthorityKeyIdentifier.class$("gnu.java.security.x509.ext.AuthorityKeyIdentifier").getName() + " [ keyId=" + (this.keyIdentifier != null ? Util.toHexString(this.keyIdentifier, ':') : "nil") + " authorityCertIssuer=" + this.authorityCertIssuer + " authorityCertSerialNumbe=" + this.authorityCertSerialNumber + " ]";
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

