/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event;

import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.filters.IEventFilter;
import gnu.classpath.jdwp.exception.JdwpIllegalArgumentException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class EventRequest {
    public static final byte EVENT_SINGLE_STEP = 1;
    public static final byte EVENT_BREAKPOINT = 2;
    public static final byte EVENT_FRAME_POP = 3;
    public static final byte EVENT_EXCEPTION = 4;
    public static final byte EVENT_USER_DEFINED = 5;
    public static final byte EVENT_THREAD_START = 6;
    public static final byte EVENT_THREAD_END = 7;
    public static final byte EVENT_CLASS_PREPARE = 8;
    public static final byte EVENT_CLASS_UNLOAD = 9;
    public static final byte EVENT_CLASS_LOAD = 10;
    public static final byte EVENT_FIELD_ACCESS = 20;
    public static final byte EVENT_FIELD_MODIFY = 21;
    public static final byte EVENT_METHOD_ENTRY = 40;
    public static final byte EVENT_METHOD_EXIT = 41;
    public static final byte EVENT_VM_INIT = 90;
    public static final byte EVENT_VM_DEATH = 99;
    public static final byte SUSPEND_NONE = 0;
    public static final byte SUSPEND_THREAD = 1;
    public static final byte SUSPEND_ALL = 2;
    private static int _last_id = 0;
    private static Object _idLock = new Object();
    private LinkedList _filters = new LinkedList();
    private int _id;
    private byte _suspendPolicy;
    private byte _kind;

    public EventRequest(byte by, byte by2) {
        Object object = _idLock;
        synchronized (object) {
            try {
                this._id = ++_last_id;
            }
            finally {
                Object var4_4 = null;
            }
            this._kind = by;
            this._suspendPolicy = by2;
            return;
        }
    }

    public EventRequest(int n, byte by, byte by2) {
        this._kind = by;
        this._suspendPolicy = by2;
    }

    public void addFilter(IEventFilter iEventFilter) throws JdwpIllegalArgumentException {
        boolean bl = true;
        Class clazz = iEventFilter.getClass();
        if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.ClassExcludeFilter")) {
            if (this._kind == 6 || this._kind == 7) {
                bl = false;
            }
        } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.ClassMatchFilter")) {
            if (this._kind == 6 || this._kind == 7) {
                bl = false;
            }
        } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.ClassOnlyFilter")) {
            if (this._kind == 9 || this._kind == 6 || this._kind == 7) {
                bl = false;
            }
        } else if (clazz != EventRequest.class$("gnu.classpath.jdwp.event.filters.ConditionalFilter") && clazz != EventRequest.class$("gnu.classpath.jdwp.event.filters.CountFilter")) {
            if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.ExceptionOnlyFilter")) {
                if (this._kind != 4) {
                    bl = false;
                }
            } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.FieldOnlyFilter")) {
                if (this._kind != 20 && this._kind != 21) {
                    bl = false;
                }
            } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.InstanceOnlyFilter")) {
                if (this._kind == 8 || this._kind == 9 || this._kind == 6 || this._kind == 7) {
                    bl = false;
                }
            } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.LocationOnlyFilter")) {
                if (this._kind != 2 && this._kind != 20 && this._kind != 21 && this._kind != 1 && this._kind != 4) {
                    bl = false;
                }
            } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.StepFilter")) {
                if (this._kind != 1) {
                    bl = false;
                }
            } else if (clazz == EventRequest.class$("gnu.classpath.jdwp.event.filters.ThreadOnlyFilter") && this._kind == 9) {
                bl = false;
            }
        }
        if (!bl) {
            String string = "cannot use " + iEventFilter.getClass().getName() + " with class unload events";
            throw new JdwpIllegalArgumentException(string);
        }
        this._filters.add(iEventFilter);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Collection getFilters() {
        return this._filters;
    }

    public byte getSuspendPolicy() {
        return this._suspendPolicy;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public byte getEventKind() {
        return this._kind;
    }

    public boolean matches(Event event) {
        boolean bl = true;
        Iterator iterator = this._filters.iterator();
        while (iterator.hasNext()) {
            IEventFilter iEventFilter = (IEventFilter)iterator.next();
            if (iEventFilter.matches(event)) continue;
            bl = false;
        }
        return bl;
    }
}

