/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.processor.PacketProcessor;
import gnu.classpath.jdwp.transport.ITransport;
import gnu.classpath.jdwp.transport.JdwpConnection;
import gnu.classpath.jdwp.transport.TransportException;
import gnu.classpath.jdwp.transport.TransportFactory;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;

public class Jdwp
extends Thread {
    private static Jdwp _instance = null;
    public static boolean isDebugging = false;
    private PacketProcessor _packetProcessor;
    private Thread _ppThread;
    private HashMap _properties;
    private static final String _PROPERTY_SUSPEND = "suspend";
    private JdwpConnection _connection;
    private boolean _shutdown;
    private ThreadGroup _group;
    private Object _initLock;
    private int _initCount;

    private /* synthetic */ void finit$() {
        this._initLock = new Object();
        this._initCount = 0;
    }

    static /* synthetic */ PacketProcessor access$1(Jdwp jdwp, PacketProcessor packetProcessor) {
        jdwp._packetProcessor = packetProcessor;
        return jdwp._packetProcessor;
    }

    public Jdwp() {
        this.finit$();
        this._shutdown = false;
        _instance = this;
    }

    public static Jdwp getDefault() {
        return _instance;
    }

    public ThreadGroup getJdwpThreadGroup() {
        return this._group;
    }

    public static boolean suspendOnStartup() {
        String string;
        Jdwp jdwp = Jdwp.getDefault();
        return jdwp != null && (string = (String)jdwp._properties.get(_PROPERTY_SUSPEND)) != null && string.equals("y");
    }

    public void configure(String string) {
        this._processConfigury(string);
    }

    private void _doInitialization() throws TransportException {
        this._group = new ThreadGroup("JDWP threads");
        ITransport iTransport = TransportFactory.newInstance(this._properties);
        this._connection = new JdwpConnection(this._group, iTransport);
        this._connection.initialize();
        this._connection.start();
        this._packetProcessor = new PacketProcessor(this._connection);
        this._ppThread = new Thread(this._group, new Runnable(this){
            private /* synthetic */ Jdwp this$0;
            {
                this.this$0 = jdwp;
            }

            public void run() {
                AccessController.doPrivileged(this.this$0._packetProcessor);
            }
        }, "packet processor");
        this._ppThread.start();
    }

    public void shutdown() {
        if (!this._shutdown) {
            this._packetProcessor.shutdown();
            this._ppThread.interrupt();
            this._connection.shutdown();
            this._shutdown = true;
            isDebugging = false;
            this.interrupt();
        }
    }

    public static void notify(Event event) {
        EventManager eventManager;
        EventRequest eventRequest;
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp != null && (eventRequest = (eventManager = EventManager.getDefault()).getEventRequest(event)) != null) {
            try {
                System.out.println("Jdwp.notify: sending event " + event);
                Jdwp.sendEvent(eventRequest, event);
                jdwp._enforceSuspendPolicy(eventRequest.getSuspendPolicy());
            }
            catch (Exception exception) {
                System.out.println("Jdwp.notify: caught exception: " + exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void sendEvent(EventRequest eventRequest, Event event) throws IOException {
        Jdwp jdwp = Jdwp.getDefault();
        if (jdwp == null) return;
        JdwpConnection jdwpConnection = jdwp._connection;
        synchronized (jdwpConnection) {
            try {
                jdwp._connection.sendEvent(eventRequest, event);
                return;
            }
            finally {
                Object var4_4 = null;
            }
        }
    }

    private void _enforceSuspendPolicy(byte by) throws JdwpException {
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                VMVirtualMachine.suspendThread(Thread.currentThread());
                break;
            }
            case 2: {
                VMVirtualMachine.suspendAllThreads();
            }
        }
    }

    public void subcomponentInitialized() {
        Object object = this._initLock;
        synchronized (object) {
            try {
                ++this._initCount;
                this._initLock.notify();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void run() {
        try {
            this._doInitialization();
            Object object = this._initLock;
            synchronized (object) {
                try {
                    while (this._initCount != 2) {
                        this._initLock.wait();
                    }
                    Object var2_2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            this._initLock = null;
        }
        catch (Throwable throwable) {
            System.out.println("Exception in JDWP back-end: " + throwable);
            System.exit(1);
        }
        EventManager.getDefault();
        isDebugging = true;
    }

    private void _processConfigury(String string) {
        this._properties = new HashMap();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) continue;
            this._properties.put(stringArray2[0], stringArray2[1]);
        }
    }

    static {
        _PROPERTY_SUSPEND = _PROPERTY_SUSPEND;
    }
}

