/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class JavaLaunchShortcut
implements ILaunchShortcut {
    public void searchAndLaunch(Object[] search, String mode, String selectMessage, String emptyMessage) {
        IType[] types = null;
        try {
            types = this.findTypes(search, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_0, (String)e.getMessage());
            return;
        }
        IType type = null;
        if (types.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_1, (String)emptyMessage);
        } else if (types.length > 1) {
            try {
                type = this.chooseType(types, selectMessage);
            }
            catch (JavaModelException e) {
                this.reportErorr((CoreException)((Object)e));
                return;
            }
        } else {
            type = types[0];
        }
        if (type != null) {
            this.launch(type, mode);
        }
    }

    protected abstract IType[] findTypes(Object[] var1, IRunnableContext var2) throws InterruptedException, CoreException;

    protected IType chooseType(IType[] types, String title) throws JavaModelException {
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])types), (int)2, (boolean)false, (String)"**");
        dialog.setMessage(LauncherMessages.JavaMainTab_Choose_a_main__type_to_launch__12);
        dialog.setTitle(title);
        if (dialog.open() == 0) {
            return (IType)dialog.getResult()[0];
        }
        return null;
    }

    protected void launch(IType type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, this.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected ILaunchConfiguration findLaunchConfiguration(IType type, ILaunchConfigurationType configType) {
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getTypeSelectionTitle());
        dialog.setMessage(LauncherMessages.JavaLaunchShortcut_2);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(IType var1);

    protected void reportErorr(CoreException exception) {
        MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IJavaElement je = (IJavaElement)input.getAdapter(IJavaElement.class);
        if (je != null) {
            this.searchAndLaunch(new Object[]{je}, mode, this.getTypeSelectionTitle(), this.getEditorEmptyMessage());
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getTypeSelectionTitle(), this.getSelectionEmptyMessage());
        }
    }

    protected abstract String getTypeSelectionTitle();

    protected abstract String getEditorEmptyMessage();

    protected abstract String getSelectionEmptyMessage();
}

