/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class SpellingConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_DIGITS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_digits");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_MIXED = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_mixed");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_SENTENCE = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_sentence");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_UPPER = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_upper");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_IGNORE_URLS = SpellingConfigurationBlock.getJDTUIKey("spelling_ignore_urls");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_LOCALE = SpellingConfigurationBlock.getJDTUIKey("spelling_locale");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_PROPOSAL_THRESHOLD = SpellingConfigurationBlock.getJDTUIKey("spelling_proposal_threshold");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_USER_DICTIONARY = SpellingConfigurationBlock.getJDTUIKey("spelling_user_dictionary");
    private static final OptionsConfigurationBlock.Key PREF_SPELLING_ENABLE_CONTENTASSIST = SpellingConfigurationBlock.getJDTUIKey("spelling_enable_contentassist");
    private Text fDictionaryPath = null;
    private IStatus fFileStatus = new StatusInfo();
    private IStatus fThresholdStatus = new StatusInfo();
    private Control[] fAllControls;
    private Control[] fEnabledControls;

    protected static void createSelectionDependency(final Button master, final Control slave) {
        master.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                slave.setEnabled(master.getSelection());
            }
        });
        slave.setEnabled(master.getSelection());
    }

    protected static String[] getDictionaryCodes(Set locales) {
        int index = 0;
        Locale locale2 = null;
        String[] codes = new String[locales.size()];
        for (Locale locale2 : locales) {
            codes[index++] = locale2.toString();
        }
        return codes;
    }

    protected static String[] getDictionaryLabels(Set locales) {
        int index = 0;
        Locale locale2 = null;
        String[] labels = new String[locales.size()];
        for (Locale locale2 : locales) {
            labels[index++] = locale2.getDisplayName();
        }
        return labels;
    }

    protected static IStatus validateAbsoluteFilePath(String path) {
        File file;
        StatusInfo status = new StatusInfo();
        if (!(path.length() <= 0 || (file = new File(path)).isFile() && file.isAbsolute() && file.exists() && file.canRead() && file.canWrite())) {
            status.setError(PreferencesMessages.SpellingPreferencePage_dictionary_error);
        }
        return status;
    }

    protected static IStatus validateLocale(String locale) {
        StatusInfo status = new StatusInfo(4, PreferencesMessages.SpellingPreferencePage_locale_error);
        Set locales = SpellCheckEngine.getAvailableLocales();
        Locale current2 = null;
        for (Locale current2 : locales) {
            if (!current2.toString().equals(locale)) continue;
            return new StatusInfo();
        }
        return status;
    }

    protected static IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.SpellingPreferencePage_empty_threshold);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
            }
        }
        return status;
    }

    public SpellingConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, SpellingConfigurationBlock.getAllKeys(), container);
        IStatus status = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        if (status.getSeverity() != 0) {
            this.setValue(PREF_SPELLING_USER_DICTIONARY, "");
        }
        if ((status = SpellingConfigurationBlock.validateLocale(this.getValue(PREF_SPELLING_LOCALE))).getSeverity() != 0) {
            this.setValue(PREF_SPELLING_LOCALE, SpellCheckEngine.getDefaultLocale().toString());
        }
    }

    protected Combo addComboBox(Composite parent, String label, OptionsConfigurationBlock.Key key, String[] values, String[] valueLabels, int indent) {
        OptionsConfigurationBlock.ControlData data = new OptionsConfigurationBlock.ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        comboBox.setLayoutData((Object)gd);
        comboBox.addSelectionListener(this.getSelectionListener());
        this.fLabels.put(comboBox, labelControl);
        String currValue = this.getValue(key);
        comboBox.select(data.getSelection(currValue));
        this.fComboBoxes.add(comboBox);
        return comboBox;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        ArrayList<Object> allControls = new ArrayList<Object>();
        PixelConverter converter = new PixelConverter((Control)parent);
        String[] trueFalse = new String[]{"true", "false"};
        Group user = new Group(composite, 0);
        user.setText(PreferencesMessages.SpellingPreferencePage_preferences_user);
        user.setLayout((Layout)new GridLayout());
        user.setLayoutData((Object)new GridData(768));
        allControls.add(user);
        String label = PreferencesMessages.SpellingPreferencePage_ignore_digits_label;
        Button slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_DIGITS, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_mixed_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_MIXED, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_sentence_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_SENTENCE, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_upper_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_UPPER, trueFalse, 0);
        allControls.add(slave);
        label = PreferencesMessages.SpellingPreferencePage_ignore_url_label;
        slave = this.addCheckBox((Composite)user, label, PREF_SPELLING_IGNORE_URLS, trueFalse, 0);
        allControls.add(slave);
        Group engine = new Group(composite, 0);
        engine.setText(PreferencesMessages.SpellingPreferencePage_preferences_engine);
        engine.setLayout((Layout)new GridLayout(4, false));
        engine.setLayoutData((Object)new GridData(768));
        allControls.add(engine);
        label = PreferencesMessages.SpellingPreferencePage_dictionary_label;
        Set locales = SpellCheckEngine.getAvailableLocales();
        Combo combo = this.addComboBox((Composite)engine, label, PREF_SPELLING_LOCALE, SpellingConfigurationBlock.getDictionaryCodes(locales), SpellingConfigurationBlock.getDictionaryLabels(locales), 0);
        combo.setEnabled(locales.size() > 1);
        allControls.add(combo);
        allControls.add(this.fLabels.get(combo));
        new Label((Composite)engine, 0);
        label = PreferencesMessages.SpellingPreferencePage_workspace_dictionary_label;
        this.fDictionaryPath = this.addTextField((Composite)engine, label, PREF_SPELLING_USER_DICTIONARY, 0, 0);
        GridData gd = (GridData)this.fDictionaryPath.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = converter.convertWidthInCharsToPixels(40);
        allControls.add(this.fDictionaryPath);
        allControls.add(this.fLabels.get(this.fDictionaryPath));
        Button button = new Button((Composite)engine, 8);
        button.setText(PreferencesMessages.SpellingPreferencePage_browse_label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpellingConfigurationBlock.this.handleBrowseButtonSelected();
            }
        });
        button.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(button);
        allControls.add(button);
        Group advanced = new Group(composite, 0);
        advanced.setText(PreferencesMessages.SpellingPreferencePage_preferences_advanced);
        advanced.setLayout((Layout)new GridLayout(3, false));
        advanced.setLayoutData((Object)new GridData(768));
        allControls.add(advanced);
        label = PreferencesMessages.SpellingPreferencePage_proposals_threshold;
        Text text = this.addTextField((Composite)advanced, label, PREF_SPELLING_PROPOSAL_THRESHOLD, 0, 0);
        text.setTextLimit(3);
        gd = new GridData(32);
        gd.widthHint = converter.convertWidthInCharsToPixels(4);
        text.setLayoutData((Object)gd);
        allControls.add(text);
        allControls.add(this.fLabels.get(text));
        label = PreferencesMessages.SpellingPreferencePage_enable_contentassist_label;
        button = this.addCheckBox((Composite)advanced, label, PREF_SPELLING_ENABLE_CONTENTASSIST, trueFalse, 0);
        allControls.add(button);
        this.fAllControls = allControls.toArray(new Control[allControls.size()]);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.java_editor_preference_page_context");
        return composite;
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_SPELLING_USER_DICTIONARY, PREF_SPELLING_IGNORE_DIGITS, PREF_SPELLING_IGNORE_MIXED, PREF_SPELLING_IGNORE_SENTENCE, PREF_SPELLING_IGNORE_UPPER, PREF_SPELLING_IGNORE_URLS, PREF_SPELLING_LOCALE, PREF_SPELLING_PROPOSAL_THRESHOLD, PREF_SPELLING_ENABLE_CONTENTASSIST};
    }

    protected final String[] getFullBuildDialogStrings(boolean workspace) {
        return null;
    }

    protected void handleBrowseButtonSelected() {
        FileDialog dialog = new FileDialog(this.fDictionaryPath.getShell(), 4096);
        dialog.setText(PreferencesMessages.SpellingPreferencePage_filedialog_title);
        dialog.setFilterExtensions(new String[]{PreferencesMessages.SpellingPreferencePage_filter_dictionary_extension, PreferencesMessages.SpellingPreferencePage_filter_all_extension});
        dialog.setFilterNames(new String[]{PreferencesMessages.SpellingPreferencePage_filter_dictionary_label, PreferencesMessages.SpellingPreferencePage_filter_all_label});
        String path = dialog.open();
        if (path != null) {
            this.fDictionaryPath.setText(path);
        }
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String oldValue, String newValue) {
        if (key == null || PREF_SPELLING_PROPOSAL_THRESHOLD.equals(key)) {
            this.fThresholdStatus = SpellingConfigurationBlock.validatePositiveNumber(this.getValue(PREF_SPELLING_PROPOSAL_THRESHOLD));
        }
        if (key == null || PREF_SPELLING_USER_DICTIONARY.equals(key)) {
            this.fFileStatus = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        }
        this.fContext.statusChanged(StatusUtil.getMostSevere(new IStatus[]{this.fThresholdStatus, this.fFileStatus}));
    }

    protected void updateCheckBox(Button curr) {
        super.updateCheckBox(curr);
        Event event = new Event();
        event.type = 13;
        event.display = curr.getDisplay();
        event.widget = curr;
        curr.notifyListeners(13, event);
    }

    protected void setEnabled(boolean enabled) {
        if (enabled && this.fEnabledControls != null) {
            int i = this.fEnabledControls.length - 1;
            while (i >= 0) {
                this.fEnabledControls[i].setEnabled(true);
                --i;
            }
            this.fEnabledControls = null;
        }
        if (!enabled && this.fEnabledControls == null) {
            ArrayList<Control> enabledControls = new ArrayList<Control>();
            int i = this.fAllControls.length - 1;
            while (i >= 0) {
                Control control = this.fAllControls[i];
                if (control.isEnabled()) {
                    enabledControls.add(control);
                    control.setEnabled(false);
                }
                --i;
            }
            this.fEnabledControls = enabledControls.toArray(new Control[enabledControls.size()]);
        }
    }
}

