/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.InstructionPointerContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class InstructionPointerManager {
    private static InstructionPointerManager fgDefault;
    private Map fDebugTargetMap = new HashMap();

    private InstructionPointerManager() {
    }

    public static InstructionPointerManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new InstructionPointerManager();
        }
        return fgDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(ITextEditor textEditor, IStackFrame frame, Annotation annotation) {
        IEditorInput editorInput;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)(editorInput = textEditor.getEditorInput()));
        if (annModel == null) {
            return;
        }
        Position position = null;
        int charStart = -1;
        int length = -1;
        try {
            charStart = frame.getCharStart();
            length = frame.getCharEnd() - charStart;
        }
        catch (DebugException debugException) {}
        if (charStart < 0) {
            IDocument doc = docProvider.getDocument((Object)editorInput);
            if (doc == null) {
                return;
            }
            try {
                int lineNumber = frame.getLineNumber() - 1;
                IRegion region = doc.getLineInformation(lineNumber);
                charStart = region.getOffset();
                length = region.getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            catch (DebugException debugException) {
                return;
            }
        }
        if (charStart < 0) {
            return;
        }
        position = new Position(charStart, length);
        if (frame.isTerminated()) {
            return;
        }
        Map map = this.fDebugTargetMap;
        synchronized (map) {
            IThread thread;
            ArrayList<InstructionPointerContext> contextList;
            annModel.removeAnnotation(annotation);
            annModel.addAnnotation(annotation, position);
            IDebugTarget debugTarget = frame.getDebugTarget();
            HashMap threadMap = (HashMap)this.fDebugTargetMap.get(debugTarget);
            if (threadMap == null) {
                threadMap = new HashMap();
                this.fDebugTargetMap.put(debugTarget, threadMap);
            }
            if ((contextList = (ArrayList<InstructionPointerContext>)threadMap.get(thread = frame.getThread())) == null) {
                contextList = new ArrayList<InstructionPointerContext>();
                threadMap.put(thread, contextList);
            }
            InstructionPointerContext context = new InstructionPointerContext(textEditor, annotation);
            contextList.remove(context);
            contextList.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(IDebugTarget debugTarget) {
        Map map = this.fDebugTargetMap;
        synchronized (map) {
            Map threadMap = (Map)this.fDebugTargetMap.get(debugTarget);
            if (threadMap == null) {
                return;
            }
            Object[] threads = threadMap.keySet().toArray();
            int i = 0;
            while (i < threads.length) {
                IThread thread = (IThread)threads[i];
                this.removeAnnotations(thread, threadMap);
                ++i;
            }
            this.fDebugTargetMap.remove(debugTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(IThread thread) {
        Map map = this.fDebugTargetMap;
        synchronized (map) {
            IDebugTarget debugTarget = thread.getDebugTarget();
            Map threadMap = (Map)this.fDebugTargetMap.get(debugTarget);
            if (threadMap == null) {
                return;
            }
            this.removeAnnotations(thread, threadMap);
            if (threadMap.isEmpty()) {
                this.fDebugTargetMap.remove(debugTarget);
            }
        }
    }

    private void removeAnnotations(IThread thread, Map threadMap) {
        List contextList = (List)threadMap.get(thread);
        if (contextList != null) {
            for (InstructionPointerContext context : contextList) {
                this.removeAnnotation(context.getTextEditor(), context.getAnnotation());
            }
        }
        threadMap.remove(thread);
    }

    private void removeAnnotation(ITextEditor textEditor, Annotation annotation) {
        IAnnotationModel annotationModel;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        if (docProvider != null && (annotationModel = docProvider.getAnnotationModel((Object)textEditor.getEditorInput())) != null) {
            annotationModel.removeAnnotation(annotation);
        }
    }

    public int getCachedTargetCount() {
        return this.fDebugTargetMap.size();
    }
}

