/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ccvs.ui.CVSDecoration;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipantLabelDecorator;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardCommitPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardFileTypePage;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class CommitWizardParticipant
extends WorkspaceSynchronizeParticipant {
    final CommitWizard fWizard;

    public CommitWizardParticipant(ISynchronizeScope scope, CommitWizard wizard) {
        super(scope);
        this.fWizard = wizard;
    }

    protected ILabelDecorator getLabelDecorator(ISynchronizePageConfiguration configuration) {
        return new Decorator(configuration, this.fWizard);
    }

    public ChangeSetCapability getChangeSetCapability() {
        return null;
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.setProperty("org.eclipse.team.ui.P_TOOLBAR_MENU", (Object)new String[]{"layout"});
        configuration.setProperty("org.eclipse.team.ui.P_CONTEXT_MENU", (Object)ISynchronizePageConfiguration.DEFAULT_CONTEXT_MENU);
        configuration.addActionContribution((SynchronizePageActionGroup)new ActionContribution());
        configuration.setRunnableContext(new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                CommitWizardParticipant.this.fWizard.getContainer().run(fork, cancelable, runnable);
                CommitWizardCommitPage page = CommitWizardParticipant.this.fWizard.getCommitPage();
                if (page != null) {
                    page.updateEnablements();
                }
            }
        });
        configuration.setSupportedModes(2);
        configuration.setMode(2);
    }

    public boolean doesSupportSynchronize() {
        return false;
    }

    private class ActionContribution
    extends SynchronizePageActionGroup {
        private ActionContribution() {
        }

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "additions", (IAction)new CVSActionDelegateWrapper(new IgnoreAction(), configuration));
        }

        public void modelChanged(ISynchronizeModelElement root) {
            super.modelChanged(root);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    CommitWizardCommitPage page = ((ActionContribution)ActionContribution.this).CommitWizardParticipant.this.fWizard.getCommitPage();
                    if (page != null) {
                        page.updateForModelChange();
                    }
                }
            });
        }
    }

    private static class Decorator
    extends CVSParticipantLabelDecorator {
        private final CommitWizard fWizard;

        public Decorator(ISynchronizePageConfiguration configuration, CommitWizard wizard) {
            super(configuration);
            this.fWizard = wizard;
        }

        protected CVSDecoration getDecoration(IResource resource) throws CoreException {
            CVSDecoration decoration = super.getDecoration(resource);
            CommitWizardFileTypePage page = this.fWizard.getFileTypePage();
            if (page != null && resource instanceof IFile) {
                decoration.setKeywordSubstitution(page.getOption((IFile)resource).getShortDisplayText());
            }
            return decoration;
        }
    }
}

