/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;

public class RubyElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int STATIC = 8;
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    public static final int OVERRIDES = 128;
    public static final int IMPLEMENTS = 256;
    public static final int CONSTRUCTOR = 512;
    public static final int DEPRECATED = 1024;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    static /* synthetic */ Class class$0;

    public RubyElementImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
        this.fBaseImage = imageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = n;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = point;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int n) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        this.fFlags = n;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point point) {
        Assert.isNotNull((Object)point);
        Assert.isTrue((point.x >= 0 && point.y >= 0 ? 1 : 0) != 0);
        this.fSize = point;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        block8: {
            block7: {
                if (object == null) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.rubypeople.rdt.ui.RubyElementImageDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass())) break block8;
            }
            return false;
        }
        RubyElementImageDescriptor rubyElementImageDescriptor = (RubyElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(rubyElementImageDescriptor.fBaseImage) && this.fFlags == rubyElementImageDescriptor.fFlags && this.fSize.equals((Object)rubyElementImageDescriptor.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int n, int n2) {
        ImageData imageData = this.getImageData(this.fBaseImage);
        if ((this.fFlags & 0x400) != 0) {
            Point point = this.getSize();
            ImageData imageData2 = this.getImageData(RubyPluginImages.DESC_OVR_DEPRECATED);
            this.drawImage(imageData2, 0, point.y - imageData2.height);
        }
        this.drawImage(imageData, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData imageData = imageDescriptor.getImageData();
        if (imageData == null) {
            imageData = DEFAULT_IMAGE_DATA;
            RubyPlugin.logErrorMessage("Image data not available: " + imageDescriptor.toString());
        }
        return imageData;
    }

    private void drawTopRight() {
        ImageData imageData;
        int n = this.getSize().x;
        if ((this.fFlags & 0x200) != 0) {
            imageData = this.getImageData(RubyPluginImages.DESC_OVR_CONSTRUCTOR);
            this.drawImage(imageData, n -= imageData.width, 0);
        }
        if ((this.fFlags & 8) != 0) {
            imageData = this.getImageData(RubyPluginImages.DESC_OVR_STATIC);
            this.drawImage(imageData, n -= imageData.width, 0);
        }
    }

    private void drawBottomRight() {
        ImageData imageData;
        Point point = this.getSize();
        int n = point.x;
        int n2 = this.fFlags;
        if ((n2 & 0x80) != 0) {
            imageData = this.getImageData(RubyPluginImages.DESC_OVR_OVERRIDES);
            this.drawImage(imageData, n -= imageData.width, point.y - imageData.height);
        }
        if ((n2 & 0x100) != 0) {
            imageData = this.getImageData(RubyPluginImages.DESC_OVR_IMPLEMENTS);
            this.drawImage(imageData, n -= imageData.width, point.y - imageData.height);
        }
    }

    private void drawBottomLeft() {
        ImageData imageData;
        Point point = this.getSize();
        int n = 0;
        if ((this.fFlags & 0x40) != 0) {
            imageData = this.getImageData(RubyPluginImages.DESC_OVR_ERROR);
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            imageData = this.getImageData(RubyPluginImages.DESC_OVR_WARNING);
            this.drawImage(imageData, n, point.y - imageData.height);
            n += imageData.width;
        }
    }
}

